/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.khataly.mapkit.config;

import com.cobblemon.khataly.mapkit.CobblemonMapKitMod;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7924;

public class GrassZonesConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File CONFIG_FILE = new File("config/cobblemonmapkit/grass_zones.json");
    private static final int CURRENT_SCHEMA_VERSION = 2;
    private static final Map<UUID, Zone> ZONES = new LinkedHashMap<UUID, Zone>();

    public static void load() {
        if (!CONFIG_FILE.exists()) {
            CobblemonMapKitMod.LOGGER.info("[GrassZonesConfig] Config file not found, creating empty.");
            GrassZonesConfig.safeRewrite(Collections.emptyList());
            return;
        }
        ArrayList<Zone> loaded = new ArrayList<Zone>();
        boolean clean = true;
        try (FileReader r = new FileReader(CONFIG_FILE);){
            int ver;
            ConfigData data = (ConfigData)GSON.fromJson((Reader)r, ConfigData.class);
            if (data == null || data.zones == null) {
                clean = false;
            }
            int n = ver = data != null && data.schemaVersion != null ? data.schemaVersion : 2;
            if (ver != 2) {
                CobblemonMapKitMod.LOGGER.warn("[GrassZonesConfig] schemaVersion {} != {} \u2014 rewriting.", (Object)ver, (Object)2);
                clean = false;
            }
            if (data != null && data.zones != null) {
                for (ZoneData zd : data.zones) {
                    try {
                        UUID id = UUID.fromString(zd.id);
                        class_2960 wid = class_2960.method_12829((String)zd.worldKey);
                        if (wid == null) {
                            throw new IllegalArgumentException("bad worldKey");
                        }
                        class_5321 wk = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)wid);
                        ArrayList<SpawnEntry> spawns = new ArrayList<SpawnEntry>();
                        if (zd.spawns != null) {
                            for (SpawnData sd : zd.spawns) {
                                if (sd == null || sd.species == null || sd.species.isBlank() || sd.minLevel <= 0 || sd.maxLevel < sd.minLevel || sd.weight <= 0) {
                                    CobblemonMapKitMod.LOGGER.warn("[GrassZonesConfig] Invalid spawn in zone {}: {}", (Object)zd.id, (Object)sd);
                                    clean = false;
                                    continue;
                                }
                                spawns.add(new SpawnEntry(sd.species, sd.minLevel, sd.maxLevel, sd.weight, GrassZonesConfig.parseTime(sd.time), sd.aspect));
                            }
                        }
                        long t = zd.timeCreated == 0L ? Instant.now().toEpochMilli() : zd.timeCreated;
                        int shinyOdds = zd.shinyOdds == null || zd.shinyOdds <= 0 ? -1 : zd.shinyOdds;
                        loaded.add(new Zone(id, (class_5321<class_1937>)wk, zd.minX, zd.minZ, zd.maxX, zd.maxZ, zd.y, t, spawns, shinyOdds));
                    }
                    catch (Exception ex) {
                        CobblemonMapKitMod.LOGGER.warn("[GrassZonesConfig] Invalid zone, skipping: {}", (Object)(zd != null ? zd.id : "<null>"));
                        clean = false;
                    }
                }
            }
        }
        catch (Exception e) {
            CobblemonMapKitMod.LOGGER.error("[GrassZonesConfig] Read error, rewriting: {}", (Object)e.getMessage(), (Object)e);
            clean = false;
        }
        if (!clean) {
            GrassZonesConfig.safeRewrite(loaded);
        } else {
            ZONES.clear();
            for (Zone z : loaded) {
                ZONES.put(z.id(), z);
            }
            CobblemonMapKitMod.LOGGER.info("[GrassZonesConfig] Loaded {} zones.", (Object)ZONES.size());
        }
    }

    private static TimeBand parseTime(String s) {
        if (s == null) {
            return TimeBand.BOTH;
        }
        return switch (s.toLowerCase(Locale.ROOT)) {
            case "day" -> TimeBand.DAY;
            case "night" -> TimeBand.NIGHT;
            default -> TimeBand.BOTH;
        };
    }

    public static boolean overlaps(class_5321<class_1937> worldKey, int minX, int minZ, int maxX, int maxZ, int y) {
        int aMinX = Math.min(minX, maxX);
        int aMaxX = Math.max(minX, maxX);
        int aMinZ = Math.min(minZ, maxZ);
        int aMaxZ = Math.max(minZ, maxZ);
        for (Zone z : ZONES.values()) {
            boolean zOverlap;
            if (!z.worldKey().equals(worldKey) || z.y() != y) continue;
            boolean xOverlap = aMinX <= z.maxX() && aMaxX >= z.minX();
            boolean bl = zOverlap = aMinZ <= z.maxZ() && aMaxZ >= z.minZ();
            if (!xOverlap || !zOverlap) continue;
            return true;
        }
        return false;
    }

    public static boolean overlaps(class_5321<class_1937> worldKey, int minX, int minZ, int maxX, int maxZ) {
        int aMinX = Math.min(minX, maxX);
        int aMaxX = Math.max(minX, maxX);
        int aMinZ = Math.min(minZ, maxZ);
        int aMaxZ = Math.max(minZ, maxZ);
        for (Zone z : ZONES.values()) {
            boolean zOverlap;
            if (!z.worldKey().equals(worldKey)) continue;
            boolean xOverlap = aMinX <= z.maxX() && aMaxX >= z.minX();
            boolean bl = zOverlap = aMinZ <= z.maxZ() && aMaxZ >= z.minZ();
            if (!xOverlap || !zOverlap) continue;
            return true;
        }
        return false;
    }

    public static void save() {
        try {
            boolean created;
            File dir = CONFIG_FILE.getParentFile();
            if (!(dir == null || dir.exists() || (created = dir.mkdirs()) || dir.exists())) {
                CobblemonMapKitMod.LOGGER.warn("[GrassZonesConfig] Unable to create config directory: {}", (Object)dir.getAbsolutePath());
            }
            ConfigData out = new ConfigData();
            out.schemaVersion = 2;
            for (Zone z : ZONES.values()) {
                ZoneData zd = new ZoneData();
                zd.id = z.id().toString();
                zd.worldKey = z.worldKey().method_29177().toString();
                zd.minX = z.minX();
                zd.minZ = z.minZ();
                zd.maxX = z.maxX();
                zd.maxZ = z.maxZ();
                zd.y = z.y();
                zd.timeCreated = z.timeCreated();
                zd.shinyOdds = z.shinyOdds() <= 0 ? -1 : z.shinyOdds();
                for (SpawnEntry se : z.spawns()) {
                    SpawnData sd = new SpawnData();
                    sd.species = se.species;
                    sd.minLevel = se.minLevel;
                    sd.maxLevel = se.maxLevel;
                    sd.weight = se.weight;
                    sd.time = se.time.name().toLowerCase(Locale.ROOT);
                    if (se.aspect != null && !se.aspect.isBlank()) {
                        sd.aspect = se.aspect;
                    }
                    zd.spawns.add(sd);
                }
                out.zones.add(zd);
            }
            File tmp = new File(CONFIG_FILE.getParent(), CONFIG_FILE.getName() + ".tmp");
            try (FileWriter w = new FileWriter(tmp);){
                GSON.toJson((Object)out, (Appendable)w);
            }
            try {
                Files.move(tmp.toPath(), CONFIG_FILE.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
            }
            catch (IOException atomicNotSupported) {
                CobblemonMapKitMod.LOGGER.debug("[GrassZonesConfig] ATOMIC_MOVE not supported, falling back to REPLACE_EXISTING.");
                Files.move(tmp.toPath(), CONFIG_FILE.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException e) {
            CobblemonMapKitMod.LOGGER.error("[GrassZonesConfig] Save error: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public static UUID addZone(class_5321<class_1937> worldKey, int minX, int minZ, int maxX, int maxZ, int y, List<SpawnEntry> spawns) {
        return GrassZonesConfig.addZone(worldKey, minX, minZ, maxX, maxZ, y, spawns, -1);
    }

    public static UUID addZone(class_5321<class_1937> worldKey, int minX, int minZ, int maxX, int maxZ, int y, List<SpawnEntry> spawns, int shinyOdds) {
        UUID id = UUID.randomUUID();
        Zone z = new Zone(id, worldKey, minX, minZ, maxX, maxZ, y, Instant.now().toEpochMilli(), spawns == null ? List.of() : spawns, shinyOdds);
        ZONES.put(id, z);
        GrassZonesConfig.save();
        return id;
    }

    public static boolean removeZone(UUID id) {
        if (ZONES.remove(id) != null) {
            GrassZonesConfig.save();
            return true;
        }
        return false;
    }

    public static Collection<Zone> getAll() {
        return Collections.unmodifiableCollection(ZONES.values());
    }

    public static Zone get(UUID id) {
        return ZONES.get(id);
    }

    public static List<Zone> findAt(class_5321<class_1937> wk, int x, int y, int z) {
        ArrayList<Zone> out = new ArrayList<Zone>();
        for (Zone z0 : ZONES.values()) {
            if (!z0.contains(x, y, z, wk)) continue;
            out.add(z0);
        }
        return out;
    }

    public static boolean addSpawn(UUID zoneId, SpawnEntry entry) {
        Zone z = ZONES.get(zoneId);
        if (z == null) {
            return false;
        }
        ArrayList<SpawnEntry> ns = new ArrayList<SpawnEntry>(z.spawns());
        ns.add(entry);
        ZONES.put(zoneId, z.withSpawns(ns));
        GrassZonesConfig.save();
        return true;
    }

    public static boolean removeSpawn(UUID zoneId, String speciesId) {
        Zone z = ZONES.get(zoneId);
        if (z == null) {
            return false;
        }
        ArrayList<SpawnEntry> ns = new ArrayList<SpawnEntry>();
        for (SpawnEntry e : z.spawns()) {
            if (e.species.equalsIgnoreCase(speciesId)) continue;
            ns.add(e);
        }
        ZONES.put(zoneId, z.withSpawns(ns));
        GrassZonesConfig.save();
        return true;
    }

    public static boolean setZoneShinyOdds(UUID zoneId, int shinyOdds) {
        Zone z = ZONES.get(zoneId);
        if (z == null) {
            return false;
        }
        ZONES.put(zoneId, z.withShinyOdds(shinyOdds));
        GrassZonesConfig.save();
        return true;
    }

    private static void safeRewrite(List<Zone> valid) {
        try {
            boolean created;
            File dir = CONFIG_FILE.getParentFile();
            if (!(dir == null || dir.exists() || (created = dir.mkdirs()) || dir.exists())) {
                CobblemonMapKitMod.LOGGER.warn("[GrassZonesConfig] Unable to create directory: {}", (Object)dir.getAbsolutePath());
            }
            ZONES.clear();
            if (valid != null) {
                for (Zone z : valid) {
                    ZONES.put(z.id(), z);
                }
            }
            GrassZonesConfig.save();
            CobblemonMapKitMod.LOGGER.info("[GrassZonesConfig] File rebuilt with {} zones.", (Object)ZONES.size());
        }
        catch (Exception ex) {
            CobblemonMapKitMod.LOGGER.error("[GrassZonesConfig] Safe rewrite error: {}", (Object)ex.getMessage(), (Object)ex);
        }
    }

    private static class ConfigData {
        Integer schemaVersion;
        List<ZoneData> zones = new ArrayList<ZoneData>();

        private ConfigData() {
        }
    }

    private static class ZoneData {
        String id;
        String worldKey;
        int minX;
        int minZ;
        int maxX;
        int maxZ;
        int y;
        long timeCreated;
        List<SpawnData> spawns = new ArrayList<SpawnData>();
        Integer shinyOdds;

        private ZoneData() {
        }
    }

    private static class SpawnData {
        String species;
        int minLevel;
        int maxLevel;
        int weight;
        String time;
        String aspect;

        private SpawnData() {
        }
    }

    public static final class SpawnEntry {
        public final String species;
        public final int minLevel;
        public final int maxLevel;
        public final int weight;
        public final TimeBand time;
        public final String aspect;

        public SpawnEntry(String species, int minLevel, int maxLevel, int weight, TimeBand time, String aspect) {
            this.species = species;
            this.minLevel = minLevel;
            this.maxLevel = maxLevel;
            this.weight = weight;
            this.time = time == null ? TimeBand.BOTH : time;
            this.aspect = aspect != null && !aspect.isBlank() ? aspect : null;
        }

        public SpawnEntry(String species, int minLevel, int maxLevel, int weight, TimeBand time) {
            this(species, minLevel, maxLevel, weight, time, null);
        }

        public SpawnEntry(String species, int minLevel, int maxLevel, int weight) {
            this(species, minLevel, maxLevel, weight, TimeBand.BOTH, null);
        }
    }

    public static enum TimeBand {
        DAY,
        NIGHT,
        BOTH;

    }

    public static final class Zone {
        private final UUID id;
        private final class_5321<class_1937> worldKey;
        private final int minX;
        private final int minZ;
        private final int maxX;
        private final int maxZ;
        private final int y;
        private final long timeCreated;
        private final List<SpawnEntry> spawns;
        private final int shinyOdds;

        public Zone(UUID id, class_5321<class_1937> worldKey, int minX, int minZ, int maxX, int maxZ, int y, long timeCreated, List<SpawnEntry> spawns, int shinyOdds) {
            this.id = id;
            this.worldKey = worldKey;
            this.minX = Math.min(minX, maxX);
            this.minZ = Math.min(minZ, maxZ);
            this.maxX = Math.max(minX, maxX);
            this.maxZ = Math.max(minZ, maxZ);
            this.y = y;
            this.timeCreated = timeCreated;
            this.spawns = List.copyOf(spawns == null ? List.of() : spawns);
            this.shinyOdds = shinyOdds <= 0 ? -1 : shinyOdds;
        }

        public boolean contains(int x, int y, int z, class_5321<class_1937> w) {
            if (!w.equals(this.worldKey)) {
                return false;
            }
            if (y != this.y) {
                return false;
            }
            return x >= this.minX && x <= this.maxX && z >= this.minZ && z <= this.maxZ;
        }

        public UUID id() {
            return this.id;
        }

        public class_5321<class_1937> worldKey() {
            return this.worldKey;
        }

        public int minX() {
            return this.minX;
        }

        public int minZ() {
            return this.minZ;
        }

        public int maxX() {
            return this.maxX;
        }

        public int maxZ() {
            return this.maxZ;
        }

        public int y() {
            return this.y;
        }

        public long timeCreated() {
            return this.timeCreated;
        }

        public List<SpawnEntry> spawns() {
            return this.spawns;
        }

        public int shinyOdds() {
            return this.shinyOdds;
        }

        public Zone withShinyOdds(int shinyOdds) {
            return new Zone(this.id, this.worldKey, this.minX, this.minZ, this.maxX, this.maxZ, this.y, this.timeCreated, this.spawns, shinyOdds);
        }

        public Zone withSpawns(List<SpawnEntry> newSpawns) {
            return new Zone(this.id, this.worldKey, this.minX, this.minZ, this.maxX, this.maxZ, this.y, this.timeCreated, newSpawns, this.shinyOdds);
        }
    }
}

