/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.khataly.mapkit.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HMConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(HMConfig.class);
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().serializeNulls().create();
    private static final File CONFIG_FILE = new File("config/cobblemonmapkit/hm.json");
    public static int ROCKSMASH_RESPAWN = 60;
    public static int CUT_RESPAWN = 60;
    public static int STRENGTH_RESPAWN = 60;
    public static int FLASH_DURATION = 60;
    public static RequiredItem ROCKSMASH = new RequiredItem("mapkit:steel_badge", "\u274c You need the Steel Badge to use Rock Smash!");
    public static RequiredItem FLY = new RequiredItem(null, "\u274c You need a special item to use Fly!");
    public static RequiredItem CUT = new RequiredItem(null, "\u274c You need a knife or machete to use Cut!");
    public static RequiredItem STRENGTH = new RequiredItem(null, "\u274c You need a heavy item to use Strength!");
    public static RequiredItem FLASH = new RequiredItem(null, "\u274c You need a Flash Item to use Flash!");
    public static RequiredItem TELEPORT = new RequiredItem(null, "\u274c You need a Teleport Item to use Teleport!");
    public static RequiredItem ROCKCLIMB = new RequiredItem(null, "\u274c You need climbing gear to use Rock Climb!");
    public static RequiredItem ULTRAHOLE = new RequiredItem(null, "\u274c You need Ultrabeast to summon a Ultra Hole!");
    public static UltraHoleSettings ULTRAHOLE_SETTINGS = new UltraHoleSettings("minecraft:the_end", 0.0, 64.0, 0.0, 800);

    public static void load() {
        try {
            boolean missingItem;
            if (!CONFIG_FILE.exists()) {
                HMConfig.save();
                return;
            }
            String jsonContent = Files.readString(CONFIG_FILE.toPath());
            if (!(jsonContent.contains("\"respawn_time_seconds\"") && jsonContent.contains("\"flash_duration_seconds\"") && jsonContent.contains("\"required_items\"") && jsonContent.contains("\"ultrahole_settings\""))) {
                LOGGER.warn("\u26a0\ufe0f Config obsolete or corrupted, regenerating con valori di default.");
                if (!CONFIG_FILE.delete()) {
                    LOGGER.error("\u26a0\ufe0f Cannot delete config file: {}", (Object)CONFIG_FILE.getAbsolutePath());
                }
                HMConfig.save();
                return;
            }
            FileReader reader = new FileReader(CONFIG_FILE);
            ConfigData data = (ConfigData)GSON.fromJson((Reader)reader, ConfigData.class);
            reader.close();
            boolean bl = missingItem = data.required_items == null || data.required_items.rocksmash == null || data.required_items.fly == null || data.required_items.cut == null || data.required_items.strength == null || data.required_items.flash == null || data.required_items.teleport == null || data.required_items.rockclimb == null || data.required_items.ultrahole == null || data.ultrahole_settings == null || data.ultrahole_settings.destinationDimension == null;
            if (missingItem) {
                LOGGER.warn("\u26a0\ufe0f Uno o pi\u00f9 RequiredItems o UltraHole settings mancanti, rigenero il config.");
                if (!CONFIG_FILE.delete()) {
                    LOGGER.error("\u26a0\ufe0f Cannot delete config file: {}", (Object)CONFIG_FILE.getAbsolutePath());
                }
                HMConfig.save();
                return;
            }
            if (data.respawn_time_seconds != null) {
                ROCKSMASH_RESPAWN = data.respawn_time_seconds.rocksmash;
                CUT_RESPAWN = data.respawn_time_seconds.cut;
                STRENGTH_RESPAWN = data.respawn_time_seconds.strength;
            }
            if (data.flash_duration_seconds != null) {
                FLASH_DURATION = data.flash_duration_seconds;
            }
            ROCKSMASH = data.required_items.rocksmash;
            FLY = data.required_items.fly;
            CUT = data.required_items.cut;
            STRENGTH = data.required_items.strength;
            FLASH = data.required_items.flash;
            TELEPORT = data.required_items.teleport;
            ROCKCLIMB = data.required_items.rockclimb;
            ULTRAHOLE = data.required_items.ultrahole;
            ULTRAHOLE_SETTINGS = data.ultrahole_settings;
        }
        catch (IOException e) {
            LOGGER.error("Error loading configuration file", (Throwable)e);
        }
    }

    public static void save() {
        try {
            File parent = CONFIG_FILE.getParentFile();
            if (parent != null && !parent.exists() && !parent.mkdirs()) {
                LOGGER.warn("\u26a0\ufe0f Cannot create configuration directory: {}", (Object)parent.getAbsolutePath());
            }
            ConfigData data = new ConfigData();
            data.respawn_time_seconds.rocksmash = ROCKSMASH_RESPAWN;
            data.respawn_time_seconds.cut = CUT_RESPAWN;
            data.respawn_time_seconds.strength = STRENGTH_RESPAWN;
            data.flash_duration_seconds = FLASH_DURATION;
            data.required_items.rocksmash = ROCKSMASH;
            data.required_items.fly = FLY;
            data.required_items.cut = CUT;
            data.required_items.strength = STRENGTH;
            data.required_items.flash = FLASH;
            data.required_items.teleport = TELEPORT;
            data.required_items.rockclimb = ROCKCLIMB;
            data.required_items.ultrahole = ULTRAHOLE;
            data.ultrahole_settings = ULTRAHOLE_SETTINGS;
            FileWriter writer = new FileWriter(CONFIG_FILE);
            GSON.toJson((Object)data, (Appendable)writer);
            writer.close();
        }
        catch (IOException e) {
            LOGGER.error("Error saving configuration file", (Throwable)e);
        }
    }

    private static class ConfigData {
        RespawnTimes respawn_time_seconds = new RespawnTimes();
        Integer flash_duration_seconds = FLASH_DURATION;
        RequiredItems required_items = new RequiredItems();
        UltraHoleSettings ultrahole_settings = new UltraHoleSettings();

        private ConfigData() {
        }
    }

    private static class RequiredItems {
        RequiredItem rocksmash = null;
        RequiredItem fly = null;
        RequiredItem cut = null;
        RequiredItem strength = null;
        RequiredItem flash = null;
        RequiredItem teleport = null;
        RequiredItem rockclimb = null;
        RequiredItem ultrahole = null;

        private RequiredItems() {
        }
    }

    public static class RequiredItem {
        public String item;
        public String message;

        public RequiredItem() {
        }

        public RequiredItem(String item, String message) {
            this.item = item;
            this.message = message;
        }
    }

    public static class UltraHoleSettings {
        public String destinationDimension;
        public double x;
        public double y;
        public double z;
        public int durationTicks;

        public UltraHoleSettings() {
            this.destinationDimension = "minecraft:the_end";
            this.x = 0.0;
            this.y = 64.0;
            this.z = 0.0;
            this.durationTicks = 800;
        }

        public UltraHoleSettings(String destinationDimension, double x, double y, double z, int durationTicks) {
            this.destinationDimension = destinationDimension;
            this.x = x;
            this.y = y;
            this.z = z;
            this.durationTicks = durationTicks;
        }
    }

    private static class RespawnTimes {
        int rocksmash = ROCKSMASH_RESPAWN;
        int cut = CUT_RESPAWN;
        int strength = STRENGTH_RESPAWN;

        private RespawnTimes() {
        }
    }
}

