/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.khataly.mapkit.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;
import net.minecraft.class_2960;

public class LevelCapConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File CONFIG_FILE = new File("config/cobblemonmapkit/levelcap.json");
    private static final int CURRENT_SCHEMA_VERSION = 5;
    private static boolean enabled = true;
    private static int baseCap = 20;
    private static boolean bypassIfShiny = false;
    private static boolean bypassOnMasterBall = false;
    private static boolean clampGainedOverCap = true;
    private static boolean clampCapturedOverCap = true;
    private static final Map<String, Progression> progressions = new LinkedHashMap<String, Progression>();

    public static void load() {
        if (!CONFIG_FILE.exists()) {
            LevelCapConfig.logInfo("Config not found. Creating defaults...");
            LevelCapConfig.applyDefaults();
            LevelCapConfig.save();
            return;
        }
        boolean clean = true;
        boolean loadedEnabled = true;
        int loadedBase = 20;
        boolean loadedShiny = false;
        boolean loadedMaster = false;
        boolean loadedClampGained = true;
        boolean loadedClampCaptured = true;
        LinkedHashMap<String, Progression> loaded = new LinkedHashMap<String, Progression>();
        try (FileReader r = new FileReader(CONFIG_FILE);){
            ConfigData d = (ConfigData)GSON.fromJson((Reader)r, ConfigData.class);
            if (d == null) {
                clean = false;
            } else {
                Integer ver = d.schemaVersion == null ? 5 : d.schemaVersion;
                if (!Objects.equals(ver, 5)) {
                    LevelCapConfig.logWarn("Schema " + ver + " differs from 5 \u2014 will rewrite file.");
                    clean = false;
                }
                loadedEnabled = d.enabled == null || d.enabled != false;
                loadedBase = d.baseCap == null ? 20 : Math.max(1, d.baseCap);
                loadedShiny = d.bypassIfShiny != null && d.bypassIfShiny != false;
                loadedMaster = d.bypassOnMasterBall != null && d.bypassOnMasterBall != false;
                loadedClampGained = d.clampGainedOverCap == null || d.clampGainedOverCap != false;
                boolean bl = loadedClampCaptured = d.clampCapturedOverCap == null || d.clampCapturedOverCap != false;
                if (d.progressions == null) {
                    clean = false;
                } else {
                    for (Progression p : d.progressions) {
                        if (!LevelCapConfig.isProgressionValid(p)) {
                            LevelCapConfig.logWarn("Invalid progression, skipping: " + LevelCapConfig.safeLabel(p));
                            clean = false;
                            continue;
                        }
                        String key = LevelCapConfig.normalizeLabel(p.label);
                        ArrayList<String> normItems = new ArrayList<String>();
                        if (p.itemIds != null) {
                            for (String s : p.itemIds) {
                                if (s == null || s.isBlank()) continue;
                                normItems.add(LevelCapConfig.normalizeId(s));
                            }
                        }
                        loaded.put(key, new Progression(p.label, Math.max(1, p.newCap), normItems));
                    }
                }
            }
        }
        catch (JsonParseException e) {
            LevelCapConfig.logError("Malformed JSON: " + e.getMessage(), e);
            clean = false;
        }
        catch (IOException e) {
            LevelCapConfig.logError("I/O error during load", e);
            clean = false;
        }
        enabled = loadedEnabled;
        baseCap = loadedBase;
        bypassIfShiny = loadedShiny;
        bypassOnMasterBall = loadedMaster;
        clampGainedOverCap = loadedClampGained;
        clampCapturedOverCap = loadedClampCaptured;
        progressions.clear();
        progressions.putAll(loaded);
        if (!clean) {
            LevelCapConfig.save();
            LevelCapConfig.logInfo("levelcap.json rewritten with " + progressions.size() + " progression entries.");
        } else {
            LevelCapConfig.logInfo("Config loaded: enabled=" + enabled + ", baseCap=" + baseCap + ", bypassShiny=" + bypassIfShiny + ", bypassMasterBall=" + bypassOnMasterBall + ", clampGained=" + clampGainedOverCap + ", clampCaptured=" + clampCapturedOverCap + ", progressions=" + progressions.size());
        }
    }

    public static void save() {
        try {
            File dir = CONFIG_FILE.getParentFile();
            if (dir != null && !dir.exists() && !dir.mkdirs()) {
                LevelCapConfig.logWarn("Could not create config dir: " + dir.getAbsolutePath());
            }
            ConfigData out = new ConfigData();
            out.schemaVersion = 5;
            out.enabled = enabled;
            out.baseCap = baseCap;
            out.bypassIfShiny = bypassIfShiny;
            out.bypassOnMasterBall = bypassOnMasterBall;
            out.clampGainedOverCap = clampGainedOverCap;
            out.clampCapturedOverCap = clampCapturedOverCap;
            out.progressions = new ArrayList<Progression>(progressions.values());
            File tmp = new File(CONFIG_FILE.getParent(), CONFIG_FILE.getName() + ".tmp");
            try (FileWriter w = new FileWriter(tmp);){
                GSON.toJson((Object)out, (Appendable)w);
            }
            try {
                Files.move(tmp.toPath(), CONFIG_FILE.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
            }
            catch (IOException atomicNotSupported) {
                Files.move(tmp.toPath(), CONFIG_FILE.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException e) {
            LevelCapConfig.logError("Error while saving levelcap.json", e);
        }
    }

    public static void reload() {
        LevelCapConfig.load();
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static void setEnabled(boolean v) {
        enabled = v;
        LevelCapConfig.save();
    }

    public static int getBaseCap() {
        return baseCap;
    }

    public static void setBaseCap(int v) {
        baseCap = Math.max(1, v);
        LevelCapConfig.save();
    }

    public static boolean isBypassIfShiny() {
        return bypassIfShiny;
    }

    public static void setBypassIfShiny(boolean v) {
        bypassIfShiny = v;
        LevelCapConfig.save();
    }

    public static boolean isBypassOnMasterBall() {
        return bypassOnMasterBall;
    }

    public static void setBypassOnMasterBall(boolean v) {
        bypassOnMasterBall = v;
        LevelCapConfig.save();
    }

    public static boolean isClampGainedOverCap() {
        return clampGainedOverCap;
    }

    public static void setClampGainedOverCap(boolean v) {
        clampGainedOverCap = v;
        LevelCapConfig.save();
    }

    public static boolean isClampCapturedOverCap() {
        return clampCapturedOverCap;
    }

    public static void setClampCapturedOverCap(boolean v) {
        clampCapturedOverCap = v;
        LevelCapConfig.save();
    }

    public static Map<String, Integer> getAllLabelsWithCaps() {
        LinkedHashMap<String, Integer> out = new LinkedHashMap<String, Integer>();
        for (Map.Entry<String, Progression> e : progressions.entrySet()) {
            out.put(e.getKey(), e.getValue().newCap);
        }
        return Collections.unmodifiableMap(out);
    }

    public static Progression getProgression(String label) {
        return progressions.get(LevelCapConfig.normalizeLabel(label));
    }

    public static void setLabelCap(String label, int newCap) {
        String key = LevelCapConfig.normalizeLabel(label);
        if (key.isEmpty()) {
            LevelCapConfig.logWarn("setLabelCap: empty label");
            return;
        }
        Progression p = progressions.get(key);
        if (p == null) {
            p = new Progression(label, Math.max(1, newCap), List.of());
            progressions.put(key, p);
        } else {
            p.label = label;
            p.newCap = Math.max(1, newCap);
        }
        LevelCapConfig.save();
    }

    public static boolean removeLabel(String label) {
        boolean removed;
        String key = LevelCapConfig.normalizeLabel(label);
        boolean bl = removed = progressions.remove(key) != null;
        if (removed) {
            LevelCapConfig.save();
        }
        return removed;
    }

    public static List<String> getItemIdsForLabel(String label) {
        Progression p = LevelCapConfig.getProgression(label);
        return p == null ? List.of() : Collections.unmodifiableList(p.itemIds);
    }

    public static boolean addItemIdToLabel(String label, String itemId) {
        Progression p = LevelCapConfig.getProgression(label);
        if (p == null) {
            LevelCapConfig.logWarn("addItemIdToLabel: unknown label " + label);
            return false;
        }
        String id = LevelCapConfig.normalizeId(itemId);
        if (!LevelCapConfig.isItemIdValid(id)) {
            LevelCapConfig.logWarn("addItemIdToLabel: invalid itemId " + itemId);
            return false;
        }
        if (!p.itemIds.contains(id)) {
            p.itemIds.add(id);
            LevelCapConfig.save();
            return true;
        }
        return false;
    }

    public static boolean removeItemIdFromLabel(String label, String itemId) {
        Progression p = LevelCapConfig.getProgression(label);
        if (p == null) {
            return false;
        }
        boolean r = p.itemIds.remove(LevelCapConfig.normalizeId(itemId));
        if (r) {
            LevelCapConfig.save();
        }
        return r;
    }

    public static OptionalInt getCapForLabel(String label) {
        Progression p = LevelCapConfig.getProgression(label);
        return p == null ? OptionalInt.empty() : OptionalInt.of(p.newCap);
    }

    public static String displayLabel(String label) {
        if (label == null) {
            return "";
        }
        return LevelCapConfig.toTitleCase(label.trim());
    }

    public static String normalizeLabel(String s) {
        return s == null ? "" : s.trim().toLowerCase(Locale.ROOT);
    }

    public static String normalizeId(String s) {
        return s == null ? "" : s.trim().toLowerCase(Locale.ROOT);
    }

    private static boolean isItemIdValid(String itemId) {
        if (itemId == null || itemId.isBlank()) {
            return false;
        }
        class_2960 id = class_2960.method_12829((String)itemId);
        return id != null;
    }

    private static boolean isProgressionValid(Progression p) {
        if (p == null) {
            return false;
        }
        if (p.label == null || p.label.isBlank()) {
            return false;
        }
        if (p.newCap < 1) {
            return false;
        }
        if (p.itemIds != null) {
            for (String s : p.itemIds) {
                if (LevelCapConfig.isItemIdValid(s)) continue;
                return false;
            }
        }
        return true;
    }

    private static void applyDefaults() {
        enabled = true;
        baseCap = 20;
        bypassIfShiny = false;
        bypassOnMasterBall = true;
        clampGainedOverCap = true;
        clampCapturedOverCap = true;
        progressions.clear();
        progressions.put(LevelCapConfig.normalizeLabel("Steel Badge"), new Progression("Steel Badge", 30, List.of("mapkit:steel_badge")));
        progressions.put(LevelCapConfig.normalizeLabel("Fire Badge"), new Progression("Fire Badge", 40, List.of("mapkit:fire_badge")));
    }

    private static String safeLabel(Progression p) {
        return p == null ? "<null>" : (p.label == null ? "<no-label>" : p.label);
    }

    private static String toTitleCase(String s) {
        String[] parts = s.replace('_', ' ').split("\\s+");
        StringBuilder sb = new StringBuilder();
        for (String p : parts) {
            if (p.isEmpty()) continue;
            sb.append(Character.toUpperCase(p.charAt(0)));
            if (p.length() > 1) {
                sb.append(p.substring(1));
            }
            sb.append(' ');
        }
        return sb.toString().trim();
    }

    private static void logInfo(String msg) {
        System.out.println("\u00a7a[LevelCapConfig] " + msg);
    }

    private static void logWarn(String msg) {
        System.out.println("\u00a7e[LevelCapConfig][WARN] " + msg);
    }

    private static void logError(String msg) {
        System.err.println("\u00a7c[LevelCapConfig][ERROR] " + msg);
    }

    private static void logError(String msg, Throwable t) {
        System.err.println("\u00a7c[LevelCapConfig][ERROR] " + msg);
        if (t != null) {
            StringWriter sw = new StringWriter();
            t.printStackTrace(new PrintWriter(sw));
            System.err.println(sw.toString());
        }
    }

    private static class ConfigData {
        Integer schemaVersion;
        Boolean enabled;
        Integer baseCap;
        Boolean bypassIfShiny;
        Boolean bypassOnMasterBall;
        Boolean clampGainedOverCap;
        Boolean clampCapturedOverCap;
        List<Progression> progressions = new ArrayList<Progression>();

        private ConfigData() {
        }
    }

    public static class Progression {
        public String label;
        public int newCap;
        public List<String> itemIds = new ArrayList<String>();

        public Progression() {
        }

        public Progression(String label, int newCap, Collection<String> itemIds) {
            this.label = label;
            this.newCap = newCap;
            if (itemIds != null) {
                for (String s : itemIds) {
                    if (s == null) continue;
                    this.itemIds.add(LevelCapConfig.normalizeId(s));
                }
            }
        }
    }
}

