/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.khataly.mapkit.event.client.custom;

import com.cobblemon.khataly.mapkit.item.ModItems;
import com.cobblemon.khataly.mapkit.networking.packet.grasszones.GrassZonesSyncS2CPacket;
import com.cobblemon.khataly.mapkit.networking.packet.grasszones.PlaceGrassC2SPacket;
import com.cobblemon.khataly.mapkit.networking.packet.grasszones.RequestZonesC2SPacket;
import com.cobblemon.khataly.mapkit.util.GrassZonesClientCache;
import com.cobblemon.khataly.mapkit.util.RenderUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_8710;

@Environment(value=EnvType.CLIENT)
public class GrassWandClient {
    private static class_2338 startPos = null;
    private static class_2338 curPos = null;
    private static boolean selecting = false;
    private static int zonesRefreshCooldown = 0;

    public static void register() {
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            boolean using;
            if (client.field_1724 == null) {
                return;
            }
            boolean holdingWand = GrassWandClient.isHoldingWand(client);
            if (holdingWand) {
                if (zonesRefreshCooldown <= 0) {
                    ClientPlayNetworking.send((class_8710)new RequestZonesC2SPacket());
                    zonesRefreshCooldown = 20;
                } else {
                    --zonesRefreshCooldown;
                }
            } else {
                zonesRefreshCooldown = 0;
            }
            boolean bl = using = holdingWand && client.field_1724.method_6115();
            if (using) {
                if (!selecting) {
                    startPos = GrassWandClient.rayBlock(client);
                    selecting = startPos != null;
                }
                curPos = GrassWandClient.rayBlock(client);
            } else {
                if (selecting && startPos != null && curPos != null) {
                    ClientPlayNetworking.send((class_8710)new PlaceGrassC2SPacket(startPos, curPos));
                }
                selecting = false;
                startPos = null;
                curPos = null;
            }
        });
        WorldRenderEvents.AFTER_TRANSLUCENT.register(ctx -> {
            class_310 mc = class_310.method_1551();
            if (mc.field_1724 == null || mc.field_1687 == null) {
                return;
            }
            class_4587 matrices = ctx.matrixStack();
            class_4597 providers = ctx.consumers();
            if (providers == null || matrices == null) {
                return;
            }
            class_4184 cam = ctx.camera();
            double camX = cam.method_19326().field_1352;
            double camY = cam.method_19326().field_1351;
            double camZ = cam.method_19326().field_1350;
            if (GrassWandClient.isHoldingWand(mc)) {
                String worldKeyStr = mc.field_1687.method_27983().method_29177().toString();
                for (GrassZonesSyncS2CPacket.ZoneDto z : GrassZonesClientCache.getZones()) {
                    if (!z.worldKey().equals(worldKeyStr)) continue;
                    double minX = Math.min(z.minX(), z.maxX());
                    double maxX = Math.max(z.minX(), z.maxX()) + 1;
                    double minZ = Math.min(z.minZ(), z.maxZ());
                    double maxZ = Math.max(z.minZ(), z.maxZ()) + 1;
                    double y = z.y();
                    class_238 box = new class_238(minX, y, minZ, maxX, y + 1.0, maxZ).method_989(-camX, -camY, -camZ);
                    RenderUtils.drawFilledBox(matrices, providers, box, 1.0f, 1.0f, 0.0f, 0.12f);
                    RenderUtils.drawOutlineBox(matrices, box, 1.0f, 0.9f, 0.0f, 0.95f);
                }
            }
            if (selecting && startPos != null && curPos != null) {
                double minX = Math.min(startPos.method_10263(), curPos.method_10263());
                double minY = Math.min(startPos.method_10264(), curPos.method_10264());
                double minZ = Math.min(startPos.method_10260(), curPos.method_10260());
                double maxX = Math.max(startPos.method_10263(), curPos.method_10263()) + 1;
                double maxZ = Math.max(startPos.method_10260(), curPos.method_10260()) + 1;
                class_238 sel = new class_238(minX, minY, minZ, maxX, minY + 1.0, maxZ).method_989(-camX, -camY, -camZ);
                RenderUtils.drawFilledBox(matrices, providers, sel, 0.0f, 0.4f, 1.0f, 0.25f);
                RenderUtils.drawOutlineBox(matrices, sel, 0.0f, 0.6f, 1.0f, 0.9f);
            }
        });
    }

    private static boolean isHoldingWand(class_310 client) {
        assert (client.field_1724 != null);
        class_1799 main = client.field_1724.method_6047();
        class_1799 off = client.field_1724.method_6079();
        return !main.method_7960() && main.method_7909() == ModItems.GRASS_WAND || !off.method_7960() && off.method_7909() == ModItems.GRASS_WAND;
    }

    private static class_2338 rayBlock(class_310 client) {
        class_239 hit = client.field_1765;
        if (hit instanceof class_3965) {
            class_3965 bhr = (class_3965)hit;
            return bhr.method_17777();
        }
        return null;
    }
}

