/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.khataly.mapkit.event.server;

import com.cobblemon.khataly.mapkit.config.FlyTargetConfig;
import com.cobblemon.khataly.mapkit.config.PlayerFlyProgress;
import java.util.Map;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2767;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5903;
import net.minecraft.class_5904;
import net.minecraft.class_5905;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;

public class FlyTargetProximityWatcher {
    private static final int UNLOCK_RADIUS = 8;
    private static final int UNLOCK_RADIUS_SQ = 64;
    private static final int TICKS_INTERVAL = 10;
    private static int tickCounter = 0;

    public static void register() {
        ServerTickEvents.END_SERVER_TICK.register(FlyTargetProximityWatcher::onEndServerTick);
    }

    private static void onEndServerTick(MinecraftServer server) {
        if (++tickCounter % 10 != 0) {
            return;
        }
        Map<String, FlyTargetConfig.TargetInfo> catalog = FlyTargetConfig.getAllTargets();
        if (catalog.isEmpty()) {
            return;
        }
        for (class_3222 player : server.method_3760().method_14571()) {
            class_1937 playerWorld = player.method_37908();
            class_2338 playerPos = player.method_24515();
            for (Map.Entry<String, FlyTargetConfig.TargetInfo> e : catalog.entrySet()) {
                boolean added;
                int dz;
                int dy;
                String key = e.getKey();
                FlyTargetConfig.TargetInfo info = e.getValue();
                if (!playerWorld.method_27983().equals(info.worldKey) || PlayerFlyProgress.isUnlocked(player.method_5667(), key)) continue;
                class_2338 tPos = info.pos;
                int dx = playerPos.method_10263() - tPos.method_10263();
                int distSq = dx * dx + (dy = playerPos.method_10264() - tPos.method_10264()) * dy + (dz = playerPos.method_10260() - tPos.method_10260()) * dz;
                if (distSq > 64 || !(added = PlayerFlyProgress.unlock(player.method_5667(), key))) continue;
                FlyTargetProximityWatcher.sendUnlockTitle(player, FlyTargetProximityWatcher.prettifyKey(key));
            }
        }
    }

    private static void sendUnlockTitle(class_3222 player, String targetName) {
        player.field_13987.method_14364((class_2596)new class_5904((class_2561)class_2561.method_43470((String)"Fly Target Unlocked!")));
        player.field_13987.method_14364((class_2596)new class_5903((class_2561)class_2561.method_43470((String)("Now you can fly to " + targetName))));
        player.field_13987.method_14364((class_2596)new class_5905(10, 60, 10));
        class_6880 entry = class_7923.field_41172.method_47983((Object)class_3417.field_15195);
        player.field_13987.method_14364((class_2596)new class_2767(entry, class_3419.field_15248, player.method_23317(), player.method_23318(), player.method_23321(), 1.0f, 1.0f, player.method_37908().field_9229.method_43055()));
    }

    private static String prettifyKey(String keyLower) {
        String[] parts = keyLower.replace('_', ' ').split("\\s+");
        StringBuilder sb = new StringBuilder();
        for (String p : parts) {
            if (p.isEmpty()) continue;
            sb.append(Character.toUpperCase(p.charAt(0)));
            if (p.length() > 1) {
                sb.append(p.substring(1));
            }
            sb.append(' ');
        }
        return sb.toString().trim();
    }
}

