/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.khataly.mapkit.event.server.custom;

import com.cobblemon.khataly.mapkit.config.GrassZonesConfig;
import com.cobblemon.khataly.mapkit.util.PlayerUtils;
import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.Priority;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.api.storage.party.PartyStore;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.battles.BattleBuilder;
import com.cobblemon.mod.common.battles.BattleFormat;
import com.cobblemon.mod.common.battles.BattleRegistry;
import com.cobblemon.mod.common.battles.actor.PlayerBattleActor;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.Species;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import kotlin.Unit;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.server.MinecraftServer;

public class GrassEncounterTicker {
    private static final int ENCOUNTER_COOLDOWN_TICKS = 60;
    private static final double BASE_STEP_CHANCE = 0.08;
    private static final int DEFAULT_GLOBAL_SHINY_ODDS = 4096;
    private static final Map<UUID, Integer> COOLDOWN = new HashMap<UUID, Integer>();
    private static final Map<UUID, class_2338> LAST_BLOCK = new HashMap<UUID, class_2338>();
    private static final Map<UUID, UUID> ACTIVE_WILD = new HashMap<UUID, UUID>();
    private static volatile boolean EVENTS_HOOKED = false;

    public static void register() {
        ServerTickEvents.END_SERVER_TICK.register(GrassEncounterTicker::onServerTick);
        GrassEncounterTicker.hookBattleFleeDespawnOnce();
    }

    private static void hookBattleFleeDespawnOnce() {
        if (EVENTS_HOOKED) {
            return;
        }
        EVENTS_HOOKED = true;
        CobblemonEvents.BATTLE_FLED.subscribe(Priority.NORMAL, event -> {
            try {
                PokemonEntity pe;
                PlayerBattleActor actor = event.getPlayer();
                class_3222 player = actor.getEntity();
                if (player == null) {
                    return Unit.INSTANCE;
                }
                UUID pid = player.method_5667();
                UUID wid = ACTIVE_WILD.remove(pid);
                if (wid == null) {
                    return Unit.INSTANCE;
                }
                class_3218 sw = (class_3218)player.method_37908();
                class_1297 ent = sw.method_14190(wid);
                if (ent instanceof PokemonEntity && (pe = (PokemonEntity)ent).method_5805() && !pe.method_31481()) {
                    pe.method_31472();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return Unit.INSTANCE;
        });
    }

    private static void onServerTick(MinecraftServer server) {
        for (class_3222 player : server.method_3760().method_14571()) {
            GrassZonesConfig.SpawnEntry choice;
            List<GrassZonesConfig.SpawnEntry> pool;
            class_5819 rng;
            class_1937 world;
            class_5321 wk;
            List<GrassZonesConfig.Zone> zones;
            COOLDOWN.computeIfPresent(player.method_5667(), (id, cd) -> Math.max(0, cd - 1));
            if (!GrassEncounterTicker.isValidStepState(player)) continue;
            class_2338 now = player.method_24515();
            class_2338 prev = LAST_BLOCK.put(player.method_5667(), now);
            if (prev != null && prev.equals((Object)now) || COOLDOWN.getOrDefault(player.method_5667(), 0) > 0 || (zones = GrassZonesConfig.findAt((class_5321<class_1937>)(wk = (world = player.method_37908()).method_27983()), now.method_10263(), now.method_10264(), now.method_10260())).isEmpty()) continue;
            GrassZonesConfig.Zone zone = zones.getFirst();
            if (now.method_10264() != zone.y() || GrassEncounterTicker.isInBattle(player) || (rng = player.method_59922()).method_43058() >= 0.08 || (pool = GrassEncounterTicker.filterByTime(zone.spawns(), world)).isEmpty() || (choice = GrassEncounterTicker.weightedRandom(pool, rng)) == null) continue;
            int levelRange = Math.max(1, choice.maxLevel - choice.minLevel + 1);
            int level = choice.minLevel + rng.method_43048(levelRange);
            int shinyOdds = GrassEncounterTicker.getZoneShinyOddsOrDefault(zone);
            boolean isShiny = GrassEncounterTicker.rollShiny(rng, shinyOdds);
            BattleFormat format = BattleFormat.Companion.getGEN_9_SINGLES();
            if (!GrassEncounterTicker.startWildBattle(player, choice.species, level, format, isShiny, choice.aspect)) continue;
            COOLDOWN.put(player.method_5667(), 60);
        }
    }

    private static boolean isValidStepState(class_3222 p) {
        if (p.method_7325()) {
            return false;
        }
        if (!p.method_24828()) {
            return false;
        }
        if (p.method_5765()) {
            return false;
        }
        return !GrassEncounterTicker.isInBattle(p);
    }

    private static boolean isInBattle(class_3222 player) {
        try {
            BattleRegistry reg = Cobblemon.INSTANCE.getBattleRegistry();
            return reg.getBattleByParticipatingPlayer(player) != null;
        }
        catch (Throwable t) {
            return false;
        }
    }

    private static List<GrassZonesConfig.SpawnEntry> filterByTime(List<GrassZonesConfig.SpawnEntry> entries, class_1937 world) {
        if (entries == null || entries.isEmpty()) {
            return Collections.emptyList();
        }
        if (!world.method_8597().comp_642()) {
            return entries;
        }
        long dayTime = world.method_8532() % 24000L;
        boolean isDay = dayTime < 12000L;
        ArrayList<GrassZonesConfig.SpawnEntry> out = new ArrayList<GrassZonesConfig.SpawnEntry>(entries.size());
        for (GrassZonesConfig.SpawnEntry e : entries) {
            if (e == null) continue;
            switch (e.time) {
                case BOTH: {
                    out.add(e);
                    break;
                }
                case DAY: {
                    if (!isDay) break;
                    out.add(e);
                    break;
                }
                case NIGHT: {
                    if (isDay) break;
                    out.add(e);
                }
            }
        }
        return out;
    }

    private static GrassZonesConfig.SpawnEntry weightedRandom(List<GrassZonesConfig.SpawnEntry> entries, class_5819 r) {
        if (entries == null || entries.isEmpty()) {
            return null;
        }
        int total = 0;
        for (GrassZonesConfig.SpawnEntry e : entries) {
            total += Math.max(0, e.weight);
        }
        if (total <= 0) {
            return null;
        }
        int roll = r.method_43048(total);
        int acc = 0;
        for (GrassZonesConfig.SpawnEntry e : entries) {
            if (roll >= (acc += Math.max(0, e.weight))) continue;
            return e;
        }
        return null;
    }

    private static int getZoneShinyOddsOrDefault(GrassZonesConfig.Zone zone) {
        return zone.shinyOdds() <= 0 ? 4096 : zone.shinyOdds();
    }

    private static boolean rollShiny(class_5819 rng, int odds) {
        if (odds <= 1) {
            return true;
        }
        return rng.method_43048(odds) == 0;
    }

    private static boolean startWildBattle(class_3222 player, String speciesId, int level, BattleFormat format, boolean shiny, String aspect) {
        Species species;
        String key;
        MinecraftServer server = player.method_5682();
        if (server == null) {
            return false;
        }
        if (!PlayerUtils.hasUsablePokemon(player)) {
            return false;
        }
        if (GrassEncounterTicker.isInBattle(player)) {
            return false;
        }
        String string = key = speciesId == null ? "" : speciesId.toLowerCase(Locale.ROOT);
        if (key.contains(":")) {
            key = key.substring(key.indexOf(58) + 1);
        }
        if ((species = PokemonSpecies.INSTANCE.getByName(key)) == null) {
            return false;
        }
        Pokemon pokemon = new Pokemon();
        pokemon.setSpecies(species);
        if (aspect != null && !aspect.isBlank()) {
            pokemon.setForcedAspects(Collections.singleton(aspect.toLowerCase(Locale.ROOT)));
            try {
                pokemon.updateForm();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        pokemon.setLevel(level);
        pokemon.setShiny(shiny);
        pokemon.initializeMoveset(true);
        pokemon.heal();
        class_3218 sw = (class_3218)player.method_37908();
        class_2338 base = player.method_24515();
        class_2338 pos = base.method_10069(1, 0, 0);
        class_243 vec = new class_243((double)pos.method_10263() + 0.5, (double)pos.method_10264(), (double)pos.method_10260() + 0.5);
        PokemonEntity entity = pokemon.sendOut(sw, vec, null, e -> null);
        if (entity == null) {
            return false;
        }
        ACTIVE_WILD.put(player.method_5667(), entity.method_5667());
        PlayerPartyStore party = Cobblemon.INSTANCE.getStorage().getParty(player);
        server.execute(() -> server.execute(() -> {
            if (!entity.method_31481() && entity.method_5805() && !GrassEncounterTicker.isInBattle(player)) {
                BattleBuilder.INSTANCE.pve(player, entity, null, format, false, false, 16.0f, (PartyStore)party);
            }
        }));
        return true;
    }
}

