/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.khataly.mapkit.event.server.custom;

import com.cobblemon.khataly.mapkit.config.LevelCapConfig;
import com.cobblemon.khataly.mapkit.util.LevelCapService;
import com.cobblemon.mod.common.api.Priority;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.events.pokeball.ThrownPokeballHitEvent;
import com.cobblemon.mod.common.api.events.pokemon.ExperienceGainedPreEvent;
import com.cobblemon.mod.common.api.events.pokemon.LevelUpEvent;
import com.cobblemon.mod.common.api.events.pokemon.PokemonCapturedEvent;
import com.cobblemon.mod.common.api.events.pokemon.PokemonGainedEvent;
import com.cobblemon.mod.common.api.events.pokemon.interaction.ExperienceCandyUseEvent;
import com.cobblemon.mod.common.entity.pokeball.EmptyPokeBallEntity;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.runtime.SwitchBootstraps;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Unit;
import net.minecraft.class_1297;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;

public final class LevelCapEnforcer {
    private static final long BYPASS_WINDOW_MS = 20000L;
    private static final Map<UUID, Long> recentMasterBypass = new ConcurrentHashMap<UUID, Long>();
    private static final Map<UUID, Set<UUID>> captureBypass = new ConcurrentHashMap<UUID, Set<UUID>>();
    private static final Set<UUID> nextExpFromCandy = ConcurrentHashMap.newKeySet();
    private static final Set<UUID> allowedOverCap = ConcurrentHashMap.newKeySet();
    private static final Set<UUID> processedCaptureGain = ConcurrentHashMap.newKeySet();

    private LevelCapEnforcer() {
    }

    public static void register() {
        CobblemonEvents.EXPERIENCE_GAINED_EVENT_PRE.subscribe(Priority.HIGHEST, e -> {
            LevelCapEnforcer.onExperienceGainedPre(e);
            return Unit.INSTANCE;
        });
        CobblemonEvents.EXPERIENCE_CANDY_USE_PRE.subscribe(Priority.HIGHEST, e -> {
            LevelCapEnforcer.onExperienceCandyPre(e);
            return Unit.INSTANCE;
        });
        CobblemonEvents.LEVEL_UP_EVENT.subscribe(Priority.NORMAL, e -> {
            LevelCapEnforcer.onLevelUpPost(e);
            return Unit.INSTANCE;
        });
        CobblemonEvents.THROWN_POKEBALL_HIT.subscribe(Priority.HIGHEST, e -> {
            LevelCapEnforcer.onPokeballHit(e);
            return Unit.INSTANCE;
        });
        CobblemonEvents.POKEMON_CAPTURED.subscribe(Priority.NORMAL, e -> {
            LevelCapEnforcer.onPokemonCaptured(e);
            return Unit.INSTANCE;
        });
        CobblemonEvents.POKEMON_GAINED.subscribe(Priority.NORMAL, e -> {
            LevelCapEnforcer.onPokemonGained(e);
            return Unit.INSTANCE;
        });
    }

    private static void onExperienceGainedPre(ExperienceGainedPreEvent event) {
        boolean shouldTrim;
        boolean isCandyGain;
        if (!LevelCapConfig.isEnabled()) {
            return;
        }
        Pokemon pokemon = event.getPokemon();
        class_3222 owner = LevelCapEnforcer.eventPlayerOrOwner(event, pokemon);
        if (owner == null) {
            return;
        }
        int currentLevel = LevelCapEnforcer.getPokemonLevel(pokemon);
        int cap = LevelCapService.getEffectiveCap(owner);
        UUID monId = LevelCapEnforcer.getPokemonUuid(pokemon);
        boolean bl = isCandyGain = monId != null && nextExpFromCandy.remove(monId);
        if (LevelCapService.isAtOrOverCap(currentLevel, cap)) {
            LevelCapEnforcer.cancel(event);
            LevelCapEnforcer.notify(owner, "\u00a7cEXP blocked: Pok\u00e9mon is at level cap " + cap + ".");
            return;
        }
        Integer incomingExp = LevelCapEnforcer.getExpAmountFromAnyExpEvent(event);
        if (incomingExp == null || incomingExp <= 0) {
            return;
        }
        Integer expToCap = LevelCapEnforcer.getRemainingExpToReachLevel(pokemon, cap);
        if (expToCap == null) {
            return;
        }
        if (expToCap <= 0) {
            LevelCapEnforcer.cancel(event);
            LevelCapEnforcer.notify(owner, "\u00a7cEXP blocked: would exceed the level cap " + cap + ".");
            return;
        }
        boolean bl2 = shouldTrim = !isCandyGain || isCandyGain && LevelCapConfig.isClampGainedOverCap();
        if (shouldTrim && incomingExp > expToCap && LevelCapEnforcer.setExpAmountOnAnyExpEvent(event, expToCap)) {
            LevelCapEnforcer.notify(owner, (isCandyGain ? "\u00a7aCandy" : "\u00a7aEXP") + " trimmed to reach level cap " + cap + ".");
        }
    }

    private static void onExperienceCandyPre(ExperienceCandyUseEvent.Pre event) {
        if (!LevelCapConfig.isEnabled()) {
            return;
        }
        Pokemon pokemon = event.getPokemon();
        class_3222 owner = LevelCapEnforcer.eventPlayerOrOwner(event, pokemon);
        if (owner == null) {
            return;
        }
        int currentLevel = LevelCapEnforcer.getPokemonLevel(pokemon);
        int cap = LevelCapService.getEffectiveCap(owner);
        UUID monId = LevelCapEnforcer.getPokemonUuid(pokemon);
        if (monId != null) {
            nextExpFromCandy.add(monId);
        }
        if (LevelCapService.isAtOrOverCap(currentLevel, cap)) {
            LevelCapEnforcer.cancel(event);
            LevelCapEnforcer.notify(owner, "\u00a7cEXP candy blocked: Pok\u00e9mon is at level cap " + cap + ".");
        }
    }

    private static void onLevelUpPost(LevelUpEvent event) {
        if (!LevelCapConfig.isEnabled()) {
            return;
        }
        Pokemon pokemon = event.getPokemon();
        class_3222 owner = LevelCapEnforcer.eventPlayerOrOwner(event, pokemon);
        if (owner == null) {
            return;
        }
        int lvl = LevelCapEnforcer.getPokemonLevel(pokemon);
        int cap = LevelCapService.getEffectiveCap(owner);
        UUID monId = LevelCapEnforcer.getPokemonUuid(pokemon);
        if (monId != null && allowedOverCap.contains(monId)) {
            if (lvl <= cap) {
                allowedOverCap.remove(monId);
            }
            return;
        }
        if (lvl > cap) {
            MinecraftServer server = owner.method_5682();
            if (server != null) {
                server.execute(() -> {
                    if (LevelCapEnforcer.setPokemonLevel(pokemon, cap)) {
                        LevelCapEnforcer.notify(owner, "\u00a7cLevel up clamped to cap (" + cap + ").");
                    } else {
                        LevelCapEnforcer.notify(owner, "\u00a7c[LevelCap][WARN] Pok\u00e9mon exceeded cap (" + lvl + " > " + cap + ").");
                    }
                });
            } else {
                LevelCapEnforcer.notify(owner, "\u00a7c[LevelCap][WARN] Pok\u00e9mon exceeded cap (" + lvl + " > " + cap + ").");
            }
        }
    }

    private static void onPokeballHit(ThrownPokeballHitEvent event) {
        boolean masterAllowed;
        if (!LevelCapConfig.isEnabled()) {
            return;
        }
        EmptyPokeBallEntity pokeBall = event.getPokeBall();
        PokemonEntity targetEntity = event.getPokemon();
        class_1297 ownerEntity = pokeBall.method_24921();
        if (!(ownerEntity instanceof class_3222)) {
            return;
        }
        class_3222 player = (class_3222)ownerEntity;
        int lvl = LevelCapEnforcer.getPokemonLevel(targetEntity);
        int cap = LevelCapService.getEffectiveCap(player);
        boolean shinyAllowed = LevelCapConfig.isBypassIfShiny() && LevelCapEnforcer.isPokemonShiny(targetEntity);
        boolean bl = masterAllowed = LevelCapConfig.isBypassOnMasterBall() && LevelCapEnforcer.isMasterBall(pokeBall);
        if (lvl > cap && !shinyAllowed && !masterAllowed) {
            LevelCapEnforcer.cancel(event);
            LevelCapEnforcer.notify(player, "\u00a7cCapture blocked: level " + lvl + " above cap " + cap + ".");
            return;
        }
        if (lvl > cap) {
            UUID targetId = LevelCapEnforcer.getEntityUuid(targetEntity);
            if (targetId != null) {
                captureBypass.computeIfAbsent(player.method_5667(), k -> ConcurrentHashMap.newKeySet()).add(targetId);
            }
            if (masterAllowed) {
                recentMasterBypass.put(player.method_5667(), System.currentTimeMillis() + 20000L);
                LevelCapEnforcer.notify(player, "\u00a7aCapture bypass (Master Ball): level " + lvl + " allowed.");
            } else {
                LevelCapEnforcer.notify(player, "\u00a7aCapture bypass (Shiny Pok\u00e9mon): level " + lvl + " allowed.");
            }
        }
    }

    private static void onPokemonCaptured(PokemonCapturedEvent event) {
        if (!LevelCapConfig.isEnabled()) {
            return;
        }
    }

    private static void onPokemonGained(PokemonGainedEvent event) {
        if (!LevelCapConfig.isEnabled()) {
            return;
        }
        Pokemon pokemon = event.getPokemon();
        class_3222 owner = LevelCapEnforcer.eventPlayerOrOwner(event, pokemon);
        if (owner == null) {
            return;
        }
        int lvl = LevelCapEnforcer.getPokemonLevel(pokemon);
        int cap = LevelCapService.getEffectiveCap(owner);
        boolean fromCapture = LevelCapEnforcer.isFromCapture(event, pokemon, owner);
        UUID monId = LevelCapEnforcer.getPokemonUuid(pokemon);
        if (!fromCapture || monId == null) {
            return;
        }
        if (!processedCaptureGain.add(monId)) {
            return;
        }
        Set<UUID> set = captureBypass.get(owner.method_5667());
        if (set != null) {
            set.remove(monId);
            if (set.isEmpty()) {
                captureBypass.remove(owner.method_5667());
            }
        }
        recentMasterBypass.remove(owner.method_5667());
        if (lvl > cap) {
            if (LevelCapConfig.isClampCapturedOverCap()) {
                MinecraftServer server = owner.method_5682();
                if (server != null) {
                    server.execute(() -> {
                        if (LevelCapEnforcer.setPokemonLevel(pokemon, cap)) {
                            LevelCapEnforcer.notify(owner, "\u00a7cCaptured Pok\u00e9mon level clamped to " + cap + ".");
                        }
                    });
                } else {
                    LevelCapEnforcer.setPokemonLevel(pokemon, cap);
                    LevelCapEnforcer.notify(owner, "\u00a7cCaptured Pok\u00e9mon level clamped to " + cap + ".");
                }
                allowedOverCap.remove(monId);
            } else {
                allowedOverCap.add(monId);
                LevelCapEnforcer.notify(owner, "\u00a7eCaptured Pok\u00e9mon above cap allowed by config (no clamp).");
            }
        }
    }

    private static boolean isFromCapture(PokemonGainedEvent event, Object pokemon, class_3222 owner) {
        Set<UUID> set;
        String s;
        for (String m : new String[]{"isFromCapture", "wasCapture", "isCapture"}) {
            try {
                Method mm = event.getClass().getMethod(m, new Class[0]);
                Object res = mm.invoke((Object)event, new Object[0]);
                if (!(res instanceof Boolean)) continue;
                Boolean b = (Boolean)res;
                return b;
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                // empty catch block
            }
        }
        Object src = LevelCapEnforcer.firstNonNullObj(LevelCapEnforcer.tryObject(event, "getSource"), LevelCapEnforcer.tryObject(event, "getCause"), LevelCapEnforcer.tryObject(event, "getReason"), LevelCapEnforcer.tryObject(event, "getOrigin"));
        if (src != null && (s = String.valueOf(src).toUpperCase(Locale.ROOT)).contains("CAPTURE")) {
            return true;
        }
        UUID monId = LevelCapEnforcer.getPokemonUuid(pokemon);
        if (monId != null && (set = captureBypass.get(owner.method_5667())) != null && set.contains(monId)) {
            return true;
        }
        return recentMasterBypass.containsKey(owner.method_5667());
    }

    private static boolean consumeMasterWindow(UUID playerId) {
        Long until = recentMasterBypass.get(playerId);
        long now = System.currentTimeMillis();
        if (until != null && now <= until) {
            recentMasterBypass.remove(playerId);
            return true;
        }
        if (until != null) {
            recentMasterBypass.remove(playerId);
        }
        return false;
    }

    private static UUID getEntityUuid(Object entity) {
        Object r2;
        if (entity == null) {
            return null;
        }
        try {
            r2 = entity.getClass().getMethod("getUuid", new Class[0]).invoke(entity, new Object[0]);
            if (r2 instanceof UUID) {
                UUID u = (UUID)r2;
                return u;
            }
        }
        catch (ReflectiveOperationException r2) {
            // empty catch block
        }
        try {
            r2 = entity.getClass().getMethod("getUUID", new Class[0]).invoke(entity, new Object[0]);
            if (r2 instanceof UUID) {
                UUID u = (UUID)r2;
                return u;
            }
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
        return null;
    }

    private static UUID getPokemonUuid(Object obj) {
        Object r2;
        Object mon = LevelCapEnforcer.unwrapMon(obj);
        if (mon == null) {
            return null;
        }
        try {
            r2 = mon.getClass().getMethod("getUuid", new Class[0]).invoke(mon, new Object[0]);
            if (r2 instanceof UUID) {
                UUID u = (UUID)r2;
                return u;
            }
        }
        catch (ReflectiveOperationException r2) {
            // empty catch block
        }
        try {
            r2 = mon.getClass().getMethod("getUUID", new Class[0]).invoke(mon, new Object[0]);
            if (r2 instanceof UUID) {
                UUID u = (UUID)r2;
                return u;
            }
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
        return null;
    }

    private static void cancel(Object cancelableEvent) {
        try {
            cancelableEvent.getClass().getMethod("cancel", new Class[0]).invoke(cancelableEvent, new Object[0]);
            return;
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            try {
                cancelableEvent.getClass().getMethod("setCanceled", Boolean.TYPE).invoke(cancelableEvent, true);
            }
            catch (ReflectiveOperationException reflectiveOperationException2) {
                // empty catch block
            }
            return;
        }
    }

    private static void notify(class_3222 player, String msg) {
        if (player != null) {
            player.method_7353((class_2561)class_2561.method_43470((String)msg), false);
        }
    }

    private static class_3222 eventPlayerOrOwner(Object event, Object pokemon) {
        for (String name : new String[]{"getPlayer", "getReceiver", "getOwner", "getTrainer", "getServerPlayer"}) {
            class_3222 p = LevelCapEnforcer.tryGetPlayer(event, name);
            if (p == null) continue;
            return p;
        }
        return LevelCapEnforcer.tryGetPlayer(pokemon, "getOwnerPlayer");
    }

    private static class_3222 tryGetPlayer(Object target, String methodName) {
        try {
            Method m = target.getClass().getMethod(methodName, new Class[0]);
            Object res = m.invoke(target, new Object[0]);
            return res instanceof class_3222 ? (class_3222)res : null;
        }
        catch (ReflectiveOperationException ignored) {
            return null;
        }
    }

    private static Object unwrapMon(Object obj) {
        if (obj == null) {
            return null;
        }
        try {
            Method m = obj.getClass().getMethod("getPokemon", new Class[0]);
            Object inner = m.invoke(obj, new Object[0]);
            if (inner != null) {
                return inner;
            }
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
        return obj;
    }

    private static boolean isPokemonShiny(Object obj) {
        Object mon = LevelCapEnforcer.unwrapMon(obj);
        if (mon == null) {
            return false;
        }
        try {
            Object res = mon.getClass().getMethod("isShiny", new Class[0]).invoke(mon, new Object[0]);
            if (res instanceof Boolean) {
                return (Boolean)res;
            }
        }
        catch (ReflectiveOperationException res) {
            // empty catch block
        }
        try {
            Field f = mon.getClass().getDeclaredField("shiny");
            f.setAccessible(true);
            Object v = f.get(mon);
            if (v instanceof Boolean) {
                return (Boolean)v;
            }
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
        return false;
    }

    private static int getPokemonLevel(Object obj) {
        Object mon = LevelCapEnforcer.unwrapMon(obj);
        if (mon == null) {
            return 1;
        }
        try {
            Object res = mon.getClass().getMethod("getLevel", new Class[0]).invoke(mon, new Object[0]);
            if (res instanceof Integer) {
                return (Integer)res;
            }
        }
        catch (ReflectiveOperationException res) {
            // empty catch block
        }
        try {
            Object res;
            Object stats = mon.getClass().getMethod("getStats", new Class[0]).invoke(mon, new Object[0]);
            if (stats != null && (res = stats.getClass().getMethod("getLevel", new Class[0]).invoke(stats, new Object[0])) instanceof Integer) {
                return (Integer)res;
            }
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
        return 1;
    }

    private static boolean setPokemonLevel(Object obj, int level) {
        Object mon = LevelCapEnforcer.unwrapMon(obj);
        if (mon == null) {
            return false;
        }
        try {
            mon.getClass().getMethod("setLevel", Integer.TYPE).invoke(mon, level);
            return true;
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            try {
                Object stats = mon.getClass().getMethod("getStats", new Class[0]).invoke(mon, new Object[0]);
                if (stats != null) {
                    stats.getClass().getMethod("setLevel", Integer.TYPE).invoke(stats, level);
                    return true;
                }
            }
            catch (ReflectiveOperationException reflectiveOperationException2) {
                // empty catch block
            }
            return false;
        }
    }

    private static boolean isMasterBall(Object pokeBallEntity) {
        String cls;
        class_1799 stack;
        if (!LevelCapConfig.isBypassOnMasterBall() || pokeBallEntity == null) {
            return false;
        }
        String quick = LevelCapEnforcer.firstNonNull(LevelCapEnforcer.tryString(pokeBallEntity, "getBallId"), LevelCapEnforcer.tryString(pokeBallEntity, "getBallIdentifier"), LevelCapEnforcer.tryString(pokeBallEntity, "getPokeBallId"), LevelCapEnforcer.tryString(pokeBallEntity, "getIdentifier"), LevelCapEnforcer.tryString(pokeBallEntity, "getName"));
        if (LevelCapEnforcer.isCobblemonMasterBallId(quick)) {
            return true;
        }
        Object ballObj = LevelCapEnforcer.firstNonNullObj(LevelCapEnforcer.tryObject(pokeBallEntity, "getBall"), LevelCapEnforcer.tryObject(pokeBallEntity, "getPokeBall"), LevelCapEnforcer.tryObject(pokeBallEntity, "getBallType"), LevelCapEnforcer.tryObject(pokeBallEntity, "getType"));
        if (ballObj != null) {
            String en;
            String bid = LevelCapEnforcer.firstNonNull(LevelCapEnforcer.tryString(ballObj, "getIdentifier"), LevelCapEnforcer.tryString(ballObj, "getId"), LevelCapEnforcer.tryString(ballObj, "getName"), String.valueOf(ballObj));
            if (LevelCapEnforcer.isCobblemonMasterBallId(bid)) {
                return true;
            }
            if (ballObj instanceof Enum && LevelCapEnforcer.isCobblemonMasterBallId(en = ((Enum)ballObj).name())) {
                return true;
            }
            if (LevelCapEnforcer.scanObjectForMasterBall(ballObj)) {
                return true;
            }
        }
        if ((stack = LevelCapEnforcer.tryGetPokeballItemStack(pokeBallEntity)) != null && !stack.method_7960()) {
            String itemId = LevelCapEnforcer.itemIdString(stack.method_7909());
            if (LevelCapEnforcer.isCobblemonMasterBallId(itemId)) {
                return true;
            }
            if (LevelCapEnforcer.isCobblemonMasterBallId(String.valueOf(stack.method_7909()))) {
                return true;
            }
        }
        if (LevelCapEnforcer.isCobblemonMasterBallId(cls = pokeBallEntity.getClass().getName())) {
            return true;
        }
        String simple = pokeBallEntity.getClass().getSimpleName();
        if (LevelCapEnforcer.isCobblemonMasterBallId(simple)) {
            return true;
        }
        String ts = String.valueOf(pokeBallEntity);
        return LevelCapEnforcer.isCobblemonMasterBallId(ts);
    }

    private static boolean isCobblemonMasterBallId(String s) {
        if (s == null || s.isBlank()) {
            return false;
        }
        String v = s.toLowerCase(Locale.ROOT).trim();
        return v.equals("cobblemon:master_ball") || v.endsWith(":master_ball") || v.contains("master_ball") || v.equals("master ball") || v.endsWith(".master_ball") || v.endsWith("$master_ball");
    }

    private static class_1799 tryGetPokeballItemStack(Object pokeBallEntity) {
        if (pokeBallEntity == null) {
            return null;
        }
        for (String mName : new String[]{"getItem", "getStack", "getItemStack", "getBallStack"}) {
            try {
                Method m = pokeBallEntity.getClass().getMethod(mName, new Class[0]);
                Object res = m.invoke(pokeBallEntity, new Object[0]);
                if (!(res instanceof class_1799)) continue;
                return (class_1799)res;
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                // empty catch block
            }
        }
        return null;
    }

    private static boolean scanObjectForMasterBall(Object obj) {
        try {
            Class<?> c = obj.getClass();
            block9: for (Field f : c.getDeclaredFields()) {
                Object v;
                f.setAccessible(true);
                Object object = v = f.get(obj);
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{CharSequence.class, class_1792.class, class_1799.class, Enum.class}, (Object)object, n)) {
                    case -1: {
                        continue block9;
                    }
                    case 0: {
                        CharSequence cs = (CharSequence)object;
                        if (!LevelCapEnforcer.isCobblemonMasterBallId(v.toString())) continue block9;
                        return true;
                    }
                    case 1: {
                        class_1792 item = (class_1792)object;
                        String id = LevelCapEnforcer.itemIdString(item);
                        if (!LevelCapEnforcer.isCobblemonMasterBallId(id)) continue block9;
                        return true;
                    }
                    case 2: {
                        class_1799 st = (class_1799)object;
                        if (st.method_7960() || !LevelCapEnforcer.isCobblemonMasterBallId(LevelCapEnforcer.itemIdString(st.method_7909()))) continue block9;
                        return true;
                    }
                    case 3: {
                        Enum en = (Enum)object;
                        if (!LevelCapEnforcer.isCobblemonMasterBallId(en.name())) continue block9;
                        return true;
                    }
                    default: {
                        if (!LevelCapEnforcer.isCobblemonMasterBallId(String.valueOf(v))) continue block9;
                        return true;
                    }
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    private static String itemIdString(class_1792 item) {
        if (item == null) {
            return "";
        }
        try {
            return class_7923.field_41178.method_10221((Object)item).toString().toLowerCase(Locale.ROOT);
        }
        catch (Exception ignored) {
            return item.getClass().getName().toLowerCase(Locale.ROOT);
        }
    }

    private static Object tryObject(Object target, String ... methods) {
        if (target == null) {
            return null;
        }
        for (String name : methods) {
            try {
                Method m = target.getClass().getMethod(name, new Class[0]);
                return m.invoke(target, new Object[0]);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
            }
        }
        return null;
    }

    private static String tryString(Object target, String ... methods) {
        Object o = LevelCapEnforcer.tryObject(target, methods);
        return o == null ? null : String.valueOf(o);
    }

    private static Integer getExpAmountFromAnyExpEvent(Object ev) {
        for (String m : new String[]{"getExperience", "getExp", "getAmount", "getExperienceAmount"}) {
            try {
                Method mm = ev.getClass().getMethod(m, new Class[0]);
                Object val = mm.invoke(ev, new Object[0]);
                if (!(val instanceof Number)) continue;
                return ((Number)val).intValue();
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                // empty catch block
            }
        }
        return null;
    }

    private static boolean setExpAmountOnAnyExpEvent(Object ev, int newAmount) {
        for (String m : new String[]{"setExperience", "setExp", "setAmount", "setExperienceAmount"}) {
            try {
                Method mm = ev.getClass().getMethod(m, Integer.TYPE);
                mm.invoke(ev, newAmount);
                return true;
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
            }
        }
        return false;
    }

    private static Integer getRemainingExpToReachLevel(Object pokemonObj, int targetLevel) {
        Object stats;
        Object mon = LevelCapEnforcer.unwrapMon(pokemonObj);
        if (mon == null) {
            return null;
        }
        Integer currentLevel = LevelCapEnforcer.tryInt(mon, "getLevel");
        if (currentLevel == null && (stats = LevelCapEnforcer.tryObject(mon, "getStats")) != null) {
            currentLevel = LevelCapEnforcer.tryInt(stats, "getLevel");
        }
        if (currentLevel == null) {
            return null;
        }
        if (currentLevel >= targetLevel) {
            return 0;
        }
        Integer currentExp = LevelCapEnforcer.firstNonNull(LevelCapEnforcer.tryInt(mon, "getExperience"), LevelCapEnforcer.tryInt(mon, "getExp"), LevelCapEnforcer.tryInt(mon, "getTotalExperience"), LevelCapEnforcer.tryInt(LevelCapEnforcer.tryObject(mon, "getStats"), "getExperience"));
        Integer expForTarget = LevelCapEnforcer.firstNonNull(LevelCapEnforcer.tryInt(mon, "getExperienceForLevel", targetLevel), LevelCapEnforcer.tryInt(mon, "getExpForLevel", targetLevel), LevelCapEnforcer.tryInt(LevelCapEnforcer.tryObject(mon, "getStats"), "getExperienceForLevel", targetLevel), LevelCapEnforcer.tryInt(LevelCapEnforcer.tryObject(mon, "getStats"), "getExpForLevel", targetLevel));
        if (currentExp != null && expForTarget != null) {
            int diff = expForTarget - currentExp;
            return Math.max(diff, 0);
        }
        int totalNeeded = 0;
        for (int from = currentLevel.intValue(); from < targetLevel; ++from) {
            Integer toNext = LevelCapEnforcer.firstNonNull(LevelCapEnforcer.tryInt(mon, "getExperienceToNextLevel"), LevelCapEnforcer.tryInt(mon, "getExpToNextLevel"), LevelCapEnforcer.tryInt(LevelCapEnforcer.tryObject(mon, "getStats"), "getExperienceToNextLevel"), LevelCapEnforcer.tryInt(LevelCapEnforcer.tryObject(mon, "getStats"), "getExpToNextLevel"));
            if (toNext == null) {
                return null;
            }
            totalNeeded += Math.max(0, toNext);
        }
        return totalNeeded;
    }

    private static Integer tryInt(Object target, String method) {
        if (target == null) {
            return null;
        }
        try {
            Method m = target.getClass().getMethod(method, new Class[0]);
            Object res = m.invoke(target, new Object[0]);
            return res instanceof Number ? Integer.valueOf(((Number)res).intValue()) : null;
        }
        catch (ReflectiveOperationException ignored) {
            return null;
        }
    }

    private static Integer tryInt(Object target, String method, int arg) {
        if (target == null) {
            return null;
        }
        try {
            Method m = target.getClass().getMethod(method, Integer.TYPE);
            Object res = m.invoke(target, arg);
            return res instanceof Number ? Integer.valueOf(((Number)res).intValue()) : null;
        }
        catch (ReflectiveOperationException ignored) {
            return null;
        }
    }

    @SafeVarargs
    private static <T> T firstNonNull(T ... vals) {
        for (T v : vals) {
            if (v == null) continue;
            return v;
        }
        return null;
    }

    private static Object firstNonNullObj(Object ... arr) {
        for (Object o : arr) {
            if (o == null) continue;
            return o;
        }
        return null;
    }
}

