/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.khataly.mapkit.networking.handlers;

import com.cobblemon.khataly.mapkit.config.GrassZonesConfig;
import com.cobblemon.khataly.mapkit.item.ModItems;
import com.cobblemon.khataly.mapkit.networking.packet.grasszones.PlaceGrassC2SPacket;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2320;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_4538;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_9279;
import net.minecraft.class_9334;

public class GrassWandHandler {
    private static final int MAX_SIDE = 64;
    private static final String NBT_MODE = "grass_mode";

    public static void register() {
        ServerPlayNetworking.registerGlobalReceiver(PlaceGrassC2SPacket.ID, (payload, ctx) -> {
            class_3222 player = ctx.player();
            class_2338 a = payload.a();
            class_2338 b = payload.b();
            ctx.server().execute(() -> GrassWandHandler.placeArea(player, a, b));
        });
    }

    private static void placeArea(class_3222 player, class_2338 a, class_2338 b) {
        if (player == null) {
            return;
        }
        class_1937 world = player.method_37908();
        int minX = Math.min(a.method_10263(), b.method_10263());
        int maxX = Math.max(a.method_10263(), b.method_10263());
        int minZ = Math.min(a.method_10260(), b.method_10260());
        int maxZ = Math.max(a.method_10260(), b.method_10260());
        int y = Math.min(a.method_10264(), b.method_10264());
        if (maxX - minX + 1 > 64 || maxZ - minZ + 1 > 64) {
            return;
        }
        if (GrassZonesConfig.overlaps((class_5321<class_1937>)world.method_27983(), minX, minZ, maxX, maxZ, y)) {
            player.method_7353((class_2561)class_2561.method_43470((String)"Cannot create the grass zone: it overlaps an existing one."), false);
            return;
        }
        boolean tallMode = GrassWandHandler.readTallMode(player);
        class_2248 shortGrassBlock = GrassWandHandler.resolveShortGrass();
        int placed = 0;
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                class_2680 st;
                class_2338 pos = new class_2338(x, y, z);
                class_2338 below = pos.method_10074();
                if (!world.method_22347(pos) || !world.method_8320(below).method_27852(class_2246.field_10219)) continue;
                if (tallMode) {
                    class_2680 tall;
                    if (!world.method_22347(pos.method_10084()) || !(tall = class_2246.field_10214.method_9564()).method_26184((class_4538)world, pos)) continue;
                    class_2320.method_10021((class_1936)world, (class_2680)tall, (class_2338)pos, (int)3);
                    ++placed;
                    continue;
                }
                if (shortGrassBlock == null || !(st = shortGrassBlock.method_9564()).method_26184((class_4538)world, pos)) continue;
                world.method_8652(pos, st, 3);
                ++placed;
            }
        }
        List<GrassZonesConfig.SpawnEntry> defaultSpawns = List.of(new GrassZonesConfig.SpawnEntry("cobblemon:sentret", 3, 7, 30, GrassZonesConfig.TimeBand.DAY), new GrassZonesConfig.SpawnEntry("cobblemon:rattata", 3, 7, 30, GrassZonesConfig.TimeBand.NIGHT), new GrassZonesConfig.SpawnEntry("cobblemon:oddish", 5, 9, 10, GrassZonesConfig.TimeBand.BOTH), new GrassZonesConfig.SpawnEntry("cobblemon:geodude", 10, 14, 30, GrassZonesConfig.TimeBand.BOTH, "alolan"));
        UUID id = GrassZonesConfig.addZone((class_5321<class_1937>)world.method_27983(), minX, minZ, maxX, maxZ, y, defaultSpawns);
        player.method_7353((class_2561)class_2561.method_43470((String)("Grass zone created: " + String.valueOf(id) + " (blocks placed: " + placed + ")")), false);
    }

    private static boolean readTallMode(class_3222 player) {
        class_1799 main = player.method_6047();
        class_1799 off = player.method_6079();
        if (!main.method_7960() && main.method_7909() == ModItems.GRASS_WAND) {
            class_9279 data = (class_9279)main.method_57824(class_9334.field_49628);
            if (data == null) {
                return false;
            }
            return "tall".equalsIgnoreCase(data.method_57461().method_10558(NBT_MODE));
        }
        if (!off.method_7960() && off.method_7909() == ModItems.GRASS_WAND) {
            class_9279 data = (class_9279)off.method_57824(class_9334.field_49628);
            if (data == null) {
                return false;
            }
            return "tall".equalsIgnoreCase(data.method_57461().method_10558(NBT_MODE));
        }
        return false;
    }

    private static class_2248 resolveShortGrass() {
        Optional a = class_7923.field_41175.method_17966(class_2960.method_60655((String)"minecraft", (String)"short_grass"));
        if (a.isPresent()) {
            return (class_2248)a.get();
        }
        Optional b = class_7923.field_41175.method_17966(class_2960.method_60655((String)"minecraft", (String)"grass"));
        return b.orElse(null);
    }
}

