/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.khataly.modhm.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7924;

public class FlyTargetConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File CONFIG_FILE = new File("config/modhm/flytargets.json");
    private static final Map<String, TargetInfo> targets = new HashMap<String, TargetInfo>();

    public static boolean addTarget(String name, class_5321<class_1937> worldKey, class_2338 pos) {
        String key = name.toLowerCase();
        if (targets.containsKey(key)) {
            return false;
        }
        targets.put(key, new TargetInfo(worldKey, pos));
        FlyTargetConfig.save();
        return true;
    }

    public static boolean removeTarget(String name) {
        String key = name.toLowerCase();
        if (!targets.containsKey(key)) {
            return false;
        }
        targets.remove(key);
        FlyTargetConfig.save();
        return true;
    }

    public static TargetInfo getTarget(String name) {
        return targets.get(name.toLowerCase());
    }

    public static Map<String, TargetInfo> getAllTargets() {
        return Collections.unmodifiableMap(targets);
    }

    public static void reload() {
        FlyTargetConfig.load();
    }

    public static void load() {
        try {
            if (!CONFIG_FILE.exists()) {
                FlyTargetConfig.save();
                return;
            }
            FileReader reader = new FileReader(CONFIG_FILE);
            ConfigData data = (ConfigData)GSON.fromJson((Reader)reader, ConfigData.class);
            reader.close();
            targets.clear();
            if (data != null && data.targets != null) {
                for (FlyTargetData d : data.targets) {
                    class_5321 worldKey = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)class_2960.method_60654((String)d.worldKey));
                    class_2338 pos = new class_2338(d.x, d.y, d.z);
                    targets.put(d.name.toLowerCase(), new TargetInfo((class_5321<class_1937>)worldKey, pos));
                }
            }
            System.out.println("[FlyTargetConfigServer] Loaded " + targets.size() + " fly targets.");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void save() {
        try {
            CONFIG_FILE.getParentFile().mkdirs();
            ConfigData data = new ConfigData();
            for (Map.Entry<String, TargetInfo> entry : targets.entrySet()) {
                String name = entry.getKey();
                TargetInfo info = entry.getValue();
                data.targets.add(new FlyTargetData(name, info.worldKey.method_29177().toString(), info.pos.method_10263(), info.pos.method_10264(), info.pos.method_10260()));
            }
            FileWriter writer = new FileWriter(CONFIG_FILE);
            GSON.toJson((Object)data, (Appendable)writer);
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static class TargetInfo {
        public final class_5321<class_1937> worldKey;
        public final class_2338 pos;

        public TargetInfo(class_5321<class_1937> worldKey, class_2338 pos) {
            this.worldKey = worldKey;
            this.pos = pos;
        }
    }

    private static class ConfigData {
        List<FlyTargetData> targets = new ArrayList<FlyTargetData>();

        private ConfigData() {
        }
    }

    private static class FlyTargetData {
        String name;
        String worldKey;
        int x;
        int y;
        int z;

        FlyTargetData(String name, String worldKey, int x, int y, int z) {
            this.name = name;
            this.worldKey = worldKey;
            this.x = x;
            this.y = y;
            this.z = z;
        }
    }
}

