/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.khataly.modhm.networking;

import com.cobblemon.khataly.modhm.config.ModConfig;
import com.cobblemon.khataly.modhm.networking.packet.AnimationHMPacketS2C;
import com.cobblemon.khataly.modhm.networking.packet.CutPacketC2S;
import com.cobblemon.khataly.modhm.networking.packet.FlashMenuC2SPacket;
import com.cobblemon.khataly.modhm.networking.packet.FlashMenuS2CPacket;
import com.cobblemon.khataly.modhm.networking.packet.FlashPacketC2S;
import com.cobblemon.khataly.modhm.networking.packet.FlyMenuC2SPacket;
import com.cobblemon.khataly.modhm.networking.packet.FlyMenuS2CPacket;
import com.cobblemon.khataly.modhm.networking.packet.FlyPacketC2S;
import com.cobblemon.khataly.modhm.networking.packet.RockSmashPacketC2S;
import com.cobblemon.khataly.modhm.networking.packet.StrengthPacketC2S;
import com.cobblemon.khataly.modhm.networking.packet.TeleportMenuC2SPacket;
import com.cobblemon.khataly.modhm.networking.packet.TeleportMenuS2CPacket;
import com.cobblemon.khataly.modhm.networking.packet.TeleportPacketC2S;
import com.cobblemon.khataly.modhm.sound.ModSounds;
import com.cobblemon.khataly.modhm.util.PartyUtils;
import com.cobblemon.mod.common.CobblemonEntities;
import com.cobblemon.mod.common.api.moves.Moves;
import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.battles.BattleBuilder;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.RenderablePokemon;
import com.cobblemon.mod.common.pokemon.Species;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1540;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2675;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModNetworking {
    private static final float ROCK_SMASH_POKEMON_ENCOUNTER_CHANCE = 0.25f;
    private static final Map<class_2338, TimedBlock> blocksToRestore = new ConcurrentHashMap<class_2338, TimedBlock>();
    private static final Map<class_2338, class_2338> currentToOriginal = new ConcurrentHashMap<class_2338, class_2338>();
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"ModNetworking");

    public static void registerPackets() {
        PayloadTypeRegistry.playS2C().register(AnimationHMPacketS2C.ID, AnimationHMPacketS2C.CODEC);
        PayloadTypeRegistry.playC2S().register(RockSmashPacketC2S.ID, RockSmashPacketC2S.CODEC);
        PayloadTypeRegistry.playC2S().register(CutPacketC2S.ID, CutPacketC2S.CODEC);
        PayloadTypeRegistry.playC2S().register(StrengthPacketC2S.ID, StrengthPacketC2S.CODEC);
        PayloadTypeRegistry.playC2S().register(FlyPacketC2S.ID, FlyPacketC2S.CODEC);
        PayloadTypeRegistry.playC2S().register(FlyMenuC2SPacket.ID, FlyMenuC2SPacket.CODEC);
        PayloadTypeRegistry.playS2C().register(FlyMenuS2CPacket.ID, FlyMenuS2CPacket.CODEC);
        PayloadTypeRegistry.playC2S().register(FlashPacketC2S.ID, FlashPacketC2S.CODEC);
        PayloadTypeRegistry.playC2S().register(FlashMenuC2SPacket.ID, FlashMenuC2SPacket.CODEC);
        PayloadTypeRegistry.playS2C().register(FlashMenuS2CPacket.ID, FlashMenuS2CPacket.CODEC);
        PayloadTypeRegistry.playC2S().register(TeleportPacketC2S.ID, TeleportPacketC2S.CODEC);
        PayloadTypeRegistry.playC2S().register(TeleportMenuC2SPacket.ID, TeleportMenuC2SPacket.CODEC);
        PayloadTypeRegistry.playS2C().register(TeleportMenuS2CPacket.ID, TeleportMenuS2CPacket.CODEC);
        ModNetworking.registerC2SPackets();
    }

    public static void registerC2SPackets() {
        ModNetworking.registerRockSmashHandler();
        ModNetworking.registerCutHandler();
        ModNetworking.registerStrengthHandler();
        ModNetworking.registerFlyHandler();
        ModNetworking.registerTeleportHandler();
        ModNetworking.registerFlashHandler();
    }

    private static void registerTeleportHandler() {
        ServerPlayNetworking.registerGlobalReceiver(TeleportPacketC2S.ID, (payload, context) -> {
            class_3222 player = context.player();
            context.server().execute(() -> {
                if (!PartyUtils.hasMove(player, "teleport")) {
                    player.method_7353((class_2561)class_2561.method_43470((String)"\u274c No Pok\u00e9mon in your party knows Teleport!"), false);
                    return;
                }
                RenderablePokemon renderablePokemon = PartyUtils.getRenderPokemonByMove(player, "teleport");
                if (renderablePokemon != null) {
                    ServerPlayNetworking.send((class_3222)player, (class_8710)new AnimationHMPacketS2C(renderablePokemon));
                }
                class_2338 spawnPos = player.method_26280();
                class_3218 spawnWorld = null;
                if (spawnPos != null) {
                    spawnWorld = Objects.requireNonNull(player.method_5682()).method_3847(player.method_26281());
                }
                if (spawnPos == null || spawnWorld == null) {
                    spawnWorld = Objects.requireNonNull(player.method_5682()).method_30002();
                    spawnPos = spawnWorld.method_43126();
                }
                player.method_14251(spawnWorld, (double)spawnPos.method_10263() + 0.5, (double)(spawnPos.method_10264() + 1), (double)spawnPos.method_10260() + 0.5, player.method_36454(), player.method_36455());
                player.method_17356(ModSounds.TELEPORT, class_3419.field_15248, 1.0f, 1.0f);
                player.method_7353((class_2561)class_2561.method_43470((String)"\u2728 Teleported to your spawn point!"), false);
            });
        });
    }

    private static void registerFlashHandler() {
        ServerPlayNetworking.registerGlobalReceiver(FlashPacketC2S.ID, (payload, context) -> {
            class_3222 player = context.player();
            context.server().execute(() -> {
                if (!PartyUtils.hasMove(player, "flash")) {
                    player.method_7353((class_2561)class_2561.method_43470((String)"\u274c No Pok\u00e9mon in your party knows Flash!"), false);
                    return;
                }
                if (player.method_6059(class_1294.field_5925)) {
                    player.method_7353((class_2561)class_2561.method_43470((String)"\u2757 Flash is already active!"), false);
                    return;
                }
                RenderablePokemon renderablePokemon = PartyUtils.getRenderPokemonByMove(player, "flash");
                if (renderablePokemon != null) {
                    ServerPlayNetworking.send((class_3222)player, (class_8710)new AnimationHMPacketS2C(renderablePokemon));
                }
                int durationSeconds = ModConfig.FLASH_DURATION;
                int durationTicks = durationSeconds * 20;
                player.method_6092(new class_1293(class_1294.field_5925, durationTicks, 0, false, false));
                player.method_17356(ModSounds.FLASH, class_3419.field_15248, 1.0f, 1.0f);
                player.method_7353((class_2561)class_2561.method_43470((String)("\u2728 Flash activated! You can see clearly for " + durationSeconds + " seconds.")), false);
            });
        });
    }

    private static void registerFlyHandler() {
        ServerPlayNetworking.registerGlobalReceiver(FlyPacketC2S.ID, (payload, context) -> {
            class_3222 player = context.player();
            context.server().execute(() -> {
                if (!PartyUtils.hasMove(player, "fly")) {
                    player.method_7353((class_2561)class_2561.method_43470((String)"\u274c No Pok\u00e9mon in your party knows Fly!"), false);
                    return;
                }
                class_2338 targetPos = payload.pos();
                if (!player.method_37908().method_22340(targetPos)) {
                    player.method_7353((class_2561)class_2561.method_43470((String)"\u26a0\ufe0f The target location is not loaded!"), false);
                    return;
                }
                RenderablePokemon renderablePokemon = PartyUtils.getRenderPokemonByMove(player, "fly");
                if (renderablePokemon != null) {
                    ServerPlayNetworking.send((class_3222)player, (class_8710)new AnimationHMPacketS2C(renderablePokemon));
                }
                player.method_14251((class_3218)player.method_37908(), (double)targetPos.method_10263() + 0.5, (double)targetPos.method_10264(), (double)targetPos.method_10260() + 0.5, player.method_36454(), player.method_36455());
                player.method_17356(ModSounds.FLY, class_3419.field_15248, 1.0f, 1.0f);
                player.method_7353((class_2561)class_2561.method_43470((String)("\ud83d\udeeb Teleported to " + targetPos.method_10263() + ", " + targetPos.method_10264() + ", " + targetPos.method_10260())), false);
            });
        });
    }

    private static void registerRockSmashHandler() {
        ServerPlayNetworking.registerGlobalReceiver(RockSmashPacketC2S.ID, (payload, context) -> {
            class_3222 player = context.player();
            context.server().execute(() -> {
                class_2338 pos = payload.pos();
                if (!PartyUtils.hasMove(player, "rocksmash")) {
                    player.method_7353((class_2561)class_2561.method_43470((String)"\u274c No Pok\u00e9mon in your party knows Rock Smash!"), false);
                    return;
                }
                class_2680 originalState = player.method_37908().method_8320(pos);
                if (originalState.method_26215()) {
                    player.method_7353((class_2561)class_2561.method_43470((String)"\u26a0\ufe0f There's nothing to break here!"), false);
                    return;
                }
                if (blocksToRestore.containsKey(pos)) {
                    player.method_7353((class_2561)class_2561.method_43470((String)"\u23f3 The block has already been smashed, wait for it to return!"), false);
                    return;
                }
                player.method_7353((class_2561)class_2561.method_43470((String)"\ud83d\udca5 you used Rock Smash!"), false);
                player.method_17356(ModSounds.BREAKABLE_ROCK, class_3419.field_15248, 1.0f, 1.0f);
                player.method_37908().method_8501(pos, class_2246.field_10124.method_9564());
                blocksToRestore.put(pos, new TimedBlock(originalState, ModConfig.ROCKSMASH_RESPAWN * 20, null));
                player.field_13987.method_14364((class_2596)new class_2675((class_2394)class_2398.field_11204, true, (double)((float)pos.method_10263() + 0.5f), (double)((float)pos.method_10264() + 0.5f), (double)((float)pos.method_10260() + 0.5f), 0.3f, 0.3f, 0.3f, 0.1f, 20));
                LOGGER.info("Block Rock removed at {}, restore timer started", (Object)pos);
                if (player.method_37908().field_9229.method_43057() < 0.25f) {
                    ModNetworking.spawnWildPokemonAttack(player);
                } else {
                    RenderablePokemon renderablePokemon = PartyUtils.getRenderPokemonByMove(player, "rocksmash");
                    if (renderablePokemon != null) {
                        ServerPlayNetworking.send((class_3222)player, (class_8710)new AnimationHMPacketS2C(renderablePokemon));
                    }
                }
            });
        });
    }

    private static void spawnWildPokemonAttack(class_3222 player) {
        Species species = PokemonSpecies.INSTANCE.getByName("geodude");
        if (species == null) {
            LOGGER.warn("Pokemon spec non found!");
            return;
        }
        Pokemon pokemon = new Pokemon();
        pokemon.setSpecies(species);
        pokemon.setLevel(10);
        pokemon.getMoveSet().setMove(2, Objects.requireNonNull(Moves.INSTANCE.getByName("rockthrow")).create());
        pokemon.getMoveSet().setMove(3, Objects.requireNonNull(Moves.INSTANCE.getByName("rockthrow")).create());
        pokemon.getMoveSet().setMove(1, Objects.requireNonNull(Moves.INSTANCE.getByName("selfdestruct")).create());
        class_1299 type = CobblemonEntities.POKEMON;
        PokemonEntity pokemonEntity = new PokemonEntity(player.method_37908(), pokemon, type);
        pokemonEntity.setPokemon(pokemon);
        class_2338 spawnPos = player.method_24515().method_10069(1, 0, 0);
        pokemonEntity.method_5725(spawnPos, 0.0f, 0.0f);
        player.method_37908().method_8649((class_1297)pokemonEntity);
        BattleBuilder.INSTANCE.pve(player, pokemonEntity);
    }

    private static void registerCutHandler() {
        ServerPlayNetworking.registerGlobalReceiver(CutPacketC2S.ID, (payload, context) -> {
            class_3222 player = context.player();
            context.server().execute(() -> {
                class_2338 pos = payload.pos();
                if (!PartyUtils.hasMove(player, "cut")) {
                    player.method_7353((class_2561)class_2561.method_43470((String)"\u274c No Pok\u00e9mon in your party knows Cut!"), false);
                    return;
                }
                class_2680 originalState = player.method_37908().method_8320(pos);
                if (originalState.method_26215()) {
                    player.method_7353((class_2561)class_2561.method_43470((String)"\u26a0\ufe0f There's nothing to cut here!"), false);
                    return;
                }
                if (blocksToRestore.containsKey(pos)) {
                    player.method_7353((class_2561)class_2561.method_43470((String)"\u23f3 The block has already been cut, wait for it to return!"), false);
                    return;
                }
                RenderablePokemon renderablePokemon = PartyUtils.getRenderPokemonByMove(player, "cut");
                if (renderablePokemon != null) {
                    ServerPlayNetworking.send((class_3222)player, (class_8710)new AnimationHMPacketS2C(renderablePokemon));
                }
                player.method_7353((class_2561)class_2561.method_43470((String)"\ud83d\udca5 you used Cut!"), false);
                player.method_17356(ModSounds.CUTTABLE_TREE, class_3419.field_15248, 1.0f, 1.0f);
                player.method_37908().method_8501(pos, class_2246.field_10124.method_9564());
                blocksToRestore.put(pos, new TimedBlock(originalState, ModConfig.CUT_RESPAWN * 20, null));
                player.field_13987.method_14364((class_2596)new class_2675((class_2394)class_2398.field_43379, true, (double)((float)pos.method_10263() + 0.5f), (double)((float)pos.method_10264() + 0.5f), (double)((float)pos.method_10260() + 0.5f), 0.3f, 0.3f, 0.3f, 0.1f, 20));
                LOGGER.info("Block removed at {}, restore timer started", (Object)pos);
            });
        });
    }

    private static void registerStrengthHandler() {
        ServerPlayNetworking.registerGlobalReceiver(StrengthPacketC2S.ID, (payload, context) -> {
            class_3222 player = context.player();
            context.server().execute(() -> {
                class_2338 clickedPos = payload.pos();
                if (!PartyUtils.hasMove(player, "strength")) {
                    player.method_7353((class_2561)class_2561.method_43470((String)"\u274c No Pok\u00e9mon in your party knows Strength!"), false);
                    return;
                }
                class_2338 originalPos = currentToOriginal.getOrDefault(clickedPos, clickedPos);
                TimedBlock timedBlock = blocksToRestore.get(originalPos);
                class_2338 currentPos = timedBlock != null && timedBlock.movedTo != null ? timedBlock.movedTo : originalPos;
                class_2680 blockState = player.method_37908().method_8320(currentPos);
                if (blockState.method_26215()) {
                    player.method_7353((class_2561)class_2561.method_43470((String)"\u26a0\ufe0f There's nothing to move here!"), false);
                    return;
                }
                class_2338 targetPos = currentPos.method_10093(player.method_5735());
                if (!player.method_37908().method_8320(targetPos).method_26215()) {
                    player.method_7353((class_2561)class_2561.method_43470((String)"\u26d4 Cannot push the block there!"), false);
                    player.method_17356(ModSounds.WALL_BUMP, class_3419.field_15248, 1.0f, 1.0f);
                    return;
                }
                RenderablePokemon renderablePokemon = PartyUtils.getRenderPokemonByMove(player, "strength");
                if (renderablePokemon != null) {
                    ServerPlayNetworking.send((class_3222)player, (class_8710)new AnimationHMPacketS2C(renderablePokemon));
                }
                player.method_7353((class_2561)class_2561.method_43470((String)"\ud83d\udca5 you used Strength!"), false);
                player.method_17356(ModSounds.MOVABLE_ROCK, class_3419.field_15248, 1.0f, 1.0f);
                player.method_37908().method_8501(currentPos, class_2246.field_10124.method_9564());
                currentToOriginal.remove(currentPos);
                player.method_37908().method_8501(targetPos, blockState);
                currentToOriginal.put(targetPos, originalPos);
                if (timedBlock != null) {
                    timedBlock.movedTo = targetPos;
                    timedBlock.ticksLeft = ModConfig.STRENGTH_RESPAWN * 20;
                } else {
                    TimedBlock tb = new TimedBlock(blockState, ModConfig.STRENGTH_RESPAWN * 20, targetPos);
                    blocksToRestore.put(originalPos, tb);
                }
            });
        });
    }

    public static void tick(MinecraftServer server) {
        class_3218 world = server.method_30002();
        blocksToRestore.entrySet().removeIf(entry -> {
            class_2338 originalPos = (class_2338)entry.getKey();
            TimedBlock timedBlock = (TimedBlock)entry.getValue();
            --timedBlock.ticksLeft;
            if (timedBlock.ticksLeft > 0) {
                return false;
            }
            if (timedBlock.fallingEntity != null && timedBlock.fallingEntity.method_5805()) {
                timedBlock.fallingEntity.method_31472();
            }
            if (timedBlock.movedTo != null && !timedBlock.movedTo.equals((Object)originalPos)) {
                class_2338 moved = timedBlock.movedTo;
                class_2680 stateAtMoved = world.method_8320(moved);
                if (stateAtMoved.method_27852(timedBlock.blockState.method_26204())) {
                    world.method_8501(moved, class_2246.field_10124.method_9564());
                    currentToOriginal.remove(moved);
                } else {
                    int maxSearch = 64;
                    class_2338 scan = moved.method_10074();
                    boolean removed = false;
                    for (int steps = 0; scan.method_10264() >= world.method_31607() && steps < 64; ++steps) {
                        class_2680 s = world.method_8320(scan);
                        if (s.method_27852(timedBlock.blockState.method_26204())) {
                            world.method_8501(scan, class_2246.field_10124.method_9564());
                            currentToOriginal.remove(scan);
                            removed = true;
                            break;
                        }
                        if (!s.method_26215()) {
                            // empty if block
                        }
                        scan = scan.method_10074();
                    }
                    currentToOriginal.remove(moved);
                }
            }
            world.method_8501(originalPos, timedBlock.blockState);
            currentToOriginal.remove(originalPos);
            LOGGER.info("Block restored at {}", (Object)originalPos);
            return true;
        });
    }

    private static class TimedBlock {
        final class_2680 blockState;
        class_2338 movedTo;
        int ticksLeft;
        class_1540 fallingEntity;

        TimedBlock(class_2680 blockState, int ticksLeft, class_2338 movedTo) {
            this.blockState = blockState;
            this.ticksLeft = ticksLeft;
            this.movedTo = movedTo;
        }
    }
}

