/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.khataly.mapkit.command.custom;

import com.cobblemon.khataly.mapkit.util.TeleportPairRegistry;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_3218;

public class TeleportBlockCommands {
    private static final SuggestionProvider<class_2168> SUGGEST_IDS = TeleportBlockCommands::suggestIds;

    private static CompletableFuture<Suggestions> suggestIds(CommandContext<class_2168> ctx, SuggestionsBuilder builder) {
        class_3218 world = ((class_2168)ctx.getSource()).method_9225();
        TeleportPairRegistry reg = TeleportPairRegistry.get(world);
        LinkedHashSet candidates = new LinkedHashSet();
        reg.getPairs().keySet().forEach(full -> {
            candidates.add(full);
            candidates.add(full.substring(0, Math.min(8, full.length())));
        });
        return class_2172.method_9265(candidates, (SuggestionsBuilder)builder);
    }

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"teleportblock").requires(src -> src.method_9259(2))).then(class_2170.method_9247((String)"list").executes(ctx -> {
            class_2168 source = (class_2168)ctx.getSource();
            class_3218 world = source.method_9225();
            TeleportPairRegistry reg = TeleportPairRegistry.get(world);
            Map<String, TeleportPairRegistry.Pair> pairs = reg.getPairs();
            if (pairs.isEmpty()) {
                source.method_45068((class_2561)class_2561.method_43470((String)"\u00a7eNo teleport pairs registered."));
                return 1;
            }
            source.method_45068((class_2561)class_2561.method_43470((String)"\u00a76-- Registered Teleport Pairs --"));
            pairs.forEach((id, pair) -> {
                String a = TeleportBlockCommands.formatPos(pair.a());
                String b = pair.b() != null ? TeleportBlockCommands.formatPos(pair.b()) : "--";
                source.method_45068((class_2561)class_2561.method_43470((String)("\u00a77" + id.substring(0, 8) + " \u00a7f: \u00a7b" + a + " \u00a77<-> \u00a7b" + b)));
            });
            return 1;
        }))).then(class_2170.method_9247((String)"cleanup").executes(ctx -> {
            class_2168 source = (class_2168)ctx.getSource();
            class_3218 world = source.method_9225();
            TeleportPairRegistry reg = TeleportPairRegistry.get(world);
            int removed = reg.cleanup(world);
            source.method_45068((class_2561)class_2561.method_43470((String)("\u00a7aCleaned up " + removed + " incomplete teleport pairs.")));
            return removed;
        }))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"id", (ArgumentType)StringArgumentType.word()).suggests(SUGGEST_IDS).executes(ctx -> {
            class_2168 source = (class_2168)ctx.getSource();
            class_3218 world = source.method_9225();
            String input = StringArgumentType.getString((CommandContext)ctx, (String)"id");
            TeleportPairRegistry reg = TeleportPairRegistry.get(world);
            Optional<String> fullId = reg.getPairs().keySet().stream().filter(k -> k.equals(input) || k.startsWith(input)).findFirst();
            if (fullId.isEmpty()) {
                source.method_45068((class_2561)class_2561.method_43470((String)"\u00a7cTeleport pair ID not found."));
                return 0;
            }
            reg.getPairs().remove(fullId.get());
            reg.method_80();
            source.method_45068((class_2561)class_2561.method_43470((String)("\u00a7aTeleport pair " + fullId.get().substring(0, 8) + " removed.")));
            return 1;
        }))));
    }

    private static String formatPos(TeleportPairRegistry.TeleportLocation loc) {
        return String.format("(%d, %d, %d) in %s", loc.pos().method_10263(), loc.pos().method_10264(), loc.pos().method_10260(), loc.dimension().method_29177().toString());
    }
}

