/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.khataly.mapkit.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class PlayerLevelCapProgress {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File ROOT = new File("config/cobblemonmapkit/progress/player_levelcap");
    private static final int CURRENT_SCHEMA_VERSION = 1;
    private static final Map<UUID, Set<String>> cache = new HashMap<UUID, Set<String>>();

    public static Set<String> getApplied(UUID uuid) {
        PlayerLevelCapProgress.ensureLoaded(uuid);
        return Collections.unmodifiableSet(cache.getOrDefault(uuid, Collections.emptySet()));
    }

    public static boolean isApplied(UUID uuid, String label) {
        PlayerLevelCapProgress.ensureLoaded(uuid);
        return cache.getOrDefault(uuid, Collections.emptySet()).contains(PlayerLevelCapProgress.safeLower(label));
    }

    public static boolean apply(UUID uuid, String label) {
        PlayerLevelCapProgress.ensureLoaded(uuid);
        String k = PlayerLevelCapProgress.safeLower(label);
        Set set = cache.computeIfAbsent(uuid, u -> new HashSet());
        boolean added = set.add(k);
        if (added) {
            PlayerLevelCapProgress.save(uuid);
        }
        return added;
    }

    public static boolean remove(UUID uuid, String label) {
        PlayerLevelCapProgress.ensureLoaded(uuid);
        String k = PlayerLevelCapProgress.safeLower(label);
        Set set = cache.getOrDefault(uuid, null);
        if (set == null) {
            return false;
        }
        boolean removed = set.remove(k);
        if (removed) {
            PlayerLevelCapProgress.save(uuid);
        }
        return removed;
    }

    public static void applyAll(UUID uuid, Collection<String> labels) {
        PlayerLevelCapProgress.ensureLoaded(uuid);
        if (labels == null || labels.isEmpty()) {
            return;
        }
        Set set = cache.computeIfAbsent(uuid, u -> new HashSet());
        boolean changed = false;
        for (String l : labels) {
            if (l == null) continue;
            changed |= set.add(l.toLowerCase(Locale.ROOT));
        }
        if (changed) {
            PlayerLevelCapProgress.save(uuid);
        }
    }

    public static void clearAll(UUID uuid) {
        cache.put(uuid, new HashSet());
        PlayerLevelCapProgress.save(uuid);
    }

    private static void ensureLoaded(UUID uuid) {
        if (cache.containsKey(uuid)) {
            return;
        }
        cache.put(uuid, new HashSet());
        PlayerLevelCapProgress.load(uuid);
    }

    private static File fileFor(UUID uuid) {
        return new File(ROOT, uuid.toString() + ".json");
    }

    private static void load(UUID uuid) {
        try {
            File f;
            File dir = ROOT;
            if (!dir.exists() && !dir.mkdirs()) {
                PlayerLevelCapProgress.logWarn("Could not create progress directory: " + dir.getAbsolutePath());
            }
            if (!(f = PlayerLevelCapProgress.fileFor(uuid)).exists()) {
                cache.put(uuid, new HashSet());
                return;
            }
            try (FileReader r = new FileReader(f);){
                Data d = (Data)GSON.fromJson((Reader)r, Data.class);
                if (d == null || d.applied == null) {
                    cache.put(uuid, new HashSet());
                } else {
                    HashSet<String> s = new HashSet<String>();
                    for (String k : d.applied) {
                        if (k == null) continue;
                        s.add(k.toLowerCase(Locale.ROOT));
                    }
                    cache.put(uuid, s);
                }
            }
        }
        catch (Exception e) {
            PlayerLevelCapProgress.logError("Error loading level-cap progress for " + String.valueOf(uuid), e);
            cache.put(uuid, new HashSet());
        }
    }

    private static void save(UUID uuid) {
        try {
            File dir = ROOT;
            if (!dir.exists() && !dir.mkdirs()) {
                PlayerLevelCapProgress.logWarn("Could not create progress directory: " + dir.getAbsolutePath());
            }
            File f = PlayerLevelCapProgress.fileFor(uuid);
            Data d = new Data();
            d.schemaVersion = 1;
            d.applied = new ArrayList<String>(cache.getOrDefault(uuid, Collections.emptySet()));
            File temp = new File(f.getParentFile(), f.getName() + ".tmp");
            try (FileWriter w = new FileWriter(temp);){
                GSON.toJson((Object)d, (Appendable)w);
            }
            try {
                Files.move(temp.toPath(), f.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
            }
            catch (IOException atomicNotSupported) {
                Files.move(temp.toPath(), f.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (Exception e) {
            PlayerLevelCapProgress.logError("Error saving level-cap progress for " + String.valueOf(uuid), e);
        }
    }

    private static String safeLower(String s) {
        return s == null ? "" : s.toLowerCase(Locale.ROOT);
    }

    private static void logWarn(String msg) {
        System.out.println("[PlayerLevelCapProgress][WARN] " + msg);
    }

    private static void logError(String msg, Throwable t) {
        System.err.println("[PlayerLevelCapProgress][ERROR] " + msg);
        if (t != null) {
            StringWriter sw = new StringWriter();
            t.printStackTrace(new PrintWriter(sw));
            System.err.println(sw.toString());
        }
    }

    private static class Data {
        Integer schemaVersion;
        List<String> applied = new ArrayList<String>();

        private Data() {
        }
    }
}

