/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.khataly.mapkit.event.server;

import com.cobblemon.khataly.mapkit.config.LevelCapConfig;
import com.cobblemon.khataly.mapkit.config.PlayerLevelCapProgress;
import com.cobblemon.khataly.mapkit.util.LevelCapService;
import com.cobblemon.mod.common.api.Priority;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Unit;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;

public final class LevelCapProgressionWatcher {
    private static final Map<UUID, Long> nextScanAt = new HashMap<UUID, Long>();
    private static final long RESCAN_INTERVAL_MS = 1000L;

    private LevelCapProgressionWatcher() {
    }

    public static void register() {
        CobblemonEvents.DATA_SYNCHRONIZED.subscribe(Priority.NORMAL, player -> {
            if (player != null) {
                LevelCapProgressionWatcher.scheduleSoon(player.method_5667(), 0L);
            }
            return Unit.INSTANCE;
        });
        ServerTickEvents.END_SERVER_TICK.register(LevelCapProgressionWatcher::tickServer);
    }

    public static void requestScan(class_3222 player) {
        if (player != null) {
            LevelCapProgressionWatcher.scheduleSoon(player.method_5667(), 0L);
        }
    }

    private static void tickServer(MinecraftServer server) {
        long now = System.currentTimeMillis();
        ArrayList due = new ArrayList();
        nextScanAt.entrySet().removeIf(e -> {
            if ((Long)e.getValue() <= now) {
                due.add((UUID)e.getKey());
                return true;
            }
            return false;
        });
        for (UUID uuid : due) {
            class_3222 player = server.method_3760().method_14602(uuid);
            if (player == null) continue;
            if (LevelCapConfig.isEnabled()) {
                LevelCapProgressionWatcher.scanAndApply(player);
            }
            LevelCapProgressionWatcher.scheduleSoon(uuid, 1000L);
        }
    }

    private static void scanAndApply(class_3222 player) {
        if (!LevelCapConfig.isEnabled()) {
            return;
        }
        if (player == null || player.method_5682() == null) {
            return;
        }
        Map<String, Integer> labelsCaps = LevelCapConfig.getAllLabelsWithCaps();
        if (labelsCaps.isEmpty()) {
            return;
        }
        UUID uuid = player.method_5667();
        int appliedNow = 0;
        for (String labelKey : new ArrayList<String>(labelsCaps.keySet())) {
            boolean added;
            List<String> itemIds;
            if (PlayerLevelCapProgress.isApplied(uuid, labelKey) || (itemIds = LevelCapConfig.getItemIdsForLabel(labelKey)) == null || itemIds.isEmpty() || !LevelCapProgressionWatcher.hasAnyOf(player, itemIds) || !(added = PlayerLevelCapProgress.apply(uuid, labelKey))) continue;
            ++appliedNow;
            int newCap = labelsCaps.getOrDefault(labelKey, LevelCapConfig.getBaseCap());
            int effectiveAfter = Math.max(LevelCapService.getEffectiveCap(player), newCap);
            String display = LevelCapConfig.displayLabel(labelKey);
            player.method_7353((class_2561)class_2561.method_43470((String)("\u00a7aProgress unlocked: \u00a7f" + display + " \u00a7a\u2192 level cap now " + effectiveAfter + ".")), false);
        }
        if (appliedNow > 0) {
            int cap = LevelCapService.getEffectiveCap(player);
            player.method_7353((class_2561)class_2561.method_43470((String)("\u00a7aYour effective cap is \u00a7f" + cap + "\u00a7a.")), false);
        }
    }

    private static void scheduleSoon(UUID uuid, long delayMs) {
        long when = System.currentTimeMillis() + Math.max(0L, delayMs);
        long existing = nextScanAt.getOrDefault(uuid, 0L);
        if (existing == 0L || when < existing) {
            nextScanAt.put(uuid, when);
        }
    }

    private static boolean hasAnyOf(class_3222 player, Collection<String> itemIds) {
        for (String raw : itemIds) {
            if (raw == null || raw.isBlank() || !LevelCapProgressionWatcher.hasItemInInventory(player, raw)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasItemInInventory(class_3222 player, String itemId) {
        class_1799 s;
        int i;
        class_2960 id = class_2960.method_12829((String)itemId);
        if (id == null) {
            return false;
        }
        class_1792 target = (class_1792)class_7923.field_41178.method_10223(id);
        for (i = 0; i < player.method_31548().field_7547.size(); ++i) {
            s = (class_1799)player.method_31548().field_7547.get(i);
            if (s.method_7960() || s.method_7909() != target) continue;
            return true;
        }
        for (i = 0; i < player.method_31548().field_7544.size(); ++i) {
            s = (class_1799)player.method_31548().field_7544.get(i);
            if (s.method_7960() || s.method_7909() != target) continue;
            return true;
        }
        for (i = 0; i < player.method_31548().field_7548.size(); ++i) {
            s = (class_1799)player.method_31548().field_7548.get(i);
            if (s.method_7960() || s.method_7909() != target) continue;
            return true;
        }
        return false;
    }
}

