/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.khataly.mapkit.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_7225;

public class TeleportPairRegistry
extends class_18 {
    private final Map<String, Pair> pairs = new HashMap<String, Pair>();
    public static final Codec<TeleportPairRegistry> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.unboundedMap((Codec)Codec.STRING, Pair.CODEC).fieldOf("pairs").forGetter(TeleportPairRegistry::getPairs)).apply((Applicative)i, TeleportPairRegistry::new));
    public static final class_18.class_8645<TeleportPairRegistry> TYPE = new class_18.class_8645(TeleportPairRegistry::new, TeleportPairRegistry::readNbt, null);

    public TeleportPairRegistry(Map<String, Pair> loaded) {
        this.pairs.putAll(loaded);
    }

    public TeleportPairRegistry() {
    }

    public Map<String, Pair> getPairs() {
        return this.pairs;
    }

    public String addTeleport(class_3218 world, class_2338 pos) {
        TeleportLocation loc = new TeleportLocation((class_5321<class_1937>)world.method_27983(), pos);
        for (Map.Entry<String, Pair> e : this.pairs.entrySet()) {
            Pair p = e.getValue();
            if (p.b() != null) continue;
            this.pairs.put(e.getKey(), new Pair(p.a(), loc));
            this.method_80();
            return e.getKey();
        }
        String id = UUID.randomUUID().toString();
        this.pairs.put(id, new Pair(loc, null));
        this.method_80();
        return id;
    }

    public TeleportLocation getOther(String id, class_2338 me, class_5321<class_1937> currentDim) {
        Pair p = this.pairs.get(id);
        if (p == null || p.b() == null) {
            return null;
        }
        TeleportLocation a = p.a();
        TeleportLocation b = p.b();
        if (a.dimension().equals(currentDim) && a.pos().equals((Object)me)) {
            return b;
        }
        if (b.dimension().equals(currentDim) && b.pos().equals((Object)me)) {
            return a;
        }
        return null;
    }

    public int cleanup(class_3218 world) {
        int size0 = this.pairs.size();
        this.pairs.entrySet().removeIf(e -> {
            Pair p = (Pair)e.getValue();
            boolean aOk = world.method_8503().method_3847(p.a().dimension()) != null && Objects.requireNonNull(world.method_8503().method_3847(p.a().dimension())).method_8321(p.a().pos()) != null;
            boolean bOk = p.b() == null || world.method_8503().method_3847(p.b().dimension()) != null && Objects.requireNonNull(world.method_8503().method_3847(p.b().dimension())).method_8321(p.b().pos()) != null;
            return !aOk || !bOk;
        });
        int removed = size0 - this.pairs.size();
        if (removed > 0) {
            this.method_80();
        }
        return removed;
    }

    public class_2487 method_75(class_2487 nbt, class_7225.class_7874 registryLookup) {
        Codec.unboundedMap((Codec)Codec.STRING, Pair.CODEC).encodeStart((DynamicOps)class_2509.field_11560, this.pairs).resultOrPartial(err -> System.err.println("TeleportPair save error: " + err)).ifPresent(enc -> nbt.method_10566("pairs", enc));
        return nbt;
    }

    public static TeleportPairRegistry readNbt(class_2487 nbt, class_7225.class_7874 registryLookup) {
        if (!nbt.method_10573("pairs", 10)) {
            return new TeleportPairRegistry();
        }
        DataResult result = Codec.unboundedMap((Codec)Codec.STRING, Pair.CODEC).parse((DynamicOps)class_2509.field_11560, (Object)nbt.method_10580("pairs"));
        Map loaded = result.resultOrPartial(err -> System.err.println("TeleportPair load error: " + err)).orElse(new HashMap());
        return new TeleportPairRegistry(loaded);
    }

    public static TeleportPairRegistry get(class_3218 world) {
        class_3218 overworld = world.method_8503().method_30002();
        return (TeleportPairRegistry)overworld.method_17983().method_17924(TYPE, "teleport_pairs");
    }

    public record TeleportLocation(class_5321<class_1937> dimension, class_2338 pos) {
        public static final Codec<TeleportLocation> CODEC = RecordCodecBuilder.create(i -> i.group((App)class_1937.field_25178.fieldOf("dimension").forGetter(TeleportLocation::dimension), (App)class_2338.field_25064.fieldOf("pos").forGetter(TeleportLocation::pos)).apply((Applicative)i, TeleportLocation::new));
    }

    public record Pair(TeleportLocation a, TeleportLocation b) {
        public static final Codec<Pair> CODEC = RecordCodecBuilder.create(i -> i.group((App)TeleportLocation.CODEC.fieldOf("a").forGetter(Pair::a), (App)TeleportLocation.CODEC.optionalFieldOf("b").forGetter(p -> Optional.ofNullable(p.b()))).apply((Applicative)i, (a, bOpt) -> new Pair((TeleportLocation)a, bOpt.orElse(null))));
    }
}

