/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.khataly.modhm.block.renderer;

import com.cobblemon.khataly.modhm.block.entity.custom.UltraHolePortalEntity;
import java.util.Random;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1092;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5614;
import net.minecraft.class_5743;
import net.minecraft.class_638;
import net.minecraft.class_827;
import org.joml.Vector3f;

public class UltraHolePortalRenderer
implements class_827<UltraHolePortalEntity> {
    private static final Random RANDOM = new Random();
    private static final float INNER_BASE_HUE = 0.8f;
    private static final float INNER_HUE_RANGE = 0.06f;
    private static final float INNER_SAT_BASE = 0.85f;
    private static final float INNER_SAT_RANGE = 0.15f;
    private static final float INNER_VAL_EDGE = 0.62f;
    private static final float INNER_VAL_CORE = 0.05f;
    private static final float NOISE_FREQ = 1.6f;
    private static final float NOISE_SPEEDX = 0.2f;
    private static final float NOISE_SPEEDY = -0.15f;
    private static final int NOISE_OCTAVES = 4;
    private static final float NOISE_GAIN = 0.55f;
    private static final float NOISE_LACUNARITY = 2.1f;
    private static final int DEPTH_LAYERS = 10;
    private static final float LAYER_Z_STEP = 0.12f;
    private static final float LAYER_RADIUS_SHRINK = 0.07f;
    private static final int RING_STEPS = 128;
    private static final int RADIAL_BANDS = 10;
    private static final float RING_BASE_HUE = 0.76f;

    public UltraHolePortalRenderer(class_5614.class_5615 ctx) {
    }

    public void render(UltraHolePortalEntity entity, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        float radius;
        class_638 world = class_310.method_1551().field_1687;
        if (world == null) {
            return;
        }
        class_2338 pos = entity.method_11016();
        int growDuration = 200;
        int stableDuration = 1200;
        int shrinkDuration = 200;
        float maxRadiusFinal = 1.5f;
        float minRadius = 0.05f;
        int localAge = entity.getAge() + 1;
        entity.setAge(localAge);
        double time = (float)localAge + tickDelta;
        class_310 mc = class_310.method_1551();
        if (localAge < growDuration) {
            float progress = ((float)localAge + tickDelta) / (float)growDuration;
            radius = maxRadiusFinal * progress;
            if (mc.field_1724 != null) {
                float volume = 0.2f + 0.8f * progress;
                float pitch = 0.5f + 1.0f * progress;
                mc.method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)class_3417.field_19197, (float)volume, (float)pitch));
            }
        } else if (localAge < growDuration + stableDuration) {
            radius = maxRadiusFinal;
        } else if (localAge < growDuration + stableDuration + shrinkDuration) {
            int shrinkAge = localAge - (growDuration + stableDuration);
            float progress = 1.0f - ((float)shrinkAge + tickDelta) / (float)shrinkDuration;
            radius = Math.max(maxRadiusFinal * progress, minRadius);
        } else {
            radius = minRadius;
        }
        if (localAge >= growDuration && localAge < growDuration + stableDuration && localAge % 40 == 0) {
            float vol = 0.25f;
            float pitch = 0.9f + (RANDOM.nextFloat() - 0.5f) * 0.08f;
            world.method_8486((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, class_3417.field_15045, class_3419.field_15256, vol, pitch, false);
        }
        matrices.method_22903();
        matrices.method_22904(0.5, 0.5, 0.5);
        class_1092 modelManager = mc.method_1541().method_3351().method_3333();
        class_1058 white = modelManager.method_24153(class_1059.field_5275).method_4608(class_2960.method_60655((String)"minecraft", (String)"block/white_concrete"));
        class_4588 buffer = vertexConsumers.getBuffer(class_1921.method_23583());
        for (int layer = 0; layer < 10; ++layer) {
            float zOffset = -0.12f * (float)layer;
            float baseOuterR = Math.max(0.05f, radius * (1.0f - (float)layer * 0.07f));
            if (baseOuterR <= 0.001f) continue;
            int alpha = Math.max(60, 235 - layer * 18);
            for (int b = 0; b < 10; ++b) {
                float t0 = (float)b / 10.0f;
                float t1 = (float)(b + 1) / 10.0f;
                float rInner = baseOuterR * t0;
                float rOuter = baseOuterR * t1;
                for (int i = 0; i < 128; ++i) {
                    double a1 = Math.PI * 2 * (double)i / 128.0;
                    double a2 = Math.PI * 2 * (double)(i + 1) / 128.0;
                    float x1o = (float)(Math.cos(a1) * (double)rOuter);
                    float y1o = (float)(Math.sin(a1) * (double)rOuter);
                    float x2o = (float)(Math.cos(a2) * (double)rOuter);
                    float y2o = (float)(Math.sin(a2) * (double)rOuter);
                    float x1i = (float)(Math.cos(a1) * (double)rInner);
                    float y1i = (float)(Math.sin(a1) * (double)rInner);
                    float x2i = (float)(Math.cos(a2) * (double)rInner);
                    float y2i = (float)(Math.sin(a2) * (double)rInner);
                    float nx1o = x1o / baseOuterR * 1.6f + (float)time * 0.2f;
                    float ny1o = y1o / baseOuterR * 1.6f + (float)time * -0.15f;
                    float nx1i = x1i / baseOuterR * 1.6f + (float)time * 0.2f;
                    float ny1i = y1i / baseOuterR * 1.6f + (float)time * -0.15f;
                    float fOuter = UltraHolePortalRenderer.fbm(nx1o, ny1o, 4, 0.55f, 2.1f);
                    float fInner = UltraHolePortalRenderer.fbm(nx1i, ny1i, 4, 0.55f, 2.1f);
                    float tRadOuter = rOuter / (baseOuterR + 1.0E-6f);
                    float tRadInner = rInner / (baseOuterR + 1.0E-6f);
                    float vOuter = UltraHolePortalRenderer.mix(0.05f, 0.62f, tRadOuter);
                    float vInner = UltraHolePortalRenderer.mix(0.05f, 0.62f, tRadInner);
                    float hueOuter = UltraHolePortalRenderer.clamp01(0.8f + (fOuter - 0.5f) * 2.0f * 0.06f);
                    float hueInner = UltraHolePortalRenderer.clamp01(0.8f + (fInner - 0.5f) * 2.0f * 0.06f);
                    float satOuter = UltraHolePortalRenderer.clamp01(0.85f + (fOuter - 0.5f) * 2.0f * 0.15f);
                    float satInner = UltraHolePortalRenderer.clamp01(0.85f + (fInner - 0.5f) * 2.0f * 0.15f);
                    float blotO = UltraHolePortalRenderer.fbm(nx1o * 2.3f, ny1o * 2.3f, 3, 0.6f, 2.1f) * 0.18f;
                    float blotI = UltraHolePortalRenderer.fbm(nx1i * 2.3f, ny1i * 2.3f, 3, 0.6f, 2.1f) * 0.18f;
                    vOuter = UltraHolePortalRenderer.clamp01(vOuter - blotO);
                    vInner = UltraHolePortalRenderer.clamp01(vInner - blotI);
                    int colOuter = UltraHolePortalRenderer.hsvToARGB(hueOuter, satOuter, vOuter, alpha);
                    int colInner = UltraHolePortalRenderer.hsvToARGB(hueInner, satInner, vInner, alpha);
                    float u1o = white.method_4580(x1o / (baseOuterR * 2.0f) + 0.5f);
                    float v1o = white.method_4570(y1o / (baseOuterR * 2.0f) + 0.5f);
                    float u2o = white.method_4580(x2o / (baseOuterR * 2.0f) + 0.5f);
                    float v2o = white.method_4570(y2o / (baseOuterR * 2.0f) + 0.5f);
                    float u1i = white.method_4580(x1i / (baseOuterR * 2.0f) + 0.5f);
                    float v1i = white.method_4570(y1i / (baseOuterR * 2.0f) + 0.5f);
                    float u2i = white.method_4580(x2i / (baseOuterR * 2.0f) + 0.5f);
                    float v2i = white.method_4570(y2i / (baseOuterR * 2.0f) + 0.5f);
                    UltraHolePortalRenderer.putVertexUV(buffer, matrices, x1o, y1o, zOffset, colOuter, light, u1o, v1o);
                    UltraHolePortalRenderer.putVertexUV(buffer, matrices, x2o, y2o, zOffset, colOuter, light, u2o, v2o);
                    UltraHolePortalRenderer.putVertexUV(buffer, matrices, x2i, y2i, zOffset, colInner, light, u2i, v2i);
                    UltraHolePortalRenderer.putVertexUV(buffer, matrices, x1i, y1i, zOffset, colInner, light, u1i, v1i);
                }
            }
        }
        matrices.method_22909();
        int depthLayersParticles = 10;
        int baseSegments = 48;
        float spawnChance = 0.75f;
        float swirlSpeed = 0.1f;
        float inwardSpeedBase = 0.06f;
        float baseDepthPull = 0.02f;
        float jitter = 0.008f;
        float inwardSpeed = inwardSpeedBase;
        float depthPull = baseDepthPull;
        if (localAge >= growDuration + stableDuration && localAge < growDuration + stableDuration + shrinkDuration) {
            int shrinkAge = localAge - (growDuration + stableDuration);
            float t = ((float)shrinkAge + tickDelta) / (float)shrinkDuration;
            inwardSpeed += 0.04f * t;
            depthPull += 0.06f * t;
        }
        double cx = (double)pos.method_10263() + 0.5;
        double cy = (double)pos.method_10264() + 0.5;
        double cz = (double)pos.method_10260() + 0.5;
        for (int layer = 0; layer < depthLayersParticles; ++layer) {
            float zOffset = -0.12f * (float)layer;
            float layerRadius = Math.max(0.05f, radius * (1.0f - (float)layer * 0.07f));
            double rotation = time * 0.02 * (double)(layer % 2 == 0 ? 1 : -1);
            int segmentsParticles = Math.max(18, (int)((float)baseSegments * (0.5f + layerRadius)));
            for (int i = 0; i < segmentsParticles; ++i) {
                if (RANDOM.nextFloat() > spawnChance) continue;
                double angle = Math.PI * 2 * (double)i / (double)segmentsParticles + rotation;
                double localX = Math.cos(angle) * (double)layerRadius;
                double localY = Math.sin(angle) * (double)layerRadius;
                double px = cx + localX + (RANDOM.nextDouble() - 0.5) * (double)jitter;
                double py = cy + localY + (RANDOM.nextDouble() - 0.5) * (double)jitter;
                double pz = cz + (double)zOffset;
                double nx = -localX / Math.max(1.0E-6, (double)layerRadius);
                double ny = -localY / Math.max(1.0E-6, (double)layerRadius);
                double txv = -Math.sin(angle);
                double tyv = Math.cos(angle);
                double vx = nx * (double)inwardSpeed + txv * (double)swirlSpeed + (RANDOM.nextDouble() - 0.5) * (double)jitter;
                double vy = ny * (double)inwardSpeed + tyv * (double)swirlSpeed + (RANDOM.nextDouble() - 0.5) * (double)jitter;
                double vz = (double)(-depthPull) + (RANDOM.nextDouble() - 0.5) * ((double)jitter * 0.5);
                float hue = (0.76f + 0.01f * (float)Math.sin(time * 0.004 + (double)i * 0.3 + (double)layer * 0.4)) % 1.0f;
                Vector3f cBright = UltraHolePortalRenderer.hsvToVec(hue, 0.9f, 0.45f);
                Vector3f cDark = UltraHolePortalRenderer.hsvToVec(hue, 0.85f, 0.18f);
                float scale = 0.9f + RANDOM.nextFloat() * 0.6f;
                if (RANDOM.nextFloat() < 0.2f) {
                    cBright = UltraHolePortalRenderer.hsvToVec(hue, 0.9f, 0.2f);
                    cDark = UltraHolePortalRenderer.hsvToVec(hue, 0.8f, 0.05f);
                }
                world.method_8406((class_2394)new class_5743(cBright, cDark, scale), px, py, pz, vx, vy, vz);
                if (!(RANDOM.nextFloat() < 0.05f)) continue;
                world.method_8406((class_2394)class_2398.field_11207, px, py, pz, vx * 0.45, vy * 0.45, vz * 0.45);
            }
        }
    }

    private static float fbm(float x, float y, int octaves, float gain, float lacunarity) {
        float amp = 1.0f;
        float freq = 1.0f;
        float sum = 0.0f;
        float norm = 0.0f;
        for (int o = 0; o < octaves; ++o) {
            sum += amp * UltraHolePortalRenderer.smoothNoise(x * freq, y * freq);
            norm += amp;
            amp *= gain;
            freq *= lacunarity;
        }
        return sum / Math.max(1.0E-6f, norm);
    }

    private static float smoothNoise(float x, float y) {
        int x0 = (int)Math.floor(x);
        int y0 = (int)Math.floor(y);
        int x1 = x0 + 1;
        int y1 = y0 + 1;
        float sx = x - (float)x0;
        float sy = y - (float)y0;
        float n00 = UltraHolePortalRenderer.hash2(x0, y0);
        float n10 = UltraHolePortalRenderer.hash2(x1, y0);
        float n01 = UltraHolePortalRenderer.hash2(x0, y1);
        float n11 = UltraHolePortalRenderer.hash2(x1, y1);
        float ix0 = UltraHolePortalRenderer.lerp(n00, n10, UltraHolePortalRenderer.smoothstep(sx));
        float ix1 = UltraHolePortalRenderer.lerp(n01, n11, UltraHolePortalRenderer.smoothstep(sx));
        return UltraHolePortalRenderer.lerp(ix0, ix1, UltraHolePortalRenderer.smoothstep(sy));
    }

    private static float hash2(int x, int y) {
        int h = x * 374761393 + y * 668265263;
        h = (h ^ h >> 13) * 1274126177;
        h ^= h >> 16;
        return (float)(h & Integer.MAX_VALUE) / 2.1474836E9f;
    }

    private static float smoothstep(float t) {
        return t * t * (3.0f - 2.0f * t);
    }

    private static float lerp(float a, float b, float t) {
        return a + (b - a) * t;
    }

    private static float mix(float a, float b, float t) {
        return a + (b - a) * t;
    }

    private static float clamp01(float v) {
        return Math.max(0.0f, Math.min(1.0f, v));
    }

    private static void putVertexUV(class_4588 buf, class_4587 matrices, float x, float y, float z, int argb, int light, float u, float v) {
        buf.method_22918(matrices.method_23760().method_23761(), x, y, z).method_1336(argb >> 16 & 0xFF, argb >> 8 & 0xFF, argb & 0xFF, argb >> 24 & 0xFF).method_22913(u, v).method_22922(class_4608.field_21444).method_60803(light).method_22914(0.0f, 0.0f, 1.0f);
    }

    private static Vector3f hsvToVec(float h, float s, float v) {
        int rgb = UltraHolePortalRenderer.hsvToRGB(h, s, v);
        float r = (float)(rgb >> 16 & 0xFF) / 255.0f;
        float g = (float)(rgb >> 8 & 0xFF) / 255.0f;
        float b = (float)(rgb & 0xFF) / 255.0f;
        return new Vector3f(r, g, b);
    }

    private static int hsvToARGB(float h, float s, float v, int a) {
        int rgb = UltraHolePortalRenderer.hsvToRGB(h, s, v);
        return a << 24 | rgb;
    }

    private static int hsvToRGB(float h, float s, float v) {
        h = (h % 1.0f + 1.0f) % 1.0f;
        int i = (int)Math.floor(h * 6.0f);
        float f = h * 6.0f - (float)i;
        float p = v * (1.0f - s);
        float q = v * (1.0f - f * s);
        float t = v * (1.0f - (1.0f - f) * s);
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        switch (i % 6) {
            case 0: {
                r = v;
                g = t;
                b = p;
                break;
            }
            case 1: {
                r = q;
                g = v;
                b = p;
                break;
            }
            case 2: {
                r = p;
                g = v;
                b = t;
                break;
            }
            case 3: {
                r = p;
                g = q;
                b = v;
                break;
            }
            case 4: {
                r = t;
                g = p;
                b = v;
                break;
            }
            case 5: {
                r = v;
                g = p;
                b = q;
            }
        }
        int ri = (int)(r * 255.0f);
        int gi = (int)(g * 255.0f);
        int bi = (int)(b * 255.0f);
        return ri << 16 | gi << 8 | bi;
    }
}

