/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.khataly.modhm.command.custom;

import com.cobblemon.khataly.modhm.config.FlyTargetConfig;
import com.cobblemon.khataly.modhm.config.PlayerFlyProgress;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;

public class FlyTargetCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"flytarget").requires(source -> source.method_9259(2))).then(class_2170.method_9247((String)"list").executes(context -> {
            class_2168 source = (class_2168)context.getSource();
            Map<String, FlyTargetConfig.TargetInfo> targets = FlyTargetConfig.getAllTargets();
            if (targets.isEmpty()) {
                source.method_45068((class_2561)class_2561.method_43470((String)"\u00a7eNo fly targets registered."));
                return 1;
            }
            source.method_45068((class_2561)class_2561.method_43470((String)"\u00a76-- Registered Fly Targets --"));
            for (Map.Entry<String, FlyTargetConfig.TargetInfo> entry : targets.entrySet()) {
                String name = entry.getKey();
                class_2338 pos = entry.getValue().pos;
                source.method_45068((class_2561)class_2561.method_43470((String)("\u00a77" + name + " \u00a7f@ (" + pos.method_10263() + ", " + pos.method_10264() + ", " + pos.method_10260() + ")")));
            }
            return 1;
        }))).then(class_2170.method_9247((String)"create").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).executes(context -> {
            class_2168 source = (class_2168)context.getSource();
            class_3222 player = source.method_44023();
            String name = StringArgumentType.getString((CommandContext)context, (String)"name");
            assert (player != null);
            class_2338 pos = player.method_24515();
            boolean success = FlyTargetConfig.addTarget(name, (class_5321<class_1937>)player.method_51469().method_27983(), pos);
            if (success) {
                source.method_45068((class_2561)class_2561.method_43470((String)("\u00a7aFly target '" + name + "' created at position " + pos.method_10263() + ", " + pos.method_10264() + ", " + pos.method_10260())));
                return 1;
            }
            source.method_45068((class_2561)class_2561.method_43470((String)("\u00a7cFly target with name '" + name + "' already exists.")));
            return 0;
        })))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).suggests(FlyTargetCommand::suggestTargets).executes(context -> {
            class_2168 source = (class_2168)context.getSource();
            String name = StringArgumentType.getString((CommandContext)context, (String)"name");
            boolean removed = FlyTargetConfig.removeTarget(name);
            if (removed) {
                source.method_45068((class_2561)class_2561.method_43470((String)("\u00a7aFly target '" + name + "' removed.")));
                return 1;
            }
            source.method_45068((class_2561)class_2561.method_43470((String)("\u00a7cFly target '" + name + "' not found.")));
            return 0;
        })))).then(class_2170.method_9247((String)"unlock").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).suggests(FlyTargetCommand::suggestTargets).executes(context -> {
            class_2168 source = (class_2168)context.getSource();
            class_3222 targetPlayer = class_2186.method_9315((CommandContext)context, (String)"player");
            String name = StringArgumentType.getString((CommandContext)context, (String)"name");
            String keyLower = name.toLowerCase(Locale.ROOT);
            Map<String, FlyTargetConfig.TargetInfo> all = FlyTargetConfig.getAllTargets();
            if (!all.containsKey(keyLower)) {
                source.method_45068((class_2561)class_2561.method_43470((String)("\u00a7cFly target '" + name + "' does not exist.")));
                return 0;
            }
            boolean added = PlayerFlyProgress.unlock(targetPlayer.method_5667(), keyLower);
            if (added) {
                source.method_45068((class_2561)class_2561.method_43470((String)("\u00a7aUnlocked fly target '\u00a7e" + name + "\u00a7a' for \u00a7b" + targetPlayer.method_5477().getString() + "\u00a7a.")));
                targetPlayer.method_7353((class_2561)class_2561.method_43470((String)("\u00a77[Admin] \u00a7fNow you can fly to " + FlyTargetCommand.pretty(name))), false);
                return 1;
            }
            source.method_45068((class_2561)class_2561.method_43470((String)("\u00a7ePlayer already had fly target '\u00a7e" + name + "\u00a7e' unlocked.")));
            return 1;
        }))))).then(class_2170.method_9247((String)"clear").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> {
            class_2168 source = (class_2168)context.getSource();
            class_3222 targetPlayer = class_2186.method_9315((CommandContext)context, (String)"player");
            PlayerFlyProgress.clearAll(targetPlayer.method_5667());
            source.method_45068((class_2561)class_2561.method_43470((String)("\u00a7aCleared all unlocked fly targets for \u00a7b" + targetPlayer.method_5477().getString() + "\u00a7a.")));
            targetPlayer.method_7353((class_2561)class_2561.method_43470((String)"\u00a77[Admin] \u00a7fYour unlocked fly targets have been cleared."), false);
            return 1;
        })))).then(class_2170.method_9247((String)"reload").executes(context -> {
            class_2168 source = (class_2168)context.getSource();
            FlyTargetConfig.reload();
            source.method_45068((class_2561)class_2561.method_43470((String)"\u00a7aFly targets reloaded from file."));
            return 1;
        }))).then(class_2170.method_9247((String)"tp").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).suggests(FlyTargetCommand::suggestTargets).executes(context -> {
            class_2168 source = (class_2168)context.getSource();
            class_3222 player = source.method_44023();
            if (player == null) {
                source.method_45068((class_2561)class_2561.method_43470((String)"\u00a7cThis command must be executed by a player."));
                return 0;
            }
            String name = StringArgumentType.getString((CommandContext)context, (String)"name");
            return FlyTargetCommand.teleportToTarget(source, player, name);
        })).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> {
            class_2168 source = (class_2168)context.getSource();
            class_3222 targetPlayer = class_2186.method_9315((CommandContext)context, (String)"player");
            String name = StringArgumentType.getString((CommandContext)context, (String)"name");
            return FlyTargetCommand.teleportToTarget(source, targetPlayer, name);
        })))));
    }

    private static CompletableFuture<Suggestions> suggestTargets(CommandContext<class_2168> context, SuggestionsBuilder builder) {
        return class_2172.method_9265(FlyTargetConfig.getAllTargets().keySet(), (SuggestionsBuilder)builder);
    }

    private static String pretty(String name) {
        String[] parts = name.replace('_', ' ').split("\\s+");
        StringBuilder sb = new StringBuilder();
        for (String p : parts) {
            if (p.isEmpty()) continue;
            sb.append(Character.toUpperCase(p.charAt(0)));
            if (p.length() > 1) {
                sb.append(p.substring(1));
            }
            sb.append(' ');
        }
        return sb.toString().trim();
    }

    private static int teleportToTarget(class_2168 source, class_3222 player, String name) {
        String keyLower = name.toLowerCase(Locale.ROOT);
        Map<String, FlyTargetConfig.TargetInfo> all = FlyTargetConfig.getAllTargets();
        FlyTargetConfig.TargetInfo info = all.get(keyLower);
        if (info == null) {
            source.method_45068((class_2561)class_2561.method_43470((String)("\u00a7cFly target '" + name + "' doesn't exist.")));
            return 0;
        }
        MinecraftServer server = source.method_9211();
        class_3218 world = server.method_3847(info.worldKey);
        if (world == null) {
            source.method_45068((class_2561)class_2561.method_43470((String)("\u00a7Dimension for the target '" + name + "' non available.")));
            return 0;
        }
        class_2338 pos = info.pos;
        double x = (double)pos.method_10263() + 0.5;
        double y = pos.method_10264();
        double z = (double)pos.method_10260() + 0.5;
        float yaw = player.method_36454();
        float pitch = player.method_36455();
        player.method_14251(world, x, y, z, yaw, pitch);
        if (source.method_9228() != player) {
            source.method_45068((class_2561)class_2561.method_43470((String)("\u00a7aYou teleported \u00a7b" + player.method_5477().getString() + " \u00a7ato the target \u00a7e" + FlyTargetCommand.pretty(name) + "\u00a7a.")));
        }
        player.method_7353((class_2561)class_2561.method_43470((String)("\u00a77[FlyTarget] \u00a7fTeleported to \u00a7e" + FlyTargetCommand.pretty(name) + "\u00a7f...")), false);
        return 1;
    }
}

