/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.khataly.modhm.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class PlayerFlyProgress {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File ROOT = new File("config/modhm/player_flytargets");
    private static final int CURRENT_SCHEMA_VERSION = 1;
    private static final Map<UUID, Set<String>> cache = new HashMap<UUID, Set<String>>();

    public static Set<String> getUnlocked(UUID uuid) {
        PlayerFlyProgress.ensureLoaded(uuid);
        return Collections.unmodifiableSet(cache.getOrDefault(uuid, Collections.emptySet()));
    }

    public static boolean isUnlocked(UUID uuid, String keyLower) {
        PlayerFlyProgress.ensureLoaded(uuid);
        return cache.getOrDefault(uuid, Collections.emptySet()).contains(keyLower);
    }

    public static boolean unlock(UUID uuid, String keyLower) {
        PlayerFlyProgress.ensureLoaded(uuid);
        Set set = cache.computeIfAbsent(uuid, u -> new HashSet());
        boolean added = set.add(keyLower);
        if (added) {
            PlayerFlyProgress.save(uuid);
        }
        return added;
    }

    public static void clearAll(UUID uuid) {
        cache.put(uuid, new HashSet());
        PlayerFlyProgress.save(uuid);
    }

    public static void unlockAll(UUID uuid, Collection<String> keysLower) {
        PlayerFlyProgress.ensureLoaded(uuid);
        if (keysLower == null || keysLower.isEmpty()) {
            return;
        }
        Set set = cache.computeIfAbsent(uuid, u -> new HashSet());
        if (set.addAll(keysLower)) {
            PlayerFlyProgress.save(uuid);
        }
    }

    private static void ensureLoaded(UUID uuid) {
        if (cache.containsKey(uuid)) {
            return;
        }
        cache.put(uuid, new HashSet());
        PlayerFlyProgress.load(uuid);
    }

    private static File fileFor(UUID uuid) {
        return new File(ROOT, uuid.toString() + ".json");
    }

    private static void load(UUID uuid) {
        try {
            File f;
            File dir = ROOT;
            if (!dir.exists() && !dir.mkdirs()) {
                PlayerFlyProgress.logWarn("Impossibile creare cartella progressi: " + dir.getAbsolutePath());
            }
            if (!(f = PlayerFlyProgress.fileFor(uuid)).exists()) {
                cache.put(uuid, new HashSet());
                return;
            }
            try (FileReader r = new FileReader(f);){
                Data d = (Data)GSON.fromJson((Reader)r, Data.class);
                if (d == null || d.unlocked == null) {
                    cache.put(uuid, new HashSet());
                } else {
                    HashSet<String> s = new HashSet<String>();
                    for (String k : d.unlocked) {
                        if (k == null) continue;
                        s.add(k.toLowerCase(Locale.ROOT));
                    }
                    cache.put(uuid, s);
                }
            }
        }
        catch (Exception e) {
            PlayerFlyProgress.logError("Errore nel caricamento progressi per " + String.valueOf(uuid), e);
            cache.put(uuid, new HashSet());
        }
    }

    private static void save(UUID uuid) {
        try {
            File dir = ROOT;
            if (!dir.exists() && !dir.mkdirs()) {
                PlayerFlyProgress.logWarn("Impossibile creare cartella progressi: " + dir.getAbsolutePath());
            }
            File f = PlayerFlyProgress.fileFor(uuid);
            Data d = new Data();
            d.schemaVersion = 1;
            d.unlocked = new ArrayList<String>(cache.getOrDefault(uuid, Collections.emptySet()));
            File temp = new File(f.getParentFile(), f.getName() + ".tmp");
            try (FileWriter w = new FileWriter(temp);){
                GSON.toJson((Object)d, (Appendable)w);
            }
            try {
                Files.move(temp.toPath(), f.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
            }
            catch (IOException atomicNotSupported) {
                Files.move(temp.toPath(), f.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (Exception e) {
            PlayerFlyProgress.logError("Errore nel salvataggio progressi per " + String.valueOf(uuid), e);
        }
    }

    private static void logWarn(String msg) {
        System.out.println("[PlayerFlyProgress][WARN] " + msg);
    }

    private static void logError(String msg, Throwable t) {
        System.err.println("[PlayerFlyProgress][ERROR] " + msg);
        if (t != null) {
            StringWriter sw = new StringWriter();
            t.printStackTrace(new PrintWriter(sw));
            System.err.println(sw.toString());
        }
    }

    private static class Data {
        Integer schemaVersion;
        List<String> unlocked = new ArrayList<String>();

        private Data() {
        }
    }
}

