/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.khataly.modhm.item.custom;

import com.cobblemon.khataly.modhm.networking.handlers.BadgeBoxHandler;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6885;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9279;
import net.minecraft.class_9331;
import net.minecraft.class_9334;

public class BadgeCaseItem
extends class_1792 {
    public static final class_6862<class_1792> BADGE_TAG = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60655((String)"modhm", (String)"badges"));
    public static final int MAX_SLOTS = 8;
    private static final String NBT_BADGES = "Badges";
    private static final String KEY_ID = "id";
    private static final String KEY_SH = "shine";
    private static final String KEY_LAST = "last";
    private static final long FULL_DECAY_MS = 1200000L;
    private static final float DECAY_PER_SEC = 0.083333336f;

    public BadgeCaseItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 caseStack = user.method_5998(hand);
        if (!world.field_9236 && user instanceof class_3222) {
            class_3222 sp = (class_3222)user;
            List<BadgeData> data = BadgeCaseItem.readBadgesDataAndDecay(caseStack);
            int total = BadgeCaseItem.totalCountOrDefault(data.size());
            BadgeBoxHandler.sendOpen(sp, hand, data, total, Optional.empty());
        }
        return class_1271.method_29237((Object)caseStack, (boolean)world.field_9236);
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        List<BadgeData> data = BadgeCaseItem.readBadgesDataAndDecay(stack);
        int total = 8;
        long collected = data.stream().filter(d -> d.id() != null).count();
        tooltip.add((class_2561)class_2561.method_43469((String)"tooltip.modhm.badge_case.count", (Object[])new Object[]{collected, total}));
        if (type == class_1836.field_41071) {
            for (BadgeData d2 : data) {
                if (d2.id() == null) continue;
                class_1792 item = (class_1792)class_7923.field_41178.method_10223(d2.id());
                class_5250 name = new class_1799((class_1935)item).method_7964().method_27661();
                tooltip.add((class_2561)class_2561.method_43470((String)"\u2022 ").method_10852((class_2561)name).method_10852((class_2561)class_2561.method_43470((String)("  (" + d2.shine() + "%)"))));
            }
        } else {
            tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.modhm.badge_case.hint"));
        }
    }

    public static boolean isFull(class_1799 caseStack) {
        int count = 0;
        for (BadgeData b : BadgeCaseItem.readBadgesData(caseStack)) {
            if (b.id() != null) {
                ++count;
            }
            if (count < 8) continue;
            return true;
        }
        return false;
    }

    public static boolean addBadge(class_1799 caseStack, class_2960 id) {
        if (BadgeCaseItem.isFull(caseStack)) {
            return false;
        }
        long now = System.currentTimeMillis();
        List<BadgeData> data = BadgeCaseItem.readBadgesDataAndDecay(caseStack);
        boolean already = data.stream().anyMatch(b -> id.equals((Object)b.id()));
        if (already) {
            return false;
        }
        data.add(new BadgeData(id, 0, now));
        BadgeCaseItem.writeBadgesData(caseStack, data);
        return true;
    }

    public static boolean polish(class_1799 caseStack, class_2960 id, int amount) {
        long now = System.currentTimeMillis();
        List<BadgeData> data = BadgeCaseItem.readBadgesDataAndDecay(caseStack);
        boolean changed = false;
        for (int i = 0; i < data.size(); ++i) {
            BadgeData b = data.get(i);
            if (!id.equals((Object)b.id())) continue;
            int newSh = Math.min(100, Math.max(0, b.shine() + amount));
            if (newSh != b.shine()) {
                changed = true;
            }
            data.set(i, new BadgeData(b.id(), newSh, now));
            break;
        }
        if (changed) {
            BadgeCaseItem.writeBadgesData(caseStack, data);
        }
        return changed;
    }

    public static boolean remove(class_1799 caseStack, class_2960 id) {
        List<BadgeData> data = BadgeCaseItem.readBadgesDataAndDecay(caseStack);
        boolean removed = data.removeIf(b -> id.equals((Object)b.id()));
        if (removed) {
            BadgeCaseItem.writeBadgesData(caseStack, data);
        }
        return removed;
    }

    public static List<BadgeData> readBadgesDataAndDecay(class_1799 stack) {
        List<BadgeData> list = BadgeCaseItem.readBadgesDataRaw(stack);
        long now = System.currentTimeMillis();
        boolean changed = false;
        ArrayList<BadgeData> out = new ArrayList<BadgeData>(list.size());
        for (BadgeData b : list) {
            if (b.id() == null || b.shine() <= 0) {
                out.add(b);
                continue;
            }
            long elapsedMs = Math.max(0L, now - Math.max(0L, b.last()));
            if (elapsedMs <= 0L) {
                out.add(b);
                continue;
            }
            int drop = Math.max(0, Math.round((float)elapsedMs / 1000.0f * 0.083333336f));
            int newSh = Math.max(0, b.shine() - drop);
            if (newSh != b.shine()) {
                changed = true;
            }
            out.add(new BadgeData(b.id(), newSh, now));
        }
        if (changed) {
            BadgeCaseItem.writeBadgesData(stack, out);
        }
        return out;
    }

    public static List<BadgeData> readBadgesData(class_1799 stack) {
        return new ArrayList<BadgeData>(BadgeCaseItem.readBadgesDataRaw(stack));
    }

    public static Set<class_2960> readBadges(class_1799 stack) {
        LinkedHashSet<class_2960> out = new LinkedHashSet<class_2960>();
        for (BadgeData b : BadgeCaseItem.readBadgesDataRaw(stack)) {
            if (b.id() == null) continue;
            out.add(b.id());
        }
        return out;
    }

    public static int totalCountOrDefault(int fallback) {
        return class_7923.field_41178.method_40266(BADGE_TAG).map(class_6885::method_40247).orElse(fallback);
    }

    private static List<BadgeData> readBadgesDataRaw(class_1799 stack) {
        class_2487 tag = BadgeCaseItem.readCustomTag(stack);
        ArrayList<BadgeData> out = new ArrayList<BadgeData>();
        if (!tag.method_10573(NBT_BADGES, 9)) {
            return out;
        }
        class_2499 list = tag.method_10554(NBT_BADGES, 10);
        if (list.isEmpty() || list.method_10601() == 8) {
            long now = System.currentTimeMillis();
            class_2499 newList = new class_2499();
            for (int i = 0; i < list.size(); ++i) {
                class_2960 id = class_2960.method_12829((String)list.method_10608(i));
                if (id == null) continue;
                out.add(new BadgeData(id, 0, now));
                class_2487 c = new class_2487();
                c.method_10582(KEY_ID, id.toString());
                c.method_10569(KEY_SH, 0);
                c.method_10544(KEY_LAST, now);
                newList.add((Object)c);
            }
            tag.method_10566(NBT_BADGES, (class_2520)newList);
            BadgeCaseItem.writeCustomTag(stack, tag);
            return out;
        }
        for (int i = 0; i < list.size(); ++i) {
            long ls;
            class_2487 c = list.method_10602(i);
            class_2960 id = c.method_10545(KEY_ID) ? class_2960.method_12829((String)c.method_10558(KEY_ID)) : null;
            int sh = c.method_10545(KEY_SH) ? Math.max(0, Math.min(100, c.method_10550(KEY_SH))) : 0;
            long l = ls = c.method_10545(KEY_LAST) ? c.method_10537(KEY_LAST) : System.currentTimeMillis();
            if (id == null) continue;
            out.add(new BadgeData(id, sh, ls));
        }
        return out;
    }

    public static void writeBadgesData(class_1799 stack, List<BadgeData> data) {
        class_2487 tag = BadgeCaseItem.readCustomTag(stack);
        class_2499 list = new class_2499();
        for (BadgeData b : data) {
            if (b.id() == null) continue;
            class_2487 c = new class_2487();
            c.method_10582(KEY_ID, b.id().toString());
            c.method_10569(KEY_SH, Math.max(0, Math.min(100, b.shine())));
            c.method_10544(KEY_LAST, b.last());
            list.add((Object)c);
        }
        tag.method_10566(NBT_BADGES, (class_2520)list);
        BadgeCaseItem.writeCustomTag(stack, tag);
    }

    private static class_2487 readCustomTag(class_1799 stack) {
        class_9279 comp = (class_9279)stack.method_57825(class_9334.field_49628, (Object)class_9279.field_49302);
        return comp.method_57461();
    }

    private static void writeCustomTag(class_1799 stack, class_2487 newTag) {
        class_9279.method_57452((class_9331)class_9334.field_49628, (class_1799)stack, tag -> tag.method_10543(newTag));
    }

    public record BadgeData(class_2960 id, int shine, long last) {
    }
}

