/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.khataly.modhm.networking.handlers;

import com.cobblemon.khataly.modhm.item.custom.BadgeCaseItem;
import com.cobblemon.khataly.modhm.networking.packet.badgebox.BadgeEntry;
import com.cobblemon.khataly.modhm.networking.packet.badgebox.EjectBadgeC2SPacket;
import com.cobblemon.khataly.modhm.networking.packet.badgebox.OpenBadgeBoxS2CPacket;
import com.cobblemon.khataly.modhm.networking.packet.badgebox.PolishBadgeC2SPacket;
import com.cobblemon.khataly.modhm.networking.packet.badgebox.SyncBadgeBoxS2CPacket;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1268;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_6885;
import net.minecraft.class_7923;
import net.minecraft.class_8710;

public final class BadgeBoxHandler {
    private BadgeBoxHandler() {
    }

    public static void register() {
        ServerPlayNetworking.registerGlobalReceiver(PolishBadgeC2SPacket.ID, (payload, ctx) -> ctx.server().execute(() -> BadgeBoxHandler.handlePolish(ctx.player(), payload.badgeId(), payload.amount())));
        ServerPlayNetworking.registerGlobalReceiver(EjectBadgeC2SPacket.ID, (payload, ctx) -> ctx.server().execute(() -> BadgeBoxHandler.handleEject(ctx.player(), payload.badgeId())));
    }

    public static void sendOpen(class_3222 sp, class_1268 hand, List<BadgeCaseItem.BadgeData> data, int total, Optional<class_2960> animInserted) {
        List<BadgeEntry> entries = BadgeBoxHandler.toEntries(data);
        ServerPlayNetworking.send((class_3222)sp, (class_8710)new OpenBadgeBoxS2CPacket(hand, total, entries, animInserted));
    }

    public static void sendSync(class_3222 sp, List<BadgeCaseItem.BadgeData> data, int total) {
        List<BadgeEntry> entries = BadgeBoxHandler.toEntries(data);
        ServerPlayNetworking.send((class_3222)sp, (class_8710)new SyncBadgeBoxS2CPacket(total, entries));
    }

    private static List<BadgeEntry> toEntries(List<BadgeCaseItem.BadgeData> data) {
        ArrayList<BadgeEntry> list = new ArrayList<BadgeEntry>(data.size());
        for (BadgeCaseItem.BadgeData d : data) {
            list.add(new BadgeEntry(d.id(), d.shine()));
        }
        return list;
    }

    private static void handlePolish(class_3222 sp, class_2960 badgeId, int amount) {
        class_1799 caseStack = BadgeBoxHandler.findCaseStack(sp);
        if (caseStack.method_7960() || !(caseStack.method_7909() instanceof BadgeCaseItem)) {
            return;
        }
        boolean changed = BadgeCaseItem.polish(caseStack, badgeId, Math.max(1, Math.min(10, amount)));
        if (!changed) {
            return;
        }
        sp.method_5783(class_3417.field_43155, 0.6f, 1.15f);
        List<BadgeCaseItem.BadgeData> data = BadgeCaseItem.readBadgesDataAndDecay(caseStack);
        int total = BadgeBoxHandler.totalCount();
        BadgeBoxHandler.sendSync(sp, data, total);
    }

    private static void handleEject(class_3222 sp, class_2960 badgeId) {
        class_1799 caseStack = BadgeBoxHandler.findCaseStack(sp);
        if (caseStack.method_7960() || !(caseStack.method_7909() instanceof BadgeCaseItem)) {
            return;
        }
        boolean removed = BadgeCaseItem.remove(caseStack, badgeId);
        if (!removed) {
            return;
        }
        class_1792 it = (class_1792)class_7923.field_41178.method_10223(badgeId);
        sp.method_31548().method_7394(new class_1799((class_1935)it));
        sp.method_5783(class_3417.field_34377, 1.0f, 1.0f);
        List<BadgeCaseItem.BadgeData> data = BadgeCaseItem.readBadgesDataAndDecay(caseStack);
        int total = BadgeBoxHandler.totalCount();
        BadgeBoxHandler.sendSync(sp, data, total);
    }

    private static int totalCount() {
        return class_7923.field_41178.method_40266(BadgeCaseItem.BADGE_TAG).map(class_6885::method_40247).orElse(8);
    }

    private static class_1799 findCaseStack(class_3222 sp) {
        class_1799 main = sp.method_6047();
        if (main.method_7909() instanceof BadgeCaseItem) {
            return main;
        }
        class_1799 off = sp.method_6079();
        if (off.method_7909() instanceof BadgeCaseItem) {
            return off;
        }
        for (int i = 0; i < sp.method_31548().method_5439(); ++i) {
            class_1799 s = sp.method_31548().method_5438(i);
            if (s.method_7960() || !(s.method_7909() instanceof BadgeCaseItem)) continue;
            return s;
        }
        return class_1799.field_8037;
    }
}

