/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.khataly.modhm.networking.handlers;

import com.cobblemon.khataly.modhm.config.ModConfig;
import com.cobblemon.khataly.modhm.networking.manager.RestoreManager;
import com.cobblemon.khataly.modhm.networking.packet.RockSmashPacketC2S;
import com.cobblemon.khataly.modhm.networking.util.NetUtil;
import com.cobblemon.khataly.modhm.sound.ModSounds;
import com.cobblemon.mod.common.CobblemonEntities;
import com.cobblemon.mod.common.api.moves.Moves;
import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.battles.BattleBuilder;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.Species;
import java.util.Objects;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RockSmashHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"RockSmashHandler");
    private static final float ENCOUNTER_CHANCE = 0.25f;

    private RockSmashHandler() {
    }

    public static void register() {
        ServerPlayNetworking.registerGlobalReceiver(RockSmashPacketC2S.ID, (payload, ctx) -> {
            class_3222 p = ctx.player();
            ctx.server().execute(() -> {
                class_2338 pos = payload.pos();
                if (!NetUtil.requireMove(p, "rocksmash", "\u274c No Pok\u00e9mon in your party knows Rock Smash!")) {
                    return;
                }
                if (!NetUtil.requireItem(p, ModConfig.ROCKSMASH.item, ModConfig.ROCKSMASH.message)) {
                    return;
                }
                class_2680 original = p.method_37908().method_8320(pos);
                if (original.method_26215()) {
                    NetUtil.msg(p, "\u26a0\ufe0f There's nothing to break here!");
                    return;
                }
                if (RestoreManager.get().isBusy(pos)) {
                    NetUtil.msg(p, "\u23f3 The block has already been smashed, wait for it to return!");
                    return;
                }
                NetUtil.msg(p, "\ud83d\udca5 you used Rock Smash!");
                NetUtil.playPlayerSound(p, ModSounds.BREAKABLE_ROCK);
                p.method_37908().method_8501(pos, class_2246.field_10124.method_9564());
                RestoreManager.get().addTimed(pos, original, ModConfig.ROCKSMASH_RESPAWN);
                NetUtil.sendParticles(p, (class_2394)class_2398.field_11204, pos, 0.3f, 0.3f, 0.3f, 0.1f, 20);
                LOGGER.info("Block Rock removed at {}, restore timer started", (Object)pos);
                if (p.method_37908().field_9229.method_43057() < 0.25f) {
                    RockSmashHandler.spawnWildPokemonAttack(p);
                } else {
                    NetUtil.sendAnimation(p, "rocksmash");
                }
            });
        });
    }

    private static void spawnWildPokemonAttack(class_3222 player) {
        Species species = PokemonSpecies.INSTANCE.getByName("geodude");
        if (species == null) {
            LOGGER.warn("Pokemon spec not found!");
            return;
        }
        Pokemon pokemon = new Pokemon();
        pokemon.setSpecies(species);
        pokemon.setLevel(10);
        pokemon.getMoveSet().setMove(2, Objects.requireNonNull(Moves.INSTANCE.getByName("rockthrow")).create());
        pokemon.getMoveSet().setMove(3, Objects.requireNonNull(Moves.INSTANCE.getByName("rockthrow")).create());
        pokemon.getMoveSet().setMove(1, Objects.requireNonNull(Moves.INSTANCE.getByName("selfdestruct")).create());
        PokemonEntity pokemonEntity = new PokemonEntity(player.method_37908(), pokemon, CobblemonEntities.POKEMON);
        pokemonEntity.setPokemon(pokemon);
        class_2338 spawnPos = player.method_24515().method_10069(1, 0, 0);
        pokemonEntity.method_5725(spawnPos, 0.0f, 0.0f);
        player.method_37908().method_8649((class_1297)pokemonEntity);
        BattleBuilder.INSTANCE.pve(player, pokemonEntity);
    }
}

