/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.khataly.modhm.networking.handlers;

import com.cobblemon.khataly.modhm.block.ModBlocks;
import com.cobblemon.khataly.modhm.block.entity.custom.UltraHolePortalEntity;
import com.cobblemon.khataly.modhm.config.ModConfig;
import com.cobblemon.khataly.modhm.networking.packet.UltraHolePacketC2S;
import com.cobblemon.khataly.modhm.networking.util.NetUtil;
import com.cobblemon.khataly.modhm.util.PlayerUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_3222;

public final class UltraHoleHandler {
    private static final Map<UUID, class_2338> activePortals = new HashMap<UUID, class_2338>();

    private UltraHoleHandler() {
    }

    public static void register() {
        ServerPlayNetworking.registerGlobalReceiver(UltraHolePacketC2S.ID, (payload, ctx) -> {
            class_3222 p = ctx.player();
            ctx.server().execute(() -> {
                List<String> requiredMoves = List.of("sunsteelstrike", "moongeistbeam");
                Optional<String> known = requiredMoves.stream().filter(m -> PlayerUtils.hasMove(p, m)).findFirst();
                if (known.isEmpty()) {
                    NetUtil.msg(p, "\u274c None of your Pok\u00e9mon know the moves required to open an UltraHole!");
                    return;
                }
                if (!NetUtil.requireItem(p, ModConfig.ULTRAHOLE.item, ModConfig.ULTRAHOLE.message)) {
                    return;
                }
                if (activePortals.containsKey(p.method_5667())) {
                    NetUtil.msg(p, "\u26a0\ufe0f You already have an active UltraHole portal!");
                    return;
                }
                NetUtil.sendAnimation(p, known.get());
                class_2338 portalPos = p.method_24515().method_10079(p.method_5735(), 5).method_10086(1);
                p.method_37908().method_8501(portalPos, ModBlocks.ULTRAHOLE_PORTAL.method_9564());
                class_2586 be = p.method_37908().method_8321(portalPos);
                if (be instanceof UltraHolePortalEntity) {
                    String targetDim;
                    UltraHolePortalEntity portal = (UltraHolePortalEntity)be;
                    String currentDim = p.method_37908().method_27983().method_29177().toString();
                    if (currentDim.equals(targetDim = ModConfig.ULTRAHOLE_SETTINGS.destinationDimension)) {
                        class_2338 spawn = Objects.requireNonNull(p.method_5682()).method_30002().method_43126();
                        portal.setTarget("minecraft:overworld", (double)spawn.method_10263() + 0.5, spawn.method_10264(), (double)spawn.method_10260() + 0.5);
                    } else {
                        portal.setTarget(targetDim, ModConfig.ULTRAHOLE_SETTINGS.x, ModConfig.ULTRAHOLE_SETTINGS.y, ModConfig.ULTRAHOLE_SETTINGS.z);
                    }
                    portal.setOnRemove(() -> activePortals.remove(p.method_5667()));
                    activePortals.put(p.method_5667(), portalPos);
                }
            });
        });
    }
}

