/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.khataly.modhm.networking.manager;

import com.cobblemon.khataly.modhm.block.ModBlocks;
import com.cobblemon.khataly.modhm.block.custom.ClimbableRock;
import com.cobblemon.khataly.modhm.networking.util.NetUtil;
import com.cobblemon.khataly.modhm.sound.ModSounds;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;

public final class ClimbManager {
    private static final ClimbManager INSTANCE = new ClimbManager();
    private final Map<class_3222, class_2338> playersClimbing = new ConcurrentHashMap<class_3222, class_2338>();
    private final Map<class_3222, Integer> climbingTicks = new ConcurrentHashMap<class_3222, Integer>();
    private final Map<class_3222, Set<class_2338>> visitedClimbBlocks = new ConcurrentHashMap<class_3222, Set<class_2338>>();
    private final Map<class_3222, class_2338> climbingTargets = new ConcurrentHashMap<class_3222, class_2338>();
    private final Set<class_3222> playersPlayingSound = ConcurrentHashMap.newKeySet();
    private final Map<class_3222, GlideState> forwardGlide = new ConcurrentHashMap<class_3222, GlideState>();
    private final Map<class_3222, Integer> fallImmunityTicks = new ConcurrentHashMap<class_3222, Integer>();
    private static final double CLIMB_SPEED = 0.15;
    private static final double REACH_EPSILON = 0.2;
    private static final int SOUND_TICK_DELAY = 4;
    private static final int FALL_IMMUNITY_GRACE_TICKS = 10;
    private static final double GLIDE_SPEED = 0.12;
    private static final int GLIDE_MAX_TICKS = 10;
    private static final double GLIDE_SNAP_EPS = 0.06;

    public static ClimbManager get() {
        return INSTANCE;
    }

    private ClimbManager() {
    }

    public void start(class_3222 player, class_2338 startPos) {
        this.playersClimbing.put(player, startPos);
        this.climbingTicks.put(player, 0);
        player.field_6017 = 0.0f;
    }

    public void tick() {
        this.playersClimbing.forEach((player, startPos) -> {
            double dz;
            double dy;
            double dx;
            double distance;
            if (!player.method_5805()) {
                this.cleanup((class_3222)player);
                return;
            }
            player.field_6017 = 0.0f;
            this.climbingTicks.put((class_3222)player, this.climbingTicks.getOrDefault(player, 0) + 1);
            this.visitedClimbBlocks.putIfAbsent((class_3222)player, new HashSet());
            Set<class_2338> visited = this.visitedClimbBlocks.get(player);
            visited.add((class_2338)startPos);
            class_2338 target = this.climbingTargets.get(player);
            if (target == null) {
                target = this.findNextClimbStep((class_3218)player.method_37908(), (class_2338)startPos, visited);
                if (target == null) {
                    NetUtil.msg(player, "\ud83e\uddd7 No climbable blocks!");
                    this.grantFallImmunity((class_3222)player);
                    this.cleanup((class_3222)player);
                    return;
                }
                this.climbingTargets.put((class_3222)player, target);
                visited.add(target);
            }
            if ((distance = Math.sqrt((dx = (double)target.method_10263() + 0.5 - player.method_23317()) * dx + (dy = (double)target.method_10264() + 1.0 - player.method_23318()) * dy + (dz = (double)target.method_10260() + 0.5 - player.method_23321()) * dz)) < 0.2) {
                class_2338 next = this.findNextClimbStep((class_3218)player.method_37908(), target, visited);
                if (next == null) {
                    player.field_6017 = 0.0f;
                    this.grantFallImmunity((class_3222)player);
                    if (dy > 0.0) {
                        class_2350 forwardDir = this.getForwardDirectionAwayFromWall((class_3218)player.method_37908(), target, (class_3222)player);
                        class_2338 destBlock = target.method_10084().method_10093(forwardDir);
                        double destX = (double)destBlock.method_10263() + 0.5;
                        double destY = destBlock.method_10264();
                        double destZ = (double)destBlock.method_10260() + 0.5;
                        this.forwardGlide.put((class_3222)player, new GlideState(destX, destY, destZ, 10));
                        player.method_18800(0.0, 0.08, 0.0);
                        player.field_6037 = true;
                        NetUtil.msg(player, "\ud83e\uddd7 You climbed up!");
                    } else {
                        player.method_18800(0.0, -0.08, 0.0);
                        player.field_6037 = true;
                        NetUtil.msg(player, "\ud83e\uddd7 You climbed down!");
                    }
                    this.cleanup((class_3222)player);
                    return;
                }
                this.climbingTargets.put((class_3222)player, next);
                visited.add(next);
                return;
            }
            player.method_18800(dx / distance * 0.15, dy / distance * 0.15, dz / distance * 0.15);
            player.field_6037 = true;
            if (this.climbingTicks.get(player) >= 4 && !this.playersPlayingSound.contains(player)) {
                player.method_17356(ModSounds.CLIMBABLE_ROCK, class_3419.field_15248, 1.0f, 1.0f);
                this.playersPlayingSound.add((class_3222)player);
            }
        });
        Iterator<Map.Entry<class_3222, GlideState>> itGlide = this.forwardGlide.entrySet().iterator();
        while (itGlide.hasNext()) {
            double dz;
            double dy;
            Map.Entry<class_3222, GlideState> e = itGlide.next();
            class_3222 player2 = e.getKey();
            GlideState g = e.getValue();
            if (!player2.method_5805()) {
                itGlide.remove();
                continue;
            }
            player2.field_6017 = 0.0f;
            double dx = g.destX - player2.method_23317();
            double dist = Math.sqrt(dx * dx + (dy = g.destY - player2.method_23318()) * dy + (dz = g.destZ - player2.method_23321()) * dz);
            if (dist < 0.06 || g.ticksLeft <= 0) {
                player2.method_14251((class_3218)player2.method_37908(), g.destX, g.destY, g.destZ, player2.method_36454(), player2.method_36455());
                player2.method_18800(0.0, 0.0, 0.0);
                player2.field_6037 = true;
                itGlide.remove();
                continue;
            }
            double vx = dx / dist * 0.12;
            double vy = dy / dist * 0.12;
            double vz = dz / dist * 0.12;
            player2.method_18800(vx, vy, vz);
            player2.field_6037 = true;
            --g.ticksLeft;
        }
        Iterator<Map.Entry<class_3222, Integer>> it = this.fallImmunityTicks.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<class_3222, Integer> e = it.next();
            class_3222 player3 = e.getKey();
            int ticksLeft = e.getValue();
            player3.field_6017 = 0.0f;
            int next = ticksLeft - 1;
            if (next <= 0) {
                it.remove();
                continue;
            }
            e.setValue(next);
        }
    }

    private class_2350 getForwardDirectionAwayFromWall(class_3218 world, class_2338 target, class_3222 player) {
        class_2680 targetState = world.method_8320(target);
        if (targetState.method_27852(ModBlocks.CLIMBABLE_ROCK)) {
            return ((class_2350)targetState.method_11654((class_2769)ClimbableRock.FACING)).method_10153();
        }
        return player.method_5735();
    }

    private void cleanup(class_3222 player) {
        this.playersClimbing.remove(player);
        this.climbingTicks.remove(player);
        this.playersPlayingSound.remove(player);
        this.climbingTargets.remove(player);
        this.visitedClimbBlocks.remove(player);
        player.field_6017 = 0.0f;
    }

    private void grantFallImmunity(class_3222 player) {
        this.fallImmunityTicks.merge(player, 10, Math::max);
    }

    private class_2338 findNextClimbStep(class_3218 world, class_2338 from, Set<class_2338> visited) {
        class_2350[] horizontals;
        class_2338 down;
        class_2680 state = world.method_8320(from);
        class_2338 up = from.method_10084();
        if (!visited.contains(up) && state.method_27852(ModBlocks.CLIMBABLE_ROCK) && world.method_8320(up).method_27852(ModBlocks.CLIMBABLE_ROCK)) {
            return up;
        }
        if (state.method_27852(ModBlocks.CLIMBABLE_ROCK)) {
            class_2350 facing = (class_2350)state.method_11654((class_2769)ClimbableRock.FACING);
            class_2338 upForward = up.method_10093(facing);
            if (!visited.contains(upForward) && world.method_8320(upForward).method_27852(ModBlocks.CLIMBABLE_ROCK)) {
                return upForward;
            }
            class_2338 upBackward = up.method_10093(facing.method_10153());
            if (!visited.contains(upBackward) && world.method_8320(upBackward).method_27852(ModBlocks.CLIMBABLE_ROCK)) {
                return upBackward;
            }
        }
        if (!visited.contains(down = from.method_10074()) && world.method_8320(down).method_27852(ModBlocks.CLIMBABLE_ROCK)) {
            return down;
        }
        if (state.method_27852(ModBlocks.CLIMBABLE_ROCK)) {
            class_2350 facing = (class_2350)state.method_11654((class_2769)ClimbableRock.FACING);
            class_2338 downForward = down.method_10093(facing);
            if (!visited.contains(downForward) && world.method_8320(downForward).method_27852(ModBlocks.CLIMBABLE_ROCK)) {
                return downForward;
            }
            class_2338 downBackward = down.method_10093(facing.method_10153());
            if (!visited.contains(downBackward) && world.method_8320(downBackward).method_27852(ModBlocks.CLIMBABLE_ROCK)) {
                return downBackward;
            }
        }
        for (class_2350 dir : horizontals = new class_2350[]{class_2350.field_11043, class_2350.field_11035, class_2350.field_11034, class_2350.field_11039}) {
            class_2338 n = from.method_10093(dir);
            if (visited.contains(n) || !world.method_8320(n).method_27852(ModBlocks.CLIMBABLE_ROCK)) continue;
            return n;
        }
        return null;
    }

    private static final class GlideState {
        final double destX;
        final double destY;
        final double destZ;
        int ticksLeft;

        GlideState(double x, double y, double z, int ticks) {
            this.destX = x;
            this.destY = y;
            this.destZ = z;
            this.ticksLeft = ticks;
        }
    }
}

