/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.khataly.mapkit;

import com.cobblemon.khataly.mapkit.block.ModBlocks;
import com.cobblemon.khataly.mapkit.block.entity.ModBlockEntities;
import com.cobblemon.khataly.mapkit.block.renderer.UltraHolePortalRenderer;
import com.cobblemon.khataly.mapkit.entity.BicycleEntity;
import com.cobblemon.khataly.mapkit.entity.ModEntities;
import com.cobblemon.khataly.mapkit.entity.model.BicycleEntityModel;
import com.cobblemon.khataly.mapkit.entity.model.ModModelLayers;
import com.cobblemon.khataly.mapkit.entity.render.BicycleRenderer;
import com.cobblemon.khataly.mapkit.entity.render.ModEntityRenderers;
import com.cobblemon.khataly.mapkit.event.client.ClientEventHandler;
import com.cobblemon.khataly.mapkit.item.ModItems;
import com.cobblemon.khataly.mapkit.networking.handlers.BadgeBoxClientHandler;
import com.cobblemon.khataly.mapkit.networking.packet.RotatePlayerS2CPacket;
import com.cobblemon.khataly.mapkit.networking.packet.bike.BikeWheelieC2SPacket;
import com.cobblemon.khataly.mapkit.networking.packet.bike.ToggleBikeGearC2SPacket;
import com.cobblemon.khataly.mapkit.networking.util.ClientAnimationState;
import com.cobblemon.khataly.mapkit.networking.util.GrassNetworkingInit;
import com.cobblemon.khataly.mapkit.screen.ModScreenHandlers;
import com.cobblemon.khataly.mapkit.screen.custom.CutScreen;
import com.cobblemon.khataly.mapkit.screen.custom.RockClimbScreen;
import com.cobblemon.khataly.mapkit.screen.custom.RockSmashScreen;
import com.cobblemon.khataly.mapkit.screen.custom.StrengthScreen;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.rendering.v1.ArmorRenderer;
import net.fabricmc.fabric.api.client.rendering.v1.EntityModelLayerRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.minecraft.class_1921;
import net.minecraft.class_1935;
import net.minecraft.class_3929;
import net.minecraft.class_5601;
import net.minecraft.class_5616;
import net.minecraft.class_746;
import net.minecraft.class_8710;

public class CobblemonMapKitModClient
implements ClientModInitializer {
    private boolean wasUsePressed = false;
    private boolean wasJumpPressed = false;

    public void onInitializeClient() {
        this.registerScreensAndBlocks();
        this.registerRenderers();
        this.registerClientReceivers();
        this.registerClientEvents();
        this.registerBicycleInputHandlers();
    }

    private void registerScreensAndBlocks() {
        class_3929.method_17542(ModScreenHandlers.ROCK_SMASH_SCREEN_HANDLER, RockSmashScreen::new);
        class_3929.method_17542(ModScreenHandlers.CUT_SCREEN_HANDLER, CutScreen::new);
        class_3929.method_17542(ModScreenHandlers.STRENGHT_SCREEN_HANDLER, StrengthScreen::new);
        class_3929.method_17542(ModScreenHandlers.ROCKCLIMB_SCREEN_HANDLER, RockClimbScreen::new);
        BlockRenderLayerMap.INSTANCE.putBlock(ModBlocks.CLIMBABLE_ROCK, class_1921.method_23581());
        BlockRenderLayerMap.INSTANCE.putBlock(ModBlocks.ULTRAHOLE_PORTAL, class_1921.method_23581());
        class_5616.method_32144(ModBlockEntities.ULTRAHOLE_ROCK_BE, UltraHolePortalRenderer::new);
    }

    private void registerRenderers() {
        ArmorRenderer invisibleBoots = (matrices, vertexConsumers, stack, entity, slot, light, model) -> {};
        ArmorRenderer.register((ArmorRenderer)invisibleBoots, (class_1935[])new class_1935[]{ModItems.RUNNING_SHOES});
        ModEntityRenderers.register();
        EntityModelLayerRegistry.registerModelLayer((class_5601)ModModelLayers.BICYCLE, BicycleEntityModel::getTexturedModelData);
        EntityRendererRegistry.register(ModEntities.BICYCLE, BicycleRenderer::new);
    }

    private void registerClientReceivers() {
        BadgeBoxClientHandler.register();
        GrassNetworkingInit.registerReceivers();
        ClientPlayNetworking.registerGlobalReceiver(RotatePlayerS2CPacket.ID, (payload, ctx) -> {
            float total = payload.totalRotation();
            int ticks = Math.max(1, payload.durationTicks());
            ctx.client().execute(() -> {
                ClientAnimationState.rotationPerTick = total / (float)ticks;
                ClientAnimationState.ticksRemaining = ticks;
            });
        });
    }

    private void registerClientEvents() {
        ClientEventHandler.register();
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (ClientAnimationState.ticksRemaining > 0 && client.field_1724 != null) {
                float delta = ClientAnimationState.rotationPerTick;
                class_746 p = client.field_1724;
                p.method_36456(p.method_36454() + delta);
                p.method_5847(p.method_5791() + delta);
                if (--ClientAnimationState.ticksRemaining == 0) {
                    ClientAnimationState.rotationPerTick = 0.0f;
                }
            }
        });
    }

    private void registerBicycleInputHandlers() {
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            boolean jumpPressed;
            class_746 player = client.field_1724;
            if (client.field_1687 == null || player == null) {
                return;
            }
            boolean ridingBike = player.method_5765() && player.method_5854() instanceof BicycleEntity;
            boolean usePressed = client.field_1690.field_1904.method_1434();
            boolean useJustDown = usePressed && !this.wasUsePressed;
            this.wasUsePressed = usePressed;
            if (useJustDown && ridingBike && player.method_6047().method_7960()) {
                ClientPlayNetworking.send((class_8710)new ToggleBikeGearC2SPacket());
            }
            boolean jumpChanged = (jumpPressed = client.field_1690.field_1903.method_1434()) != this.wasJumpPressed;
            this.wasJumpPressed = jumpPressed;
            if (jumpChanged && ridingBike) {
                ClientPlayNetworking.send((class_8710)new BikeWheelieC2SPacket(jumpPressed));
            }
        });
    }
}

