/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.khataly.mapkit.command.custom;

import com.cobblemon.khataly.mapkit.config.LevelCapConfig;
import com.cobblemon.khataly.mapkit.config.PlayerLevelCapProgress;
import com.cobblemon.khataly.mapkit.util.LevelCapService;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class LevelCapCommands {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        LiteralArgumentBuilder root = class_2170.method_9247((String)"levelcap");
        root.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"check").executes(ctx -> {
            class_3222 self = ((class_2168)ctx.getSource()).method_44023();
            if (self == null) {
                ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43470((String)"\u00a7cThis command must be executed by a player."));
                return 0;
            }
            LevelCapCommands.sendPlayerCapInfo((class_2168)ctx.getSource(), self, false);
            return 1;
        })).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).requires(src -> src.method_9259(2))).executes(ctx -> {
            class_3222 p = class_2186.method_9315((CommandContext)ctx, (String)"player");
            LevelCapCommands.sendPlayerCapInfo((class_2168)ctx.getSource(), p, true);
            return 1;
        })));
        root.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"enabled").requires(src -> src.method_9259(2))).then(class_2170.method_9244((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> {
            boolean v = BoolArgumentType.getBool((CommandContext)ctx, (String)"value");
            LevelCapConfig.setEnabled(v);
            ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43470((String)("\u00a7aLevel-cap system enabled = \u00a7e" + v + "\u00a7a.")));
            return 1;
        })));
        root.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"clamp-gained").requires(src -> src.method_9259(2))).then(class_2170.method_9244((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> {
            boolean v = BoolArgumentType.getBool((CommandContext)ctx, (String)"value");
            LevelCapConfig.setClampGainedOverCap(v);
            ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43470((String)("\u00a7aClamp on gained over cap = \u00a7e" + v + "\u00a7a.")));
            return 1;
        })));
        root.then(class_2170.method_9247((String)"info").executes(ctx -> {
            Map<String, Integer> map = LevelCapConfig.getAllLabelsWithCaps();
            ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43470((String)"\u00a76-- Level Cap Labels --"));
            if (map.isEmpty()) {
                ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43470((String)"\u00a7cNo labels configured."));
            } else {
                for (Map.Entry<String, Integer> e : map.entrySet()) {
                    String key = e.getKey();
                    int cap = e.getValue();
                    String nice = LevelCapConfig.displayLabel(key);
                    int items = LevelCapConfig.getItemIdsForLabel(key).size();
                    ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43470((String)("\u00a77" + nice + " \u00a7f\u2192 \u00a7b" + cap + (String)(items > 0 ? " \u00a78(" + items + " item link)" : ""))));
                }
            }
            ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43470((String)("\u00a77Base: \u00a7f" + LevelCapConfig.getBaseCap() + " \u00a77| Bypass shiny: \u00a7f" + LevelCapConfig.isBypassIfShiny() + " \u00a77| MasterBall bypass: \u00a7f" + LevelCapConfig.isBypassOnMasterBall() + " \u00a77| Clamp gained: \u00a7f" + LevelCapConfig.isClampGainedOverCap() + " \u00a77| Clamp capture: \u00a7f" + LevelCapConfig.isClampCapturedOverCap())));
            return 1;
        }));
        root.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"bypass-shiny").requires(src -> src.method_9259(2))).then(class_2170.method_9244((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> {
            boolean v = BoolArgumentType.getBool((CommandContext)ctx, (String)"value");
            LevelCapConfig.setBypassIfShiny(v);
            ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43470((String)("\u00a7aShiny capture bypass set to \u00a7e" + v + "\u00a7a.")));
            return 1;
        })));
        root.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"bypass-masterball").requires(src -> src.method_9259(2))).then(class_2170.method_9244((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> {
            boolean v = BoolArgumentType.getBool((CommandContext)ctx, (String)"value");
            LevelCapConfig.setBypassOnMasterBall(v);
            ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43470((String)("\u00a7aMaster Ball capture bypass set to \u00a7e" + v + "\u00a7a.")));
            return 1;
        })));
        root.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"clamps-level").requires(src -> src.method_9259(2))).then(class_2170.method_9244((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> {
            boolean v = BoolArgumentType.getBool((CommandContext)ctx, (String)"value");
            LevelCapConfig.setClampCapturedOverCap(v);
            ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43470((String)("\u00a7aClamps level set to \u00a7e" + v + "\u00a7a.")));
            return 1;
        })));
        root.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"base").requires(src -> src.method_9259(2))).then(class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> {
            int v = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"value");
            LevelCapConfig.setBaseCap(v);
            ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43470((String)("\u00a7aBase level cap set to \u00a7e" + v + "\u00a7a.")));
            return 1;
        })));
        root.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"list").requires(src -> src.method_9259(2))).executes(ctx -> {
            Map<String, Integer> map = LevelCapConfig.getAllLabelsWithCaps();
            ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43470((String)"\u00a76-- LevelCaps List --"));
            if (map.isEmpty()) {
                ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43470((String)"\u00a7c(none)"));
            } else {
                for (Map.Entry<String, Integer> e : map.entrySet()) {
                    String key = e.getKey();
                    int cap = e.getValue();
                    ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43470((String)("\u00a77" + LevelCapCommands.pretty(key) + " \u00a7f\u2192 \u00a7b" + cap)));
                }
            }
            return 1;
        }));
        LiteralArgumentBuilder playerRoot = (LiteralArgumentBuilder)class_2170.method_9247((String)"player").requires(src -> src.method_9259(2));
        playerRoot.then(class_2170.method_9247((String)"show").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(ctx -> {
            class_3222 p = class_2186.method_9315((CommandContext)ctx, (String)"player");
            Set<String> appliedKeys = PlayerLevelCapProgress.getApplied(p.method_5667());
            ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43470((String)("\u00a76-- Applied labels for \u00a7b" + p.method_5477().getString() + "\u00a76 --")));
            if (appliedKeys.isEmpty()) {
                ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43470((String)"\u00a7c(none)"));
            } else {
                Map<String, Integer> caps = LevelCapConfig.getAllLabelsWithCaps();
                for (String key : appliedKeys) {
                    Integer cap = caps.get(key);
                    ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43470((String)("\u00a77" + LevelCapCommands.pretty(key) + " \u00a7f\u2192 \u00a7b" + String.valueOf(cap == null ? "?" : cap))));
                }
            }
            return 1;
        })));
        playerRoot.then(class_2170.method_9247((String)"reset-key").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).then(class_2170.method_9244((String)"label", (ArgumentType)StringArgumentType.greedyString()).suggests(LevelCapCommands::suggestAppliedLabelsForPlayer).executes(ctx -> {
            class_3222 p = class_2186.method_9315((CommandContext)ctx, (String)"player");
            String key = LevelCapCommands.keyOf(StringArgumentType.getString((CommandContext)ctx, (String)"label"));
            boolean ok = PlayerLevelCapProgress.remove(p.method_5667(), key);
            if (ok) {
                ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43470((String)("\u00a7aRemoved \u00a7e" + LevelCapCommands.pretty(key) + " \u00a7afrom \u00a7b" + p.method_5477().getString() + "\u00a7a.")));
                p.method_7353((class_2561)class_2561.method_43470((String)("\u00a7a[Admin] Progress label \u00a7e" + LevelCapCommands.pretty(key) + " \u00a7ahas been reset.")), false);
                return 1;
            }
            ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43470((String)("\u00a7cPlayer \u00a7b" + p.method_5477().getString() + " \u00a7cdoes not have \u00a7e" + LevelCapCommands.pretty(key) + "\u00a7c applied.")));
            return 0;
        }))));
        playerRoot.then(class_2170.method_9247((String)"reset-all").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(ctx -> {
            class_3222 p = class_2186.method_9315((CommandContext)ctx, (String)"player");
            PlayerLevelCapProgress.clearAll(p.method_5667());
            ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43470((String)("\u00a7aCleared all progress for \u00a7b" + p.method_5477().getString() + "\u00a7a.")));
            p.method_7353((class_2561)class_2561.method_43470((String)"\u00a7a[Admin] Level-cap progress has been reset."), false);
            return 1;
        })));
        root.then((ArgumentBuilder)playerRoot);
        dispatcher.register(root);
    }

    private static String keyOf(String label) {
        return LevelCapConfig.normalizeLabel(label);
    }

    private static String pretty(String key) {
        return LevelCapConfig.displayLabel(key);
    }

    private static CompletableFuture<Suggestions> suggestAppliedLabelsForPlayer(CommandContext<class_2168> ctx, SuggestionsBuilder b) {
        try {
            class_3222 p = class_2186.method_9315(ctx, (String)"player");
            Set<String> keys = PlayerLevelCapProgress.getApplied(p.method_5667());
            ArrayList<String> pretty = new ArrayList<String>();
            for (String k : keys) {
                pretty.add(LevelCapConfig.displayLabel(k));
            }
            return class_2172.method_9265(pretty, (SuggestionsBuilder)b);
        }
        catch (Exception e) {
            return b.buildFuture();
        }
    }

    private static void sendPlayerCapInfo(class_2168 src, class_3222 p, boolean includeName) {
        int effective = LevelCapService.getEffectiveCap(p);
        Set<String> applied = PlayerLevelCapProgress.getApplied(p.method_5667());
        int bestProgressionCap = LevelCapConfig.getBaseCap();
        Map<String, Integer> labelsCaps = LevelCapConfig.getAllLabelsWithCaps();
        for (String key : applied) {
            Integer cap = labelsCaps.get(key);
            if (cap == null || cap <= bestProgressionCap) continue;
            bestProgressionCap = cap;
        }
        String header = includeName ? "\u00a76-- Level Cap for \u00a7b" + p.method_5477().getString() + "\u00a76 --" : "\u00a76-- Your Level Cap --";
        src.method_45068((class_2561)class_2561.method_43470((String)header));
        src.method_45068((class_2561)class_2561.method_43470((String)("\u00a77Base Cap: \u00a7f" + LevelCapConfig.getBaseCap())));
        src.method_45068((class_2561)class_2561.method_43470((String)("\u00a77Best Progression Cap: \u00a7f" + bestProgressionCap)));
        src.method_45068((class_2561)class_2561.method_43470((String)("\u00a77Effective Cap: \u00a7f" + effective)));
        if (!applied.isEmpty()) {
            src.method_45068((class_2561)class_2561.method_43470((String)"\u00a77Progress:"));
            for (String key : applied) {
                Integer cap = labelsCaps.get(key);
                src.method_45068((class_2561)class_2561.method_43470((String)("  \u00a7f- " + LevelCapCommands.pretty(key) + " \u00a77\u2192 \u00a7b" + String.valueOf(cap == null ? "?" : cap))));
            }
        }
    }
}

