/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.khataly.mapkit.config;

import com.cobblemon.khataly.mapkit.CobblemonMapKitMod;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.text.Normalizer;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7924;

public class GrassZonesConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File ZONES_DIR = new File("config/cobblemonmapkit/zones");
    private static final int CURRENT_SCHEMA_VERSION = 4;
    private static final Map<UUID, Zone> ZONES = new LinkedHashMap<UUID, Zone>();
    private static final Map<UUID, File> FILE_BY_ID = new HashMap<UUID, File>();

    public static void load() {
        GrassZonesConfig.ensureDir();
        ZONES.clear();
        FILE_BY_ID.clear();
        File legacy = new File("config/cobblemonmapkit/grass_zones.json");
        if (legacy.exists()) {
            GrassZonesConfig.migrateLegacy(legacy);
            return;
        }
        File[] files = ZONES_DIR.listFiles((dir, name) -> name.toLowerCase(Locale.ROOT).endsWith(".json"));
        if (files == null || files.length == 0) {
            CobblemonMapKitMod.LOGGER.info("[GrassZonesConfig] No zones found.");
            return;
        }
        int ok = 0;
        int bad = 0;
        for (File f : files) {
            try {
                Zone z = GrassZonesConfig.readZoneFile(f);
                ZONES.put(z.id(), z);
                FILE_BY_ID.put(z.id(), f);
                ++ok;
            }
            catch (Exception e) {
                CobblemonMapKitMod.LOGGER.warn("[GrassZonesConfig] Could not read {}: {}", (Object)f.getName(), (Object)e.getMessage());
                ++bad;
            }
        }
        CobblemonMapKitMod.LOGGER.info("[GrassZonesConfig] Loaded {} zones ({} invalid).", (Object)ok, (Object)bad);
    }

    public static boolean overlaps(class_5321<class_1937> worldKey, int minX, int minZ, int maxX, int maxZ, int y) {
        int aMinX = Math.min(minX, maxX);
        int aMaxX = Math.max(minX, maxX);
        int aMinZ = Math.min(minZ, maxZ);
        int aMaxZ = Math.max(minZ, maxZ);
        for (Zone z : ZONES.values()) {
            boolean yInside;
            if (!z.worldKey().equals(worldKey)) continue;
            boolean xOverlap = aMinX <= z.maxX() && aMaxX >= z.minX();
            boolean zOverlap = aMinZ <= z.maxZ() && aMaxZ >= z.minZ();
            boolean bl = yInside = y >= z.minY() && y <= z.maxY();
            if (!xOverlap || !zOverlap || !yInside) continue;
            return true;
        }
        return false;
    }

    public static boolean overlaps(class_5321<class_1937> worldKey, int minX, int minZ, int maxX, int maxZ, int minY, int maxY) {
        int aMinX = Math.min(minX, maxX);
        int aMaxX = Math.max(minX, maxX);
        int aMinZ = Math.min(minZ, maxZ);
        int aMaxZ = Math.max(minZ, maxZ);
        int aMinY = Math.min(minY, maxY);
        int aMaxY = Math.max(minY, maxY);
        for (Zone z : ZONES.values()) {
            boolean yOverlap;
            if (!z.worldKey().equals(worldKey)) continue;
            boolean xOverlap = aMinX <= z.maxX() && aMaxX >= z.minX();
            boolean zOverlap = aMinZ <= z.maxZ() && aMaxZ >= z.minZ();
            boolean bl = yOverlap = aMinY <= z.maxY() && aMaxY >= z.minY();
            if (!xOverlap || !zOverlap || !yOverlap) continue;
            return true;
        }
        return false;
    }

    public static boolean overlaps(class_5321<class_1937> worldKey, int minX, int minZ, int maxX, int maxZ) {
        int aMinX = Math.min(minX, maxX);
        int aMaxX = Math.max(minX, maxX);
        int aMinZ = Math.min(minZ, maxZ);
        int aMaxZ = Math.max(minZ, maxZ);
        for (Zone z : ZONES.values()) {
            boolean zOverlap;
            if (!z.worldKey().equals(worldKey)) continue;
            boolean xOverlap = aMinX <= z.maxX() && aMaxX >= z.minX();
            boolean bl = zOverlap = aMinZ <= z.maxZ() && aMaxZ >= z.minZ();
            if (!xOverlap || !zOverlap) continue;
            return true;
        }
        return false;
    }

    public static void save() {
        try {
            GrassZonesConfig.ensureDir();
            HashSet<File> keep = new HashSet<File>();
            for (Zone z : ZONES.values()) {
                File f = GrassZonesConfig.writeZoneFile(z);
                keep.add(f);
                FILE_BY_ID.put(z.id(), f);
            }
            File[] files = ZONES_DIR.listFiles((dir, name) -> name.toLowerCase(Locale.ROOT).endsWith(".json"));
            if (files != null) {
                for (File f : files) {
                    boolean deleted;
                    if (keep.contains(f) || (deleted = f.delete())) continue;
                    CobblemonMapKitMod.LOGGER.warn("[GrassZonesConfig] Could not delete orphan {}", (Object)f.getName());
                }
            }
        }
        catch (IOException e) {
            CobblemonMapKitMod.LOGGER.error("[GrassZonesConfig] Save error: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public static UUID addZone(String name, class_5321<class_1937> worldKey, int minX, int minZ, int maxX, int maxZ, int y, List<SpawnEntry> spawns) {
        return GrassZonesConfig.addZone(name, worldKey, minX, minZ, maxX, maxZ, y, y, spawns, -1);
    }

    public static UUID addZone(String name, class_5321<class_1937> worldKey, int minX, int minZ, int maxX, int maxZ, int y, List<SpawnEntry> spawns, int shinyOdds) {
        return GrassZonesConfig.addZone(name, worldKey, minX, minZ, maxX, maxZ, y, y, spawns, shinyOdds);
    }

    public static UUID addZone(String name, class_5321<class_1937> worldKey, int minX, int minZ, int maxX, int maxZ, int minY, int maxY, List<SpawnEntry> spawns) {
        return GrassZonesConfig.addZone(name, worldKey, minX, minZ, maxX, maxZ, minY, maxY, spawns, -1);
    }

    public static UUID addZone(String name, class_5321<class_1937> worldKey, int minX, int minZ, int maxX, int maxZ, int minY, int maxY, List<SpawnEntry> spawns, int shinyOdds) {
        UUID id = UUID.randomUUID();
        Zone z = new Zone(id, name, worldKey, minX, minZ, maxX, maxZ, minY, maxY, Instant.now().toEpochMilli(), spawns == null ? List.of() : spawns, shinyOdds);
        ZONES.put(id, z);
        try {
            File f = GrassZonesConfig.writeZoneFile(z);
            FILE_BY_ID.put(id, f);
        }
        catch (IOException e) {
            CobblemonMapKitMod.LOGGER.error("[GrassZonesConfig] Write error on addZone {}: {}", new Object[]{id, e.getMessage(), e});
        }
        return id;
    }

    public static boolean removeZone(UUID id) {
        Zone removed = ZONES.remove(id);
        File f = FILE_BY_ID.remove(id);
        if (removed != null) {
            if (f == null) {
                f = GrassZonesConfig.guessFileByName(removed.name());
            }
            if (f.exists() && !f.delete()) {
                CobblemonMapKitMod.LOGGER.warn("[GrassZonesConfig] Could not delete file {}", (Object)f.getName());
            }
            return true;
        }
        return false;
    }

    public static List<Zone> findAt(class_5321<class_1937> wk, int x, int y, int z) {
        ArrayList<Zone> out = new ArrayList<Zone>();
        for (Zone z0 : ZONES.values()) {
            if (!z0.contains(x, y, z, wk)) continue;
            out.add(z0);
        }
        return out;
    }

    public static boolean addSpawn(UUID zoneId, SpawnEntry entry) {
        Zone z = ZONES.get(zoneId);
        if (z == null) {
            return false;
        }
        ArrayList<SpawnEntry> ns = new ArrayList<SpawnEntry>(z.spawns());
        ns.add(entry);
        Zone nz = z.withSpawns(ns);
        ZONES.put(zoneId, nz);
        try {
            File f = GrassZonesConfig.writeZoneFile(nz);
            FILE_BY_ID.put(zoneId, f);
        }
        catch (IOException e) {
            CobblemonMapKitMod.LOGGER.error("[GrassZonesConfig] Write error on addSpawn {}: {}", new Object[]{zoneId, e.getMessage(), e});
        }
        return true;
    }

    public static boolean removeSpawn(UUID zoneId, String speciesId) {
        Zone z = ZONES.get(zoneId);
        if (z == null) {
            return false;
        }
        ArrayList<SpawnEntry> ns = new ArrayList<SpawnEntry>();
        for (SpawnEntry e : z.spawns()) {
            if (e.species.equalsIgnoreCase(speciesId)) continue;
            ns.add(e);
        }
        Zone nz = z.withSpawns(ns);
        ZONES.put(zoneId, nz);
        try {
            File f = GrassZonesConfig.writeZoneFile(nz);
            FILE_BY_ID.put(zoneId, f);
        }
        catch (IOException e) {
            CobblemonMapKitMod.LOGGER.error("[GrassZonesConfig] Write error on removeSpawn {}: {}", new Object[]{zoneId, e.getMessage(), e});
        }
        return true;
    }

    public static boolean setZoneShinyOdds(UUID zoneId, int shinyOdds) {
        Zone z = ZONES.get(zoneId);
        if (z == null) {
            return false;
        }
        Zone nz = z.withShinyOdds(shinyOdds);
        ZONES.put(zoneId, nz);
        try {
            File f = GrassZonesConfig.writeZoneFile(nz);
            FILE_BY_ID.put(zoneId, f);
        }
        catch (IOException e) {
            CobblemonMapKitMod.LOGGER.error("[GrassZonesConfig] Write error on setZoneShinyOdds {}: {}", new Object[]{zoneId, e.getMessage(), e});
        }
        return true;
    }

    public static boolean setZoneName(UUID zoneId, String newName) {
        if (newName == null || newName.isBlank()) {
            return false;
        }
        Zone z = ZONES.get(zoneId);
        if (z == null) {
            return false;
        }
        Zone nz = z.withName(newName);
        ZONES.put(zoneId, nz);
        try {
            boolean deleted;
            File oldFile = FILE_BY_ID.get(zoneId);
            File newFile = GrassZonesConfig.writeZoneFile(nz);
            FILE_BY_ID.put(zoneId, newFile);
            if (oldFile != null && !GrassZonesConfig.sameFile(oldFile, newFile) && oldFile.exists() && !GrassZonesConfig.isFileUsedByOtherZone(oldFile, zoneId) && !(deleted = oldFile.delete())) {
                CobblemonMapKitMod.LOGGER.warn("[GrassZonesConfig] Could not delete old file {}", (Object)oldFile.getName());
            }
        }
        catch (IOException e) {
            CobblemonMapKitMod.LOGGER.error("[GrassZonesConfig] Write error on setZoneName {}: {}", new Object[]{zoneId, e.getMessage(), e});
            return false;
        }
        return true;
    }

    public static Collection<Zone> getAll() {
        return Collections.unmodifiableCollection(ZONES.values());
    }

    public static Zone get(UUID id) {
        return ZONES.get(id);
    }

    private static void migrateLegacy(File legacy) {
        CobblemonMapKitMod.LOGGER.info("[GrassZonesConfig] Migrating from legacy grass_zones.json to zones/ ...");
        ArrayList<Zone> loaded = new ArrayList<Zone>();
        try (FileReader r = new FileReader(legacy);){
            ConfigDataLegacy data = (ConfigDataLegacy)GSON.fromJson((Reader)r, ConfigDataLegacy.class);
            if (data != null && data.zones != null) {
                for (ZoneData zd : data.zones) {
                    try {
                        Zone z = GrassZonesConfig.fromZoneData(zd);
                        loaded.add(z);
                    }
                    catch (Exception ex) {
                        CobblemonMapKitMod.LOGGER.warn("[GrassZonesConfig] Invalid legacy zone, skipping: {}", (Object)(zd != null ? zd.id : "<null>"));
                    }
                }
            }
        }
        catch (Exception e) {
            CobblemonMapKitMod.LOGGER.error("[GrassZonesConfig] Legacy read error: {}", (Object)e.getMessage(), (Object)e);
        }
        for (Zone z : loaded) {
            ZONES.put(z.id(), z);
            try {
                File f = GrassZonesConfig.writeZoneFile(z);
                FILE_BY_ID.put(z.id(), f);
            }
            catch (IOException e) {
                CobblemonMapKitMod.LOGGER.error("[GrassZonesConfig] Error writing migrated zone {}: {}", new Object[]{z.id(), e.getMessage(), e});
            }
        }
        File bak = new File(legacy.getParentFile(), legacy.getName() + ".bak");
        if (!legacy.renameTo(bak)) {
            CobblemonMapKitMod.LOGGER.warn("[GrassZonesConfig] Could not rename legacy file, leaving it in place.");
        }
        CobblemonMapKitMod.LOGGER.info("[GrassZonesConfig] Migration complete: {} zones.", (Object)ZONES.size());
    }

    private static TimeBand parseTime(String s) {
        if (s == null) {
            return TimeBand.BOTH;
        }
        return switch (s.toLowerCase(Locale.ROOT)) {
            case "day" -> TimeBand.DAY;
            case "night" -> TimeBand.NIGHT;
            default -> TimeBand.BOTH;
        };
    }

    private static void ensureDir() {
        boolean ok;
        boolean okParent;
        File parent = ZONES_DIR.getParentFile();
        if (!(parent == null || parent.exists() || (okParent = parent.mkdirs()) || parent.exists())) {
            CobblemonMapKitMod.LOGGER.warn("[GrassZonesConfig] Unable to create parent dir: {}", (Object)parent.getAbsolutePath());
        }
        if (!(ZONES_DIR.exists() || (ok = ZONES_DIR.mkdirs()) || ZONES_DIR.exists())) {
            CobblemonMapKitMod.LOGGER.warn("[GrassZonesConfig] Unable to create zones dir: {}", (Object)ZONES_DIR.getAbsolutePath());
        }
    }

    private static String shortId(UUID id) {
        String s = id.toString().replace("-", "");
        return s.substring(0, 6).toUpperCase(Locale.ROOT);
    }

    private static String sanitizeForFilename(String name) {
        String n = Normalizer.normalize(name, Normalizer.Form.NFD).replaceAll("\\p{M}+", "");
        n = n.replaceAll("[^\\w\\-.\\s]", "_").trim();
        if ((n = n.replaceAll("\\s+", " ")).isEmpty()) {
            n = "Zone";
        }
        if (n.length() > 80) {
            n = n.substring(0, 80).trim();
        }
        return n;
    }

    private static File guessFileByName(String zoneName) {
        String base = GrassZonesConfig.sanitizeForFilename(zoneName);
        return new File(ZONES_DIR, base + ".json");
    }

    private static boolean sameFile(File a, File b) {
        try {
            return a.getCanonicalPath().equals(b.getCanonicalPath());
        }
        catch (IOException e) {
            return a.getAbsolutePath().equals(b.getAbsolutePath());
        }
    }

    private static boolean isFileUsedByOtherZone(File f, UUID currentId) {
        for (Map.Entry<UUID, File> e : FILE_BY_ID.entrySet()) {
            if (e.getKey().equals(currentId) || !GrassZonesConfig.sameFile(e.getValue(), f)) continue;
            return true;
        }
        return false;
    }

    private static File uniqueFileForName(String desiredName, UUID ownerId) {
        String base = GrassZonesConfig.sanitizeForFilename(desiredName);
        File f = new File(ZONES_DIR, base + ".json");
        if (!GrassZonesConfig.existsDifferentOwner(f, ownerId)) {
            return f;
        }
        int i = 2;
        File cand;
        while (GrassZonesConfig.existsDifferentOwner(cand = new File(ZONES_DIR, base + " (" + i + ").json"), ownerId)) {
            ++i;
        }
        return cand;
    }

    private static boolean existsDifferentOwner(File f, UUID ownerId) {
        if (!f.exists()) {
            return false;
        }
        try {
            Zone z = GrassZonesConfig.readZoneFile(f);
            return !z.id().equals(ownerId);
        }
        catch (Exception e) {
            return true;
        }
    }

    private static File writeZoneFile(Zone z) throws IOException {
        GrassZonesConfig.ensureDir();
        File current = FILE_BY_ID.get(z.id());
        File target = GrassZonesConfig.uniqueFileForName(z.name(), z.id());
        if (current != null && current.exists()) {
            boolean deleted;
            if (GrassZonesConfig.sameFile(current, target)) {
                return GrassZonesConfig.writeJson(target, z);
            }
            File written = GrassZonesConfig.writeJson(target, z);
            if (!GrassZonesConfig.isFileUsedByOtherZone(current, z.id()) && current.exists() && !(deleted = current.delete())) {
                CobblemonMapKitMod.LOGGER.warn("[GrassZonesConfig] Could not delete old file {}", (Object)current.getName());
            }
            return written;
        }
        return GrassZonesConfig.writeJson(target, z);
    }

    private static File writeJson(File target, Zone z) throws IOException {
        ZoneData zd = GrassZonesConfig.toZoneData(z);
        FileWrap wrap = new FileWrap();
        wrap.schemaVersion = 4;
        wrap.zone = zd;
        File tmp = new File(target.getParentFile(), target.getName() + ".tmp");
        try (FileWriter w = new FileWriter(tmp);){
            GSON.toJson((Object)wrap, (Appendable)w);
        }
        try {
            Files.move(tmp.toPath(), target.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (IOException atomicNotSupported) {
            CobblemonMapKitMod.LOGGER.debug("[GrassZonesConfig] ATOMIC_MOVE not supported for {}, falling back.", (Object)target.getName());
            Files.move(tmp.toPath(), target.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        return target;
    }

    private static ZoneData toZoneData(Zone z) {
        ZoneData zd = new ZoneData();
        zd.id = z.id().toString();
        zd.name = z.name();
        zd.worldKey = z.worldKey().method_29177().toString();
        zd.minX = z.minX();
        zd.minZ = z.minZ();
        zd.maxX = z.maxX();
        zd.maxZ = z.maxZ();
        zd.minY = z.minY();
        zd.maxY = z.maxY();
        zd.y = null;
        zd.timeCreated = z.timeCreated();
        zd.shinyOdds = z.shinyOdds() <= 0 ? -1 : z.shinyOdds();
        zd.spawns = new ArrayList<SpawnData>();
        for (SpawnEntry se : z.spawns()) {
            SpawnData sd = new SpawnData();
            sd.species = se.species;
            sd.minLevel = se.minLevel;
            sd.maxLevel = se.maxLevel;
            sd.weight = se.weight;
            sd.time = se.time.name().toLowerCase(Locale.ROOT);
            if (se.aspect != null && !se.aspect.isBlank()) {
                sd.aspect = se.aspect;
            }
            zd.spawns.add(sd);
        }
        return zd;
    }

    private static Zone fromZoneData(ZoneData zd) {
        int maxY;
        int minY;
        UUID id = UUID.fromString(zd.id);
        class_2960 wid = class_2960.method_12829((String)zd.worldKey);
        if (wid == null) {
            throw new IllegalArgumentException("bad worldKey");
        }
        class_5321 wk = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)wid);
        if (zd.minY != null || zd.maxY != null) {
            int minY0 = zd.minY != null ? zd.minY : zd.maxY;
            int maxY0 = zd.maxY != null ? zd.maxY : minY0;
            minY = Math.min(minY0, maxY0);
            maxY = Math.max(minY0, maxY0);
        } else if (zd.y != null) {
            minY = zd.y;
            maxY = zd.y;
        } else {
            CobblemonMapKitMod.LOGGER.warn("[GrassZonesConfig] Missing Y info for zone {}, defaulting to 0..0", (Object)zd.id);
            minY = 0;
            maxY = 0;
        }
        ArrayList<SpawnEntry> spawns = new ArrayList<SpawnEntry>();
        if (zd.spawns != null) {
            for (SpawnData sd : zd.spawns) {
                if (sd == null || sd.species == null || sd.species.isBlank() || sd.minLevel <= 0 || sd.maxLevel < sd.minLevel || sd.weight <= 0) {
                    CobblemonMapKitMod.LOGGER.warn("[GrassZonesConfig] Invalid spawn in zone {}: {}", (Object)zd.id, (Object)sd);
                    continue;
                }
                spawns.add(new SpawnEntry(sd.species, sd.minLevel, sd.maxLevel, sd.weight, GrassZonesConfig.parseTime(sd.time), sd.aspect));
            }
        }
        long t = zd.timeCreated == 0L ? Instant.now().toEpochMilli() : zd.timeCreated;
        int shinyOdds = zd.shinyOdds == null || zd.shinyOdds <= 0 ? -1 : zd.shinyOdds;
        String name = zd.name == null || zd.name.isBlank() ? "Zone " + GrassZonesConfig.shortId(id) : zd.name;
        return new Zone(id, name, (class_5321<class_1937>)wk, zd.minX, zd.minZ, zd.maxX, zd.maxZ, minY, maxY, t, spawns, shinyOdds);
    }

    private static Zone readZoneFile(File f) throws IOException {
        try (FileReader r = new FileReader(f);){
            int ver;
            FileWrap wrap = (FileWrap)GSON.fromJson((Reader)r, FileWrap.class);
            int n = ver = wrap != null && wrap.schemaVersion != null ? wrap.schemaVersion : 4;
            if (wrap == null || wrap.zone == null) {
                throw new IOException("empty or invalid wrap");
            }
            Zone z = GrassZonesConfig.fromZoneData(wrap.zone);
            if (ver != 4) {
                CobblemonMapKitMod.LOGGER.warn("[GrassZonesConfig] schemaVersion {} != {} in {}, will rewrite on save.", new Object[]{ver, 4, f.getName()});
            }
            Zone zone = z;
            return zone;
        }
    }

    public static final class Zone {
        private final UUID id;
        private final String name;
        private final class_5321<class_1937> worldKey;
        private final int minX;
        private final int minZ;
        private final int maxX;
        private final int maxZ;
        private final int minY;
        private final int maxY;
        private final long timeCreated;
        private final List<SpawnEntry> spawns;
        private final int shinyOdds;

        public Zone(UUID id, String name, class_5321<class_1937> worldKey, int minX, int minZ, int maxX, int maxZ, int minY, int maxY, long timeCreated, List<SpawnEntry> spawns, int shinyOdds) {
            this.id = id;
            this.name = name == null || name.isBlank() ? "Zone " + GrassZonesConfig.shortId(id) : name.trim();
            this.worldKey = worldKey;
            this.minX = Math.min(minX, maxX);
            this.minZ = Math.min(minZ, maxZ);
            this.maxX = Math.max(minX, maxX);
            this.maxZ = Math.max(minZ, maxZ);
            this.minY = Math.min(minY, maxY);
            this.maxY = Math.max(minY, maxY);
            this.timeCreated = timeCreated;
            this.spawns = List.copyOf(spawns == null ? List.of() : spawns);
            this.shinyOdds = shinyOdds <= 0 ? -1 : shinyOdds;
        }

        public boolean contains(int x, int y, int z, class_5321<class_1937> w) {
            if (!w.equals(this.worldKey)) {
                return false;
            }
            return x >= this.minX && x <= this.maxX && z >= this.minZ && z <= this.maxZ && y >= this.minY && y <= this.maxY;
        }

        public UUID id() {
            return this.id;
        }

        public String name() {
            return this.name;
        }

        public class_5321<class_1937> worldKey() {
            return this.worldKey;
        }

        public int minX() {
            return this.minX;
        }

        public int minZ() {
            return this.minZ;
        }

        public int maxX() {
            return this.maxX;
        }

        public int maxZ() {
            return this.maxZ;
        }

        public int minY() {
            return this.minY;
        }

        public int maxY() {
            return this.maxY;
        }

        public long timeCreated() {
            return this.timeCreated;
        }

        public List<SpawnEntry> spawns() {
            return this.spawns;
        }

        public int shinyOdds() {
            return this.shinyOdds;
        }

        public Zone withName(String newName) {
            return new Zone(this.id, newName, this.worldKey, this.minX, this.minZ, this.maxX, this.maxZ, this.minY, this.maxY, this.timeCreated, this.spawns, this.shinyOdds);
        }

        public Zone withShinyOdds(int newShinyOdds) {
            return new Zone(this.id, this.name, this.worldKey, this.minX, this.minZ, this.maxX, this.maxZ, this.minY, this.maxY, this.timeCreated, this.spawns, newShinyOdds);
        }

        public Zone withSpawns(List<SpawnEntry> newSpawns) {
            return new Zone(this.id, this.name, this.worldKey, this.minX, this.minZ, this.maxX, this.maxZ, this.minY, this.maxY, this.timeCreated, newSpawns, this.shinyOdds);
        }
    }

    public static final class SpawnEntry {
        public final String species;
        public final int minLevel;
        public final int maxLevel;
        public final int weight;
        public final TimeBand time;
        public final String aspect;

        public SpawnEntry(String species, int minLevel, int maxLevel, int weight, TimeBand time, String aspect) {
            this.species = species;
            this.minLevel = minLevel;
            this.maxLevel = maxLevel;
            this.weight = weight;
            this.time = time == null ? TimeBand.BOTH : time;
            this.aspect = aspect != null && !aspect.isBlank() ? aspect : null;
        }

        public SpawnEntry(String species, int minLevel, int maxLevel, int weight, TimeBand time) {
            this(species, minLevel, maxLevel, weight, time, null);
        }

        public SpawnEntry(String species, int minLevel, int maxLevel, int weight) {
            this(species, minLevel, maxLevel, weight, TimeBand.BOTH, null);
        }
    }

    private static class ConfigDataLegacy {
        Integer schemaVersion;
        List<ZoneData> zones;

        private ConfigDataLegacy() {
        }
    }

    private static class ZoneData {
        String id;
        String name;
        String worldKey;
        int minX;
        int minZ;
        int maxX;
        int maxZ;
        Integer minY;
        Integer maxY;
        Integer y;
        long timeCreated;
        List<SpawnData> spawns;
        Integer shinyOdds;

        private ZoneData() {
        }
    }

    public static enum TimeBand {
        DAY,
        NIGHT,
        BOTH;

    }

    private static class FileWrap {
        Integer schemaVersion;
        ZoneData zone;

        private FileWrap() {
        }
    }

    private static class SpawnData {
        String species;
        int minLevel;
        int maxLevel;
        int weight;
        String time;
        String aspect;

        private SpawnData() {
        }
    }
}

