/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.khataly.mapkit.networking.manager;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1540;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RestoreManager {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"RestoreManager");
    private static final RestoreManager INSTANCE = new RestoreManager();
    private final Map<class_2338, TimedBlock> blocksToRestore = new ConcurrentHashMap<class_2338, TimedBlock>();
    private final Map<class_2338, class_2338> currentToOriginal = new ConcurrentHashMap<class_2338, class_2338>();

    public static RestoreManager get() {
        return INSTANCE;
    }

    private RestoreManager() {
    }

    public boolean isBusy(class_2338 originalPos) {
        return this.blocksToRestore.containsKey(originalPos);
    }

    public TimedBlock getTimed(class_2338 original) {
        return this.blocksToRestore.get(original);
    }

    public class_2338 resolveOriginal(class_2338 clicked) {
        return this.currentToOriginal.getOrDefault(clicked, clicked);
    }

    public void forgetAlias(class_2338 current) {
        this.currentToOriginal.remove(current);
    }

    public void addTimed(class_2338 originalPos, class_2680 originalState, int seconds) {
        this.blocksToRestore.put(originalPos, new TimedBlock(originalState, seconds * 20, null));
    }

    public void registerMove(class_2338 originalPos, class_2338 movedTo, class_2680 state, int seconds) {
        TimedBlock tb = this.blocksToRestore.get(originalPos);
        if (tb != null) {
            tb.movedTo = movedTo;
            tb.ticksLeft = seconds * 20;
        } else {
            tb = new TimedBlock(state, seconds * 20, movedTo);
            this.blocksToRestore.put(originalPos, tb);
        }
        this.currentToOriginal.put(movedTo, originalPos);
    }

    public void tick(class_3218 world) {
        this.blocksToRestore.entrySet().removeIf(entry -> {
            class_2338 originalPos = (class_2338)entry.getKey();
            TimedBlock tb = (TimedBlock)entry.getValue();
            --tb.ticksLeft;
            if (tb.ticksLeft > 0) {
                return false;
            }
            if (tb.fallingEntity != null && tb.fallingEntity.method_5805()) {
                tb.fallingEntity.method_31472();
            }
            if (tb.movedTo != null && !tb.movedTo.equals((Object)originalPos)) {
                class_2338 moved = tb.movedTo;
                class_2680 stateAtMoved = world.method_8320(moved);
                if (stateAtMoved.method_27852(tb.blockState.method_26204())) {
                    world.method_8501(moved, class_2246.field_10124.method_9564());
                    this.currentToOriginal.remove(moved);
                } else {
                    int maxSearch = 64;
                    class_2338 scan = moved.method_10074();
                    for (int steps = 0; scan.method_10264() >= world.method_31607() && steps < 64; ++steps) {
                        class_2680 s = world.method_8320(scan);
                        if (s.method_27852(tb.blockState.method_26204())) {
                            world.method_8501(scan, class_2246.field_10124.method_9564());
                            this.currentToOriginal.remove(scan);
                            break;
                        }
                        scan = scan.method_10074();
                    }
                    this.currentToOriginal.remove(moved);
                }
            }
            world.method_8501(originalPos, tb.blockState);
            this.currentToOriginal.remove(originalPos);
            LOGGER.info("Block restored at {}", (Object)originalPos);
            return true;
        });
    }

    public static class TimedBlock {
        public final class_2680 blockState;
        public class_2338 movedTo;
        public int ticksLeft;
        public class_1540 fallingEntity;

        public TimedBlock(class_2680 blockState, int ticksLeft, class_2338 movedTo) {
            this.blockState = blockState;
            this.ticksLeft = ticksLeft;
            this.movedTo = movedTo;
        }
    }
}

