/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.khataly.mapkit.networking.manager;

import com.cobblemon.khataly.mapkit.networking.packet.RotatePlayerS2CPacket;
import com.cobblemon.khataly.mapkit.sound.ModSounds;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_5321;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;

public final class TeleportAnimationManager {
    private static final int ANIM_TICKS = 20;
    private static final double LIFT_Y = 0.004;
    private static final float TOTAL_ROT_DEG = 160.0f;
    private static final int ARRIVAL_SUPPRESS_TICKS = 6;
    private static final Map<UUID, Pending> PENDING = new HashMap<UUID, Pending>();
    private static final Map<UUID, Long> LAST_ARRIVAL_TICK = new HashMap<UUID, Long>();
    private static final Map<UUID, Loc> ARRIVAL_SUPPRESS_WHILE_ON_BLOCK = new HashMap<UUID, Loc>();

    private TeleportAnimationManager() {
    }

    public static void register() {
        ServerTickEvents.END_SERVER_TICK.register(TeleportAnimationManager::tick);
    }

    public static boolean shouldIgnoreStep(class_3222 player, class_3218 world, class_2338 pos) {
        long now = world.method_8510();
        Long last = LAST_ARRIVAL_TICK.get(player.method_5667());
        if (last != null && now - last < 6L) {
            return true;
        }
        Loc loc = ARRIVAL_SUPPRESS_WHILE_ON_BLOCK.get(player.method_5667());
        return loc != null && loc.dim.equals((Object)world.method_27983()) && loc.block.equals((Object)pos);
    }

    public static void queueTeleport(class_3222 player, class_3218 targetWorld, class_2338 targetPos) {
        UUID pid = player.method_5667();
        if (PENDING.containsKey(pid)) {
            return;
        }
        class_243 v = player.method_18798();
        player.method_18800(v.field_1352, 0.0, v.field_1350);
        player.field_6037 = true;
        long now = player.method_51469().method_8510();
        PENDING.put(pid, new Pending(targetWorld, targetPos, now));
        player.method_51469().method_8396(null, player.method_24515(), ModSounds.TELEPORT_BLOCK, class_3419.field_15248, 1.0f, 1.0f);
        ServerPlayNetworking.send((class_3222)player, (class_8710)new RotatePlayerS2CPacket(160.0f, 20));
    }

    private static void tick(MinecraftServer server) {
        if (!PENDING.isEmpty()) {
            ArrayList<UUID> done = new ArrayList<UUID>();
            for (Map.Entry<UUID, Record> entry : PENDING.entrySet()) {
                UUID id = entry.getKey();
                Pending pending = (Pending)entry.getValue();
                class_3222 player = server.method_3760().method_14602(id);
                if (player == null) {
                    done.add(id);
                    continue;
                }
                long now = player.method_51469().method_8510();
                long elapsed = now - pending.startTick;
                if (TeleportAnimationManager.playerHitCeiling(player)) {
                    TeleportAnimationManager.doTeleport(player, pending.targetWorld, pending.targetPos);
                    done.add(id);
                    continue;
                }
                if (elapsed < 20L) {
                    TeleportAnimationManager.animateLift(player);
                    continue;
                }
                TeleportAnimationManager.doTeleport(player, pending.targetWorld, pending.targetPos);
                done.add(id);
            }
            done.forEach(PENDING::remove);
        }
        if (!ARRIVAL_SUPPRESS_WHILE_ON_BLOCK.isEmpty()) {
            ArrayList<UUID> clear = new ArrayList<UUID>();
            for (Map.Entry<UUID, Record> entry : ARRIVAL_SUPPRESS_WHILE_ON_BLOCK.entrySet()) {
                UUID pid = entry.getKey();
                Loc loc = (Loc)entry.getValue();
                class_3222 pl = server.method_3760().method_14602(pid);
                if (pl == null) {
                    clear.add(pid);
                    continue;
                }
                if (!pl.method_51469().method_27983().equals(loc.dim)) {
                    clear.add(pid);
                    continue;
                }
                class_2338 belowFeet = pl.method_24515().method_10074();
                if (belowFeet.equals((Object)loc.block)) continue;
                clear.add(pid);
            }
            clear.forEach(ARRIVAL_SUPPRESS_WHILE_ON_BLOCK::remove);
        }
    }

    private static void animateLift(class_3222 player) {
        class_243 v = player.method_18798();
        player.method_18800(v.field_1352, 0.004, v.field_1350);
        player.field_6017 = 0.0f;
        player.field_6037 = true;
        class_3218 w = player.method_51469();
        w.method_14199((class_2394)class_2398.field_11214, player.method_23317(), player.method_23318() + 0.5, player.method_23321(), 8, 0.15, 0.25, 0.15, 0.0);
    }

    private static void doTeleport(class_3222 player, class_3218 targetWorld, class_2338 base) {
        class_2338 safeFeet = TeleportAnimationManager.findSafeLandingAbove(targetWorld, base);
        double tx = (double)safeFeet.method_10263() + 0.5;
        double ty = safeFeet.method_10264();
        double tz = (double)safeFeet.method_10260() + 0.5;
        player.method_18800(0.0, 0.0, 0.0);
        player.field_6037 = true;
        player.method_14251(targetWorld, tx, ty, tz, player.method_36454(), player.method_36455());
        LAST_ARRIVAL_TICK.put(player.method_5667(), targetWorld.method_8510());
        ARRIVAL_SUPPRESS_WHILE_ON_BLOCK.put(player.method_5667(), new Loc((class_5321<class_1937>)targetWorld.method_27983(), base));
        targetWorld.method_14199((class_2394)class_2398.field_23190, tx, ty + 0.5, tz, 25, 0.4, 0.4, 0.4, 0.0);
    }

    private static boolean playerHitCeiling(class_3222 player) {
        class_2338 head = player.method_24515().method_10084();
        return !player.method_37908().method_8320(head).method_26215();
    }

    private static class_2338 findSafeLandingAbove(class_3218 world, class_2338 base) {
        int x = base.method_10263();
        int z = base.method_10260();
        int startY = Math.max(base.method_10264() + 1, world.method_31607() + 1);
        int heightmapY = world.method_8624(class_2902.class_2903.field_13203, x, z);
        int maxY = Math.min(world.method_31600(), heightmapY + 6);
        for (int feetY = startY; feetY <= maxY; ++feetY) {
            boolean canStand;
            class_2338 feet = new class_2338(x, feetY, z);
            class_2338 head = feet.method_10084();
            class_2338 below = feet.method_10074();
            class_2680 feetState = world.method_8320(feet);
            class_2680 headState = world.method_8320(head);
            class_2680 belowState = world.method_8320(below);
            boolean spaceFree = feetState.method_26215() && headState.method_26215();
            boolean bl = canStand = belowState.method_26216((class_1922)world, below) || belowState.method_26206((class_1922)world, below, class_2350.field_11036);
            if (!spaceFree || !canStand) continue;
            return feet;
        }
        return base.method_10086(1);
    }

    private record Loc(class_5321<class_1937> dim, class_2338 block) {
    }

    private record Pending(class_3218 targetWorld, class_2338 targetPos, long startTick) {
    }
}

