/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.khataly.mapkit.screen.custom;

import com.cobblemon.khataly.mapkit.networking.packet.badgebox.EjectBadgeC2SPacket;
import com.cobblemon.khataly.mapkit.networking.packet.badgebox.PolishBadgeC2SPacket;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1268;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_7833;
import net.minecraft.class_7923;
import net.minecraft.class_8710;

public class BadgeCaseScreen
extends class_437 {
    private static final int GOLD_LIGHT = -795228;
    private static final int GOLD_BASE = -2047894;
    private static final int GOLD_DARK = -9809376;
    private static final int CREAM_SOLID = -594212;
    private static final int SHADOW_30 = 0x4D000000;
    private static final int SHADOW_50 = Integer.MIN_VALUE;
    private static final class_2960 BG_TEX = class_2960.method_60655((String)"mapkit", (String)"textures/gui/badge_case.png");
    private List<class_1799> badges;
    private List<Integer> shines;
    private int total;
    private final int panelW = 256;
    private final int panelH = 160;
    private int left;
    private int top;
    private final int rows = 2;
    private final int cols = 4;
    private final float itemScale = 1.8f;
    private final int slotSize = 40;
    private static final double POLISH_PIXELS_PER_SHINE = 110.0;
    private static final long POLISH_PACKET_COOLDOWN_MS = 95L;
    private static final int POLISH_PACKET_AMOUNT = 1;
    private int polishingSlot = -1;
    private double lastX;
    private double lastY;
    private long lastPolishSoundMs = 0L;
    private final List<Double> polishAccum = new ArrayList<Double>();
    private final List<Long> lastPacketSentMs = new ArrayList<Long>();
    private final List<Float> polishHeat = new ArrayList<Float>();
    private final List<Long> lastEmitMs = new ArrayList<Long>();
    private class_2960 pendingAnimId = null;
    private CinematicInsert cinematic = null;
    private long screenShakeUntil = 0L;
    private final Random rnd = new Random();
    private final List<Spark> sparks = new ArrayList<Spark>();

    public BadgeCaseScreen(class_1268 handUsed, List<class_1799> badges, List<Integer> shines, int total) {
        super((class_2561)class_2561.method_43471((String)"item.mapkit.badge_case"));
        this.badges = new ArrayList<class_1799>(badges);
        this.shines = new ArrayList<Integer>(shines);
        this.total = Math.max(total, badges.size());
        this.ensurePerSlotArrays();
    }

    public void method_25393() {
        class_315 opts = class_310.method_1551().field_1690;
        opts.field_1886.method_23481(false);
        opts.field_1904.method_23481(false);
        super.method_25393();
    }

    public void queueInsertAnimation(class_2960 badgeId) {
        this.pendingAnimId = badgeId;
    }

    protected void method_25426() {
        super.method_25426();
        this.left = (this.field_22789 - 256) / 2;
        this.top = (this.field_22790 - 160) / 2;
        if (this.pendingAnimId != null) {
            this.startCinematicInsert(this.pendingAnimId);
            this.pendingAnimId = null;
        }
    }

    public boolean method_25421() {
        return false;
    }

    private int gridStartX() {
        return this.left + 48;
    }

    private int gridStartY() {
        return this.top + 40 + 8;
    }

    private int[] slotBounds(int idx) {
        int r = idx / 4;
        int c = idx % 4;
        int x0 = this.gridStartX() + c * 40;
        int y0 = this.gridStartY() + r * 40;
        return new int[]{x0, y0, x0 + 40, y0 + 40};
    }

    private int[] itemDrawPos(int idx) {
        int[] b = this.slotBounds(idx);
        int itemPx = Math.round(28.8f);
        int x = b[0] + (40 - itemPx) / 2;
        int y = b[1] + (40 - itemPx) / 2;
        return new int[]{x, y};
    }

    private int indexOfBadgeId(class_2960 id) {
        for (int i = 0; i < this.badges.size(); ++i) {
            if (!class_7923.field_41178.method_10221((Object)this.badges.get(i).method_7909()).equals((Object)id)) continue;
            return i;
        }
        return -1;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.cinematic != null) {
            return true;
        }
        int idx = this.hoveredSlotIndex((int)mouseX, (int)mouseY);
        if (button == 1 && BadgeCaseScreen.method_25442() && idx >= 0 && idx < this.badges.size() && !this.badges.get(idx).method_7960()) {
            class_2960 id = class_7923.field_41178.method_10221((Object)this.badges.get(idx).method_7909());
            ClientPlayNetworking.send((class_8710)new EjectBadgeC2SPacket(id));
            return true;
        }
        if (button == 0 && idx >= 0 && idx < this.badges.size() && !this.badges.get(idx).method_7960()) {
            this.polishingSlot = idx;
            this.lastX = mouseX;
            this.lastY = mouseY;
            return true;
        }
        if (button == 0 && (mouseX < (double)this.left || mouseX > (double)(this.left + 256) || mouseY < (double)this.top || mouseY > (double)(this.top + 160))) {
            this.method_25419();
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dx, double dy) {
        if (this.cinematic != null) {
            return true;
        }
        if (button == 0 && this.polishingSlot >= 0 && this.polishingSlot < this.badges.size()) {
            double dxl = mouseX - this.lastX;
            double dyl = mouseY - this.lastY;
            double dist = Math.hypot(dxl, dyl);
            this.lastX = mouseX;
            this.lastY = mouseY;
            double acc = this.polishAccum.get(this.polishingSlot) + dist;
            long now = System.currentTimeMillis();
            long lastPkt = this.lastPacketSentMs.get(this.polishingSlot);
            while (acc >= 110.0 && now - lastPkt >= 95L) {
                int curr;
                acc -= 110.0;
                class_2960 id = class_7923.field_41178.method_10221((Object)this.badges.get(this.polishingSlot).method_7909());
                ClientPlayNetworking.send((class_8710)new PolishBadgeC2SPacket(id, 1));
                this.lastPacketSentMs.set(this.polishingSlot, now);
                if (now - this.lastPolishSoundMs > 150L && class_310.method_1551().field_1724 != null) {
                    class_310.method_1551().field_1724.method_5783(class_3417.field_43155, 1.5f, 1.1f);
                    this.lastPolishSoundMs = now;
                }
                int n = curr = this.polishingSlot < this.shines.size() ? this.shines.get(this.polishingSlot) : 0;
                if (this.polishingSlot < this.shines.size()) {
                    this.shines.set(this.polishingSlot, Math.min(100, curr + 1));
                }
                float heat = Math.min(1.0f, this.polishHeat.get(this.polishingSlot).floatValue() + 0.25f);
                this.polishHeat.set(this.polishingSlot, Float.valueOf(heat));
                this.spawnSlotSparks(this.polishingSlot, 3);
                now = System.currentTimeMillis();
                lastPkt = this.lastPacketSentMs.get(this.polishingSlot);
            }
            float heat = Math.min(1.0f, this.polishHeat.get(this.polishingSlot).floatValue() + (float)(dist / 120.0));
            this.polishHeat.set(this.polishingSlot, Float.valueOf(heat));
            this.polishAccum.set(this.polishingSlot, acc);
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, dx, dy);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.polishingSlot = -1;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    private int hoveredSlotIndex(int mx, int my) {
        for (int i = 0; i < 8; ++i) {
            int[] b = this.slotBounds(i);
            if (mx < b[0] || mx >= b[2] || my < b[1] || my >= b[3]) continue;
            return i;
        }
        return -1;
    }

    public void applySync(List<class_1799> newBadges, List<Integer> newShines, int total) {
        this.badges = new ArrayList<class_1799>(newBadges);
        this.shines = new ArrayList<Integer>(newShines);
        this.total = Math.max(total, newBadges.size());
        this.ensurePerSlotArrays();
    }

    private void startCinematicInsert(class_2960 badgeId) {
        int idx = this.indexOfBadgeId(badgeId);
        if (idx < 0 || idx >= this.badges.size()) {
            return;
        }
        class_1799 st = this.badges.get(idx).method_7972();
        if (st.method_7960()) {
            return;
        }
        int[] pos = this.itemDrawPos(idx);
        int targetX = pos[0];
        int targetY = pos[1];
        float giantScale = 3.4f;
        int giantPx = Math.round(16.0f * giantScale);
        int centerX = this.left + (256 - giantPx) / 2;
        int centerY = this.top + (160 - giantPx) / 2 - 6;
        this.cinematic = new CinematicInsert(st, idx, centerX, centerY, giantScale, targetX, targetY);
        if (this.field_22787 != null && this.field_22787.field_1724 != null) {
            this.field_22787.field_1724.method_5783(class_3417.field_15195, 0.6f, 1.0f);
        }
    }

    public void method_25394(class_332 ctx, int mouseX, int mouseY, float delta) {
        int i;
        long now = System.currentTimeMillis();
        ctx.method_51448().method_22903();
        if (now < this.screenShakeUntil) {
            float sx = (this.rnd.nextFloat() - 0.5f) * 2.0f;
            float sy = (this.rnd.nextFloat() - 0.5f) * 2.0f;
            ctx.method_51448().method_46416(sx, sy, 0.0f);
        }
        if (class_310.method_1551().method_1478().method_14486(BG_TEX).isPresent()) {
            ctx.method_25290(BG_TEX, this.left, this.top, 0.0f, 0.0f, 256, 160, 256, 160);
        } else {
            ctx.method_25294(this.left, this.top, this.left + 256, this.top + 160, -870441442);
            ctx.method_25294(this.left + 3, this.top + 3, this.left + 256 - 3, this.top + 160 - 3, -14013910);
        }
        this.drawGoldTitle(ctx, (class_2561)class_2561.method_43471((String)"item.mapkit.badge_case"));
        for (i = 0; i < 8; ++i) {
            int[] b = this.slotBounds(i);
            ctx.method_25294(b[0], b[1], b[2], b[3], 0x22000000);
            ctx.method_25294(b[0] + 1, b[1] + 1, b[2] - 1, b[3] - 1, 0x22000000);
        }
        for (i = 0; i < Math.min(this.badges.size(), 8); ++i) {
            long interval;
            long last;
            float heat = this.polishHeat.get(i).floatValue();
            float dt = delta <= 0.0f ? 0.016666668f : delta / 20.0f;
            heat = Math.max(0.0f, heat - dt * 0.8f);
            this.polishHeat.set(i, Float.valueOf(heat));
            if (!(heat > 0.0f) || now - (last = this.lastEmitMs.get(i).longValue()) < (interval = (long)(220.0f - 170.0f * heat))) continue;
            int bursts = 1 + (heat > 0.5f ? 1 : 0);
            int shine = i < this.shines.size() ? this.shines.get(i) : 0;
            ShineTier tier = this.tierFor(shine);
            if (tier == ShineTier.T3) {
                ++bursts;
            }
            if (tier == ShineTier.T4) {
                bursts += 2;
            }
            this.spawnSlotSparks(i, bursts);
            this.lastEmitMs.set(i, now);
        }
        int itemPx = Math.round(28.8f);
        for (int i2 = 0; i2 < Math.min(this.badges.size(), 8); ++i2) {
            int shine;
            class_1799 st = this.badges.get(i2);
            if (st.method_7960()) continue;
            int[] p = this.itemDrawPos(i2);
            if (this.cinematic != null && i2 == this.cinematic.slotIndex) continue;
            if (this.polishHeat.get(i2).floatValue() > 0.0f) {
                int cx = p[0] + itemPx / 2;
                int cy = p[1] + itemPx / 2;
                this.drawSoftDisc(ctx, cx, cy, (int)((float)itemPx * 0.6f), 0x22000000);
            }
            this.drawItemScaled(ctx, st, p[0], p[1]);
            int n = shine = i2 < this.shines.size() ? this.shines.get(i2) : 0;
            if (shine <= 0) continue;
            this.drawStarsLeveled(ctx, p[0], p[1], itemPx, shine);
        }
        if (this.cinematic != null && !this.cinematic.render(ctx)) {
            int finishedSlot = this.cinematic.slotIndex;
            this.cinematic = null;
            this.spawnSlotSparks(finishedSlot, 10);
            this.screenShakeUntil = System.currentTimeMillis() + 180L;
            if (this.field_22787 != null && this.field_22787.field_1724 != null) {
                this.field_22787.field_1724.method_5783(class_3417.field_34376, 0.9f, 1.1f);
            }
        }
        this.renderSparks(ctx);
        int hov = this.hoveredSlotIndex(mouseX, mouseY);
        if (hov >= 0 && hov < this.badges.size() && !this.badges.get(hov).method_7960() && this.cinematic == null) {
            class_1799 stack = this.badges.get(hov);
            assert (this.field_22787 != null);
            ArrayList<class_5250> lines = new ArrayList<class_5250>(BadgeCaseScreen.method_25408((class_310)this.field_22787, (class_1799)stack));
            lines.add(class_2561.method_43471((String)"tooltip.mapkit.badge_case.remove_hint"));
            lines.add(class_2561.method_43471((String)"tooltip.mapkit.badge_case.polish_hint"));
            ctx.method_51434(this.field_22793, lines, mouseX, mouseY);
        }
        ctx.method_51448().method_22909();
        super.method_25394(ctx, mouseX, mouseY, delta);
    }

    public void method_25420(class_332 context, int mouseX, int mouseY, float delta) {
    }

    private void drawItemScaled(class_332 ctx, class_1799 st, int x, int y) {
        ctx.method_51448().method_22903();
        ctx.method_51448().method_22905(1.8f, 1.8f, 1.0f);
        int dx = Math.round((float)x / 1.8f);
        int dy = Math.round((float)y / 1.8f);
        ctx.method_51427(st, dx, dy);
        ctx.method_51431(this.field_22793, st, dx, dy);
        ctx.method_51448().method_22909();
    }

    private void drawGoldTitle(class_332 ctx, class_2561 title) {
        int sideMargin = 40;
        int barW = 176;
        int barH = 22;
        int barX = this.left + 40;
        int barY = this.top + 6;
        ctx.method_51448().method_22903();
        ctx.method_51448().method_46416(0.0f, 0.0f, 200.0f);
        ctx.method_25294(barX + 2, barY + 3, barX + 176 + 2, barY + 22 + 3, 0x4D000000);
        ctx.method_25294(barX, barY, barX + 176, barY + 22, -594212);
        ctx.method_25294(barX, barY, barX + 176, barY + 1, -9809376);
        ctx.method_25294(barX, barY + 22 - 1, barX + 176, barY + 22, -9809376);
        ctx.method_25294(barX, barY, barX + 1, barY + 22, -9809376);
        ctx.method_25294(barX + 176 - 1, barY, barX + 176, barY + 22, -9809376);
        ctx.method_25294(barX + 1, barY + 1, barX + 176 - 1, barY + 2, -795228);
        ctx.method_25294(barX + 1, barY + 22 - 2, barX + 176 - 1, barY + 22 - 1, -2047894);
        String s = title.getString();
        int tw = this.field_22793.method_1727(s);
        int tx = barX + (176 - tw) / 2;
        int ty = barY + 7;
        ctx.method_51433(this.field_22793, s, tx + 1, ty + 1, Integer.MIN_VALUE, false);
        ctx.method_51433(this.field_22793, s, tx - 1, ty, -9809376, false);
        ctx.method_51433(this.field_22793, s, tx + 1, ty, -9809376, false);
        ctx.method_51433(this.field_22793, s, tx, ty - 1, -9809376, false);
        ctx.method_51433(this.field_22793, s, tx, ty + 1, -9809376, false);
        ctx.method_51433(this.field_22793, s, tx, ty, -2047894, false);
        long t = System.currentTimeMillis() / 120L;
        boolean blink = t % 2L == 0L;
        int decoY = ty - 1;
        int gap = 8;
        int leftStarX = tx - gap - this.field_22793.method_1727("\u2726");
        int rightStarX = tx + tw + gap;
        int starColor = blink ? -795228 : -2047894;
        ctx.method_51433(this.field_22793, "\u2726", leftStarX, decoY, starColor, false);
        ctx.method_51433(this.field_22793, "\u2726", rightStarX, decoY, starColor, false);
        ctx.method_51448().method_22909();
    }

    private void drawStarsLeveled(class_332 ctx, int x, int y, int size, int shine) {
        int level;
        int n = shine < 25 ? 0 : (shine < 50 ? 1 : (shine < 75 ? 2 : (level = shine < 90 ? 3 : 4)));
        if (level == 0) {
            return;
        }
        int baseCount = switch (level) {
            case 1 -> 2;
            case 2 -> 3;
            case 3 -> 4;
            default -> 6;
        };
        int extraFromShine = Math.max(0, (shine - 25) / 15);
        int stars = Math.min(10, baseCount + extraFromShine);
        int color = switch (level) {
            case 1 -> -1116161;
            case 2 -> -1;
            case 3 -> -7264;
            default -> -14262;
        };
        int alpha = 200;
        int argb = alpha << 24 | color & 0xFFFFFF;
        long tick = System.currentTimeMillis() / 100L;
        for (int i = 0; i < stars; ++i) {
            if ((tick + (long)i) % 3L != 0L) continue;
            int sx = x + 3 + this.rnd.nextInt(Math.max(1, size - 6));
            int sy = y + 3 + this.rnd.nextInt(Math.max(1, size - 6));
            int r = level >= 4 ? 2 : (level >= 3 ? 2 : 1);
            this.drawStar5(ctx, sx, sy, r, argb);
        }
    }

    private ShineTier tierFor(int shine) {
        if (shine < 25) {
            return ShineTier.T0;
        }
        if (shine < 50) {
            return ShineTier.T1;
        }
        if (shine < 75) {
            return ShineTier.T2;
        }
        if (shine < 90) {
            return ShineTier.T3;
        }
        return ShineTier.T4;
    }

    private int tierColor(ShineTier t) {
        return switch (t.ordinal()) {
            case 1 -> 0xEEF7FF;
            case 2 -> 0xFFFFFF;
            case 3 -> 16769952;
            case 4 -> 16762954;
            default -> 0xFFFFFF;
        };
    }

    private int tierSize(ShineTier t) {
        return switch (t.ordinal()) {
            case 1 -> 1;
            case 2 -> 2;
            case 3 -> 2;
            case 4 -> 3;
            default -> 1;
        };
    }

    private int tierAlpha(ShineTier t) {
        return switch (t.ordinal()) {
            case 1 -> 140;
            case 2 -> 190;
            case 3 -> 220;
            case 4 -> 255;
            default -> 120;
        };
    }

    private void spawnSlotSparks(int slotIndex, int count) {
        int toRemove;
        int[] p = this.itemDrawPos(slotIndex);
        int size = Math.round(28.8f);
        int shine = slotIndex < this.shines.size() ? this.shines.get(slotIndex) : 0;
        ShineTier tier = this.tierFor(shine);
        int color = this.tierColor(tier);
        int alpha = this.tierAlpha(tier);
        int baseSize = this.tierSize(tier);
        if (this.sparks.size() > 800 && (toRemove = this.sparks.size() - 800 + count * 2) > 0) {
            this.sparks.subList(0, Math.min(toRemove, this.sparks.size())).clear();
        }
        for (int i = 0; i < count; ++i) {
            float cx = (float)p[0] + (float)size / 2.0f + (this.rnd.nextFloat() - 0.5f) * ((float)size * 0.35f);
            float cy = (float)p[1] + (float)size / 2.0f + (this.rnd.nextFloat() - 0.5f) * ((float)size * 0.35f);
            int s = baseSize + this.rnd.nextInt(2);
            this.sparks.add(Spark.create(cx, cy, color, alpha, s));
        }
    }

    private void renderSparks(class_332 ctx) {
        long now = System.currentTimeMillis();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)1);
        this.sparks.removeIf(s -> {
            float t = (float)(now - s.t0) / (float)s.lifeMs;
            if (t >= 1.0f) {
                return true;
            }
            float fade = 1.0f - t;
            float pulse = 0.9f + 0.3f * (float)Math.sin((double)(now - s.t0) * 0.02);
            float x = s.x + s.vx * t;
            float y = s.y + s.vy * t + 0.5f * s.g * t * t;
            int a = Math.min(255, Math.max(0, (int)(fade * (float)s.alpha)));
            int argb = a << 24 | s.color & 0xFFFFFF;
            this.drawStar5(ctx, (int)x, (int)y, (int)((float)s.size * pulse), argb);
            return false;
        });
        RenderSystem.blendFunc((int)770, (int)771);
        RenderSystem.disableBlend();
    }

    private void drawStar5(class_332 ctx, int cx, int cy, int size, int argb) {
        int r = Math.max(1, size);
        ctx.method_25294(cx - r, cy, cx + r + 1, cy + 1, argb);
        ctx.method_25294(cx, cy - r, cx + 1, cy + r + 1, argb);
        for (int i = -r; i <= r; ++i) {
            ctx.method_25294(cx + i, cy + i, cx + i + 1, cy + i + 1, argb);
            ctx.method_25294(cx + i, cy - i, cx + i + 1, cy - i + 1, argb);
        }
    }

    private void drawSoftDisc(class_332 ctx, int cx, int cy, int radius, int argb) {
        int r2 = radius * radius;
        for (int y = -radius; y <= radius; ++y) {
            int yy = y * y;
            for (int x = -radius; x <= radius; ++x) {
                if (x * x + yy > r2) continue;
                ctx.method_25294(cx + x, cy + y, cx + x + 1, cy + y + 1, argb);
            }
        }
    }

    private static float easeOutCubic(float t) {
        return 1.0f - (float)Math.pow(1.0f - t, 3.0);
    }

    private static float easeInOutCubic(float t) {
        return t < 0.5f ? 4.0f * t * t * t : 1.0f - (float)Math.pow(-2.0f * t + 2.0f, 3.0) / 2.0f;
    }

    private void drawItemAt(class_332 ctx, class_1799 st, float x, float y, float scale, float rotZ) {
        ctx.method_51448().method_22903();
        ctx.method_51448().method_46416(x, y, 300.0f);
        ctx.method_51448().method_46416(8.0f, 8.0f, 0.0f);
        ctx.method_51448().method_22907(class_7833.field_40718.rotation(rotZ));
        ctx.method_51448().method_22905(scale, scale, 1.0f);
        ctx.method_51448().method_46416(-8.0f, -8.0f, 0.0f);
        ctx.method_51427(st, 0, 0);
        ctx.method_51431(this.field_22793, st, 0, 0);
        ctx.method_51448().method_22909();
    }

    private void ensurePerSlotArrays() {
        int n = this.badges.size();
        while (this.polishAccum.size() < n) {
            this.polishAccum.add(0.0);
        }
        while (this.lastPacketSentMs.size() < n) {
            this.lastPacketSentMs.add(0L);
        }
        while (this.polishHeat.size() < n) {
            this.polishHeat.add(Float.valueOf(0.0f));
        }
        while (this.lastEmitMs.size() < n) {
            this.lastEmitMs.add(0L);
        }
        if (this.polishAccum.size() > n) {
            this.polishAccum.subList(n, this.polishAccum.size()).clear();
        }
        if (this.lastPacketSentMs.size() > n) {
            this.lastPacketSentMs.subList(n, this.lastPacketSentMs.size()).clear();
        }
        if (this.polishHeat.size() > n) {
            this.polishHeat.subList(n, this.polishHeat.size()).clear();
        }
        if (this.lastEmitMs.size() > n) {
            this.lastEmitMs.subList(n, this.lastEmitMs.size()).clear();
        }
    }

    private class CinematicInsert {
        final class_1799 stack;
        final int slotIndex;
        final int targetX;
        final int targetY;
        final int centerX;
        final int centerY;
        final float bigScale;
        final long tStart = System.currentTimeMillis();
        final long dIn = 250L;
        final long dSpin = 300L;
        final long dOut = 320L;

        CinematicInsert(class_1799 st, int slotIndex, int centerX, int centerY, float bigScale, int targetX, int targetY) {
            this.stack = st;
            this.slotIndex = slotIndex;
            this.centerX = centerX;
            this.centerY = centerY;
            this.bigScale = bigScale;
            this.targetX = targetX;
            this.targetY = targetY;
        }

        boolean render(class_332 ctx) {
            long now = System.currentTimeMillis();
            long dt = now - this.tStart;
            if (dt <= 250L) {
                float t = BadgeCaseScreen.easeOutCubic((float)dt / 250.0f);
                float startX = (float)BadgeCaseScreen.this.left + 128.0f - 8.0f;
                float startY = BadgeCaseScreen.this.top + 160 + 24;
                float x = this.lerp(startX, this.centerX, t);
                float y = this.lerp(startY, this.centerY, t);
                float s = this.lerp(1.8f, this.bigScale, t);
                float rot = (float)Math.toRadians(20.0f * t);
                BadgeCaseScreen.this.drawItemAt(ctx, this.stack, x, y, s, rot);
                return true;
            }
            if (dt <= 550L) {
                float t = BadgeCaseScreen.easeInOutCubic((float)(dt - 250L) / 300.0f);
                float rot = (float)Math.toRadians(720.0f * t);
                BadgeCaseScreen.this.drawItemAt(ctx, this.stack, this.centerX, this.centerY, this.bigScale, rot);
                return true;
            }
            if (dt <= 870L) {
                float t = BadgeCaseScreen.easeOutCubic((float)(dt - 250L - 300L) / 320.0f);
                float cx = (float)(this.centerX + this.targetX) / 2.0f;
                float cy = Math.min(this.centerY, this.targetY) - 30;
                float[] p = this.quadBezier(this.centerX, this.centerY, cx, cy, this.targetX, this.targetY, t);
                float x = p[0];
                float y = p[1];
                float s = this.lerp(this.bigScale, 1.8f, t);
                float rot = (float)Math.toRadians(45.0f * (1.0f - t));
                BadgeCaseScreen.this.drawItemAt(ctx, this.stack, x, y, s, rot);
                if (t > 0.95f && now - BadgeCaseScreen.this.screenShakeUntil > 300L) {
                    BadgeCaseScreen.this.spawnSlotSparks(this.slotIndex, 6);
                    BadgeCaseScreen.this.screenShakeUntil = now + 140L;
                }
                return true;
            }
            return false;
        }

        private float lerp(float a, float b, float t) {
            return a + (b - a) * t;
        }

        private float[] quadBezier(float x0, float y0, float cx, float cy, float x1, float y1, float t) {
            float u = 1.0f - t;
            float x = u * u * x0 + 2.0f * u * t * cx + t * t * x1;
            float y = u * u * y0 + 2.0f * u * t * cy + t * t * y1;
            return new float[]{x, y};
        }
    }

    private static enum ShineTier {
        T0,
        T1,
        T2,
        T3,
        T4;

    }

    private static class Spark {
        final float x;
        final float y;
        final float vx;
        final float vy;
        final float g;
        final long t0;
        final long lifeMs;
        final int color;
        final int alpha;
        final int size;

        private Spark(float x, float y, float vx, float vy, float g, long lifeMs, int color, int alpha, int size) {
            this.x = x;
            this.y = y;
            this.vx = vx;
            this.vy = vy;
            this.g = g;
            this.lifeMs = lifeMs;
            this.t0 = System.currentTimeMillis();
            this.color = color;
            this.alpha = alpha;
            this.size = size;
        }

        static Spark create(float x, float y, int color, int alpha, int size) {
            Random r = new Random();
            float ang = (float)((double)r.nextFloat() * Math.PI * 2.0);
            float spd = 2.4f + r.nextFloat() * 3.1f;
            float upKick = 0.8f + r.nextFloat() * 0.6f;
            float vx = (float)Math.cos(ang) * spd;
            float vy = (float)Math.sin(ang) * spd - upKick;
            float g = 0.85f;
            long life = 600 + r.nextInt(400);
            return new Spark(x, y, vx, vy, g, life, color, alpha, size);
        }
    }
}

