/*
 * Decompiled with CFR 0.152.
 */
package com.npcportals;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.EulerAngle;

public class NPCPortalsPlugin
extends JavaPlugin
implements Listener {
    private Map<UUID, ArmorStand> npcs = new HashMap<UUID, ArmorStand>();
    private Map<UUID, String> npcNames = new HashMap<UUID, String>();
    private Map<UUID, Location> npcLocations = new HashMap<UUID, Location>();
    private Set<UUID> loadingNPCs = new HashSet<UUID>();
    private String guiTitle;
    private String prefix;
    private NamespacedKey npcKey;

    public void onEnable() {
        this.npcKey = new NamespacedKey((Plugin)this, "npc-id");
        this.saveDefaultConfig();
        this.loadConfiguration();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        new BukkitRunnable(){

            public void run() {
                NPCPortalsPlugin.this.loadNPCs();
                NPCPortalsPlugin.this.getLogger().info("Loaded " + NPCPortalsPlugin.this.npcs.size() + " NPCs from configuration.");
                NPCPortalsPlugin.this.verifyAndCleanupExistingNPCs();
            }
        }.runTaskLater((Plugin)this, 20L);
        this.getLogger().info("NPC Teleport plugin has been enabled!");
    }

    public void onDisable() {
        this.npcs.clear();
        this.npcNames.clear();
        this.npcLocations.clear();
        this.loadingNPCs.clear();
        this.getLogger().info("NPC Teleport plugin has been disabled!");
    }

    private void loadConfiguration() {
        this.guiTitle = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("gui.title", "&6NPC Teleportation"));
        this.prefix = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("messages.prefix", "&7[&6NPC Portals&7] "));
    }

    private void verifyAndCleanupExistingNPCs() {
        HashSet<UUID> configuredNPCs = new HashSet<UUID>();
        ConfigurationSection npcsSection = this.getConfig().getConfigurationSection("npcs");
        if (npcsSection != null) {
            for (String key : npcsSection.getKeys(false)) {
                try {
                    configuredNPCs.add(UUID.fromString(key));
                }
                catch (IllegalArgumentException e) {
                    this.getLogger().warning("Invalid UUID in config: " + key);
                }
            }
        }
        int cleanedUp = 0;
        for (World world : Bukkit.getWorlds()) {
            for (Entity entity : world.getEntities()) {
                ArmorStand as;
                if (!(entity instanceof ArmorStand) || !(as = (ArmorStand)entity).getPersistentDataContainer().has(this.npcKey, PersistentDataType.STRING)) continue;
                String uuidStr = (String)as.getPersistentDataContainer().get(this.npcKey, PersistentDataType.STRING);
                try {
                    UUID npcId = UUID.fromString(uuidStr);
                    if (!configuredNPCs.contains(npcId)) {
                        as.remove();
                        ++cleanedUp;
                        this.getLogger().info("Removed orphaned NPC: " + uuidStr);
                        continue;
                    }
                    if (this.npcs.containsKey(npcId)) continue;
                    this.npcs.put(npcId, as);
                    this.npcLocations.put(npcId, as.getLocation());
                    String name = npcsSection.getString(npcId.toString() + ".name", "Portal NPC");
                    this.npcNames.put(npcId, name);
                }
                catch (IllegalArgumentException e) {
                    as.remove();
                    ++cleanedUp;
                }
            }
        }
        if (cleanedUp > 0) {
            this.getLogger().info("Cleaned up " + cleanedUp + " orphaned NPC entities.");
        }
    }

    private void loadNPCs() {
        ConfigurationSection npcsSection = this.getConfig().getConfigurationSection("npcs");
        if (npcsSection == null) {
            this.getLogger().info("No NPCs found in configuration.");
            return;
        }
        int loadedCount = 0;
        int failedCount = 0;
        for (String key : npcsSection.getKeys(false)) {
            try {
                ArmorStand existingNPC;
                UUID id = UUID.fromString(key);
                if (this.loadingNPCs.contains(id)) continue;
                this.loadingNPCs.add(id);
                String worldName = npcsSection.getString(key + ".world");
                if (worldName == null) {
                    this.getLogger().warning("NPC " + key + " has no world specified. Skipping.");
                    ++failedCount;
                    this.loadingNPCs.remove(id);
                    continue;
                }
                World world = Bukkit.getWorld((String)worldName);
                if (world == null) {
                    this.getLogger().warning("World '" + worldName + "' not found for NPC " + key + ". Retrying in 5 seconds...");
                    this.scheduleNPCLoad(key, worldName, 100L);
                    this.loadingNPCs.remove(id);
                    continue;
                }
                double x = npcsSection.getDouble(key + ".x");
                double y = npcsSection.getDouble(key + ".y");
                double z = npcsSection.getDouble(key + ".z");
                float yaw = (float)npcsSection.getDouble(key + ".yaw", 0.0);
                String name = npcsSection.getString(key + ".name", "Portal NPC");
                Location location = new Location(world, x, y, z, yaw, 0.0f);
                if (!location.getChunk().isLoaded()) {
                    location.getChunk().load(true);
                }
                if ((existingNPC = this.findExistingNPC(location, id)) != null) {
                    this.npcs.put(id, existingNPC);
                    this.npcLocations.put(id, location);
                    this.npcNames.put(id, name);
                    ++loadedCount;
                    this.getLogger().info("Found existing NPC: " + name);
                } else {
                    this.spawnNPC(location, name, id);
                    this.npcLocations.put(id, location);
                    this.npcNames.put(id, name);
                    ++loadedCount;
                }
                this.loadingNPCs.remove(id);
            }
            catch (Exception e) {
                this.getLogger().severe("Failed to load NPC " + key + ": " + e.getMessage());
                e.printStackTrace();
                ++failedCount;
                try {
                    this.loadingNPCs.remove(UUID.fromString(key));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
        if (loadedCount > 0) {
            this.getLogger().info("Successfully loaded " + loadedCount + " NPCs.");
        }
        if (failedCount > 0) {
            this.getLogger().warning(failedCount + " NPCs failed to load.");
        }
    }

    private ArmorStand findExistingNPC(Location location, UUID id) {
        for (Entity entity : location.getWorld().getNearbyEntities(location, 2.0, 2.0, 2.0)) {
            String storedId;
            ArmorStand as;
            if (!(entity instanceof ArmorStand) || !(as = (ArmorStand)entity).getPersistentDataContainer().has(this.npcKey, PersistentDataType.STRING) || (storedId = (String)as.getPersistentDataContainer().get(this.npcKey, PersistentDataType.STRING)) == null || !storedId.equals(id.toString())) continue;
            return as;
        }
        return null;
    }

    private void scheduleNPCLoad(final String key, final String worldName, long delay) {
        new BukkitRunnable(this){
            final /* synthetic */ NPCPortalsPlugin this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                try {
                    ArmorStand existingNPC;
                    UUID id = UUID.fromString(key);
                    if (this.this$0.npcs.containsKey(id)) {
                        return;
                    }
                    World world = Bukkit.getWorld((String)worldName);
                    if (world == null) {
                        this.this$0.getLogger().warning("World '" + worldName + "' still not found for NPC " + key + " after retry. Skipping.");
                        return;
                    }
                    ConfigurationSection npcsSection = this.this$0.getConfig().getConfigurationSection("npcs");
                    if (npcsSection == null) {
                        return;
                    }
                    double x = npcsSection.getDouble(key + ".x");
                    double y = npcsSection.getDouble(key + ".y");
                    double z = npcsSection.getDouble(key + ".z");
                    float yaw = (float)npcsSection.getDouble(key + ".yaw", 0.0);
                    String name = npcsSection.getString(key + ".name", "Portal NPC");
                    Location location = new Location(world, x, y, z, yaw, 0.0f);
                    if (!location.getChunk().isLoaded()) {
                        location.getChunk().load(true);
                    }
                    if ((existingNPC = this.this$0.findExistingNPC(location, id)) != null) {
                        this.this$0.npcs.put(id, existingNPC);
                        this.this$0.npcLocations.put(id, location);
                        this.this$0.npcNames.put(id, name);
                        this.this$0.getLogger().info("Found existing delayed NPC: " + name);
                    } else {
                        this.this$0.spawnNPC(location, name, id);
                        this.this$0.npcLocations.put(id, location);
                        this.this$0.npcNames.put(id, name);
                        this.this$0.getLogger().info("Successfully loaded delayed NPC: " + name);
                    }
                }
                catch (Exception e) {
                    this.this$0.getLogger().severe("Failed to load delayed NPC " + key + ": " + e.getMessage());
                }
            }
        }.runTaskLater((Plugin)this, delay);
    }

    private ArmorStand spawnNPC(Location location, String name, UUID id) {
        ArmorStand npc = (ArmorStand)location.getWorld().spawnEntity(location, EntityType.ARMOR_STAND);
        npc.getPersistentDataContainer().set(this.npcKey, PersistentDataType.STRING, (Object)id.toString());
        npc.setVisible(true);
        npc.setGravity(false);
        npc.setCanPickupItems(false);
        npc.setCustomName(ChatColor.translateAlternateColorCodes((char)'&', (String)name));
        npc.setCustomNameVisible(true);
        npc.setArms(true);
        npc.setBasePlate(false);
        npc.setMarker(false);
        npc.setInvulnerable(true);
        npc.setRemoveWhenFarAway(false);
        npc.getEquipment().setHelmet(new ItemStack(Material.GOLDEN_HELMET));
        npc.getEquipment().setChestplate(new ItemStack(Material.GOLDEN_CHESTPLATE));
        npc.getEquipment().setLeggings(new ItemStack(Material.GOLDEN_LEGGINGS));
        npc.getEquipment().setBoots(new ItemStack(Material.GOLDEN_BOOTS));
        npc.getEquipment().setItemInMainHand(new ItemStack(Material.ENDER_PEARL));
        npc.setRightArmPose(new EulerAngle(Math.toRadians(-10.0), Math.toRadians(20.0), 0.0));
        npc.setLeftArmPose(new EulerAngle(Math.toRadians(-10.0), Math.toRadians(-20.0), 0.0));
        this.npcs.put(id, npc);
        return npc;
    }

    @EventHandler
    public void onEntityDamage(EntityDamageEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ArmorStand && this.npcs.containsValue(entity)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onEntityDeath(EntityDeathEvent event) {
        ArmorStand as;
        LivingEntity entity = event.getEntity();
        if (entity instanceof ArmorStand && (as = (ArmorStand)entity).getPersistentDataContainer().has(this.npcKey, PersistentDataType.STRING)) {
            String uuidStr = (String)as.getPersistentDataContainer().get(this.npcKey, PersistentDataType.STRING);
            try {
                final UUID npcId = UUID.fromString(uuidStr);
                if (this.npcs.containsKey(npcId)) {
                    this.npcs.remove(npcId);
                    final Location loc = this.npcLocations.get(npcId);
                    final String name = this.npcNames.get(npcId);
                    if (loc != null && name != null) {
                        new BukkitRunnable(this){
                            final /* synthetic */ NPCPortalsPlugin this$0;
                            {
                                this.this$0 = this$0;
                            }

                            public void run() {
                                this.this$0.spawnNPC(loc, name, npcId);
                                this.this$0.getLogger().warning("NPC '" + name + "' was killed and has been respawned!");
                            }
                        }.runTaskLater((Plugin)this, 20L);
                    }
                }
            }
            catch (IllegalArgumentException e) {
                this.getLogger().warning("Invalid UUID in NPC death event: " + uuidStr);
            }
        }
    }

    @EventHandler
    public void onEntityExplode(EntityExplodeEvent event) {
        event.blockList().removeIf(block -> {
            for (Entity entity : block.getLocation().getWorld().getNearbyEntities(block.getLocation(), 1.0, 1.0, 1.0)) {
                if (!(entity instanceof ArmorStand) || !this.npcs.containsValue(entity)) continue;
                return true;
            }
            return false;
        });
    }

    @EventHandler
    public void onPistonExtend(BlockPistonExtendEvent event) {
        for (Block block : event.getBlocks()) {
            for (Entity entity : block.getLocation().getWorld().getNearbyEntities(block.getLocation(), 1.0, 2.0, 1.0)) {
                if (!(entity instanceof ArmorStand) || !this.npcs.containsValue(entity)) continue;
                event.setCancelled(true);
                return;
            }
        }
    }

    @EventHandler
    public void onPistonRetract(BlockPistonRetractEvent event) {
        for (Block block : event.getBlocks()) {
            for (Entity entity : block.getLocation().getWorld().getNearbyEntities(block.getLocation(), 1.0, 2.0, 1.0)) {
                if (!(entity instanceof ArmorStand) || !this.npcs.containsValue(entity)) continue;
                event.setCancelled(true);
                return;
            }
        }
    }

    @EventHandler
    public void onChunkLoad(ChunkLoadEvent event) {
        for (Map.Entry<UUID, Location> entry : this.npcLocations.entrySet()) {
            UUID npcId;
            ArmorStand cachedNPC;
            Location npcLoc = entry.getValue();
            if (!npcLoc.getWorld().equals((Object)event.getWorld()) || npcLoc.getChunk().getX() != event.getChunk().getX() || npcLoc.getChunk().getZ() != event.getChunk().getZ() || (cachedNPC = this.npcs.get(npcId = entry.getKey())) != null && !cachedNPC.isDead() && cachedNPC.isValid()) continue;
            ArmorStand existingNPC = this.findExistingNPC(npcLoc, npcId);
            if (existingNPC != null) {
                this.npcs.put(npcId, existingNPC);
                continue;
            }
            String name = this.npcNames.get(npcId);
            if (name == null) continue;
            this.spawnNPC(npcLoc, name, npcId);
            this.getLogger().info("Respawned NPC '" + name + "' in loaded chunk.");
        }
    }

    @EventHandler
    public void onChunkUnload(ChunkUnloadEvent event) {
    }

    @EventHandler
    public void onPlayerInteractAtEntity(PlayerInteractAtEntityEvent event) {
        Entity entity = event.getRightClicked();
        Player player = event.getPlayer();
        if (!(entity instanceof ArmorStand)) {
            return;
        }
        ArmorStand armorStand = (ArmorStand)entity;
        if (!armorStand.getPersistentDataContainer().has(this.npcKey, PersistentDataType.STRING)) {
            return;
        }
        event.setCancelled(true);
        if (!player.hasPermission("npcportals.use")) {
            player.sendMessage(this.prefix + String.valueOf(ChatColor.RED) + "You don't have permission to use teleportation!");
            player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
            return;
        }
        String uuidStr = (String)armorStand.getPersistentDataContainer().get(this.npcKey, PersistentDataType.STRING);
        UUID clickedNPCId = null;
        try {
            clickedNPCId = UUID.fromString(uuidStr);
        }
        catch (IllegalArgumentException e) {
            player.sendMessage(this.prefix + String.valueOf(ChatColor.RED) + "Error: Invalid NPC data!");
            return;
        }
        int availableNPCs = 0;
        for (Map.Entry<UUID, ArmorStand> entry : this.npcs.entrySet()) {
            ArmorStand npc;
            if (entry.getKey().equals(clickedNPCId) || (npc = entry.getValue()) == null || npc.isDead() || !npc.isValid()) continue;
            ++availableNPCs;
        }
        if (availableNPCs == 0) {
            player.sendMessage(this.prefix + String.valueOf(ChatColor.YELLOW) + "No other teleportation points available!");
            player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
            return;
        }
        this.openTeleportationGUI(player, clickedNPCId);
        player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
    }

    private void openTeleportationGUI(Player player, UUID clickedNPCId) {
        ArrayList<UUID> validNPCs = new ArrayList<UUID>();
        for (Map.Entry<UUID, ArmorStand> entry : this.npcs.entrySet()) {
            UUID npcId = entry.getKey();
            ArmorStand npc = entry.getValue();
            if (npcId.equals(clickedNPCId) || npc == null || npc.isDead() || !npc.isValid()) continue;
            validNPCs.add(npcId);
        }
        if (validNPCs.isEmpty()) {
            player.sendMessage(this.prefix + String.valueOf(ChatColor.YELLOW) + "No other teleportation points available!");
            player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
            return;
        }
        int size = Math.max(9, (validNPCs.size() + 8) / 9 * 9);
        Inventory gui = Bukkit.createInventory(null, (int)size, (String)this.guiTitle);
        int slot = 0;
        for (UUID npcId : validNPCs) {
            String npcName = this.npcNames.get(npcId);
            Location npcLocation = this.npcLocations.get(npcId);
            if (npcName == null || npcLocation == null) continue;
            ItemStack item = new ItemStack(Material.ENDER_PEARL);
            ItemMeta meta = item.getItemMeta();
            meta.setDisplayName(String.valueOf(ChatColor.GOLD) + npcName);
            ArrayList<Object> lore = new ArrayList<Object>();
            lore.add(String.valueOf(ChatColor.GRAY) + "World: " + String.valueOf(ChatColor.WHITE) + npcLocation.getWorld().getName());
            lore.add(String.valueOf(ChatColor.GRAY) + "Location: " + String.valueOf(ChatColor.WHITE) + String.format("%.0f, %.0f, %.0f", npcLocation.getX(), npcLocation.getY(), npcLocation.getZ()));
            lore.add("");
            lore.add(String.valueOf(ChatColor.GREEN) + "Click to teleport!");
            meta.setLore(lore);
            item.setItemMeta(meta);
            gui.setItem(slot++, item);
        }
        ItemStack closeButton = new ItemStack(Material.BARRIER);
        ItemMeta closeMeta = closeButton.getItemMeta();
        closeMeta.setDisplayName(String.valueOf(ChatColor.RED) + "Close");
        closeButton.setItemMeta(closeMeta);
        gui.setItem(size - 1, closeButton);
        player.openInventory(gui);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!event.getView().getTitle().equals(this.guiTitle)) {
            return;
        }
        event.setCancelled(true);
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null || clickedItem.getType() == Material.AIR) {
            return;
        }
        if (clickedItem.getType() == Material.BARRIER) {
            player.closeInventory();
            player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 0.8f);
            return;
        }
        if (clickedItem.getType() == Material.ENDER_PEARL) {
            String npcName = ChatColor.stripColor((String)clickedItem.getItemMeta().getDisplayName());
            for (Map.Entry<UUID, String> entry : this.npcNames.entrySet()) {
                if (!entry.getValue().equals(npcName)) continue;
                UUID npcId = entry.getKey();
                Location destination = this.npcLocations.get(npcId);
                if (destination == null) {
                    player.sendMessage(this.prefix + String.valueOf(ChatColor.RED) + "Error: Destination not found!");
                    player.closeInventory();
                    return;
                }
                ArmorStand npc = this.npcs.get(npcId);
                if (npc == null || npc.isDead() || !npc.isValid()) {
                    player.sendMessage(this.prefix + String.valueOf(ChatColor.RED) + "Error: That NPC no longer exists!");
                    player.closeInventory();
                    return;
                }
                this.teleportPlayer(player, destination, npcName);
                return;
            }
            player.sendMessage(this.prefix + String.valueOf(ChatColor.RED) + "Error: NPC not found!");
            player.closeInventory();
        }
    }

    private void teleportPlayer(final Player player, final Location destination, final String npcName) {
        player.closeInventory();
        if (destination.getWorld() == null) {
            player.sendMessage(this.prefix + String.valueOf(ChatColor.RED) + "Error: Destination world not found!");
            return;
        }
        player.sendMessage(this.prefix + String.valueOf(ChatColor.YELLOW) + "Teleporting to " + String.valueOf(ChatColor.GOLD) + npcName + String.valueOf(ChatColor.YELLOW) + "...");
        player.playSound(player.getLocation(), Sound.ENTITY_ENDERMAN_TELEPORT, 1.0f, 1.0f);
        new BukkitRunnable(this){
            final /* synthetic */ NPCPortalsPlugin this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                if (!player.isOnline()) {
                    return;
                }
                if (player.isDead()) {
                    return;
                }
                if (!destination.getChunk().isLoaded()) {
                    destination.getChunk().load();
                }
                try {
                    boolean success = player.teleport(destination);
                    if (success) {
                        player.playSound(destination, Sound.ENTITY_ENDERMAN_TELEPORT, 1.0f, 1.2f);
                        player.sendMessage(this.this$0.prefix + String.valueOf(ChatColor.GREEN) + "Successfully teleported to " + String.valueOf(ChatColor.GOLD) + npcName + String.valueOf(ChatColor.GREEN) + "!");
                    } else {
                        player.sendMessage(this.this$0.prefix + String.valueOf(ChatColor.RED) + "Teleportation failed! Please try again.");
                        player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                    }
                }
                catch (Exception e) {
                    player.sendMessage(this.this$0.prefix + String.valueOf(ChatColor.RED) + "Error during teleportation!");
                    this.this$0.getLogger().severe("Teleportation error: " + e.getMessage());
                }
            }
        }.runTaskLater((Plugin)this, 20L);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!command.getName().equalsIgnoreCase("npcportals")) {
            return false;
        }
        if (args.length == 0 || args[0].equalsIgnoreCase("help")) {
            this.sendHelpMessage(sender);
            return true;
        }
        if (!sender.hasPermission("npcportals.admin")) {
            sender.sendMessage(this.prefix + String.valueOf(ChatColor.RED) + "You don't have permission to use this command!");
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "reload": {
                this.reloadConfig();
                this.loadConfiguration();
                this.npcs.clear();
                this.npcNames.clear();
                this.npcLocations.clear();
                this.loadingNPCs.clear();
                this.loadNPCs();
                this.verifyAndCleanupExistingNPCs();
                sender.sendMessage(this.prefix + String.valueOf(ChatColor.GREEN) + "Configuration reloaded! " + this.npcs.size() + " NPCs loaded.");
                break;
            }
            case "spawn": {
                if (!(sender instanceof Player)) {
                    sender.sendMessage(this.prefix + String.valueOf(ChatColor.RED) + "Only players can spawn NPCs!");
                    return true;
                }
                this.spawnNPCCommand((Player)sender, args);
                break;
            }
            case "remove": {
                if (!(sender instanceof Player)) {
                    sender.sendMessage(this.prefix + String.valueOf(ChatColor.RED) + "Only players can remove NPCs!");
                    return true;
                }
                this.removeNPCCommand((Player)sender, args);
                break;
            }
            case "list": {
                this.listNPCsCommand(sender);
                break;
            }
            default: {
                this.sendHelpMessage(sender);
            }
        }
        return true;
    }

    private void sendHelpMessage(CommandSender sender) {
        sender.sendMessage(String.valueOf(ChatColor.GOLD) + "=== NPC Teleport Help ===");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/npcportals help " + String.valueOf(ChatColor.WHITE) + "- Show this help message");
        if (sender.hasPermission("npcportals.admin")) {
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/npcportals reload " + String.valueOf(ChatColor.WHITE) + "- Reload configuration");
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/npcportals spawn <name> " + String.valueOf(ChatColor.WHITE) + "- Spawn an NPC");
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/npcportals remove [name] " + String.valueOf(ChatColor.WHITE) + "- Remove nearby NPC or by name");
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/npcportals list " + String.valueOf(ChatColor.WHITE) + "- List all NPCs");
        }
    }

    private void spawnNPCCommand(Player player, String[] args) {
        String npcName = args.length > 1 ? String.join((CharSequence)" ", Arrays.copyOfRange(args, 1, args.length)) : "Portal NPC";
        for (String existingName : this.npcNames.values()) {
            if (!existingName.equalsIgnoreCase(npcName)) continue;
            player.sendMessage(this.prefix + String.valueOf(ChatColor.RED) + "An NPC with the name '" + npcName + "' already exists!");
            player.sendMessage(this.prefix + String.valueOf(ChatColor.YELLOW) + "Please choose a different name.");
            return;
        }
        Location location = player.getLocation();
        UUID id = UUID.randomUUID();
        this.spawnNPC(location, npcName, id);
        this.npcLocations.put(id, location);
        this.npcNames.put(id, npcName);
        this.getConfig().set("npcs." + id.toString() + ".world", (Object)location.getWorld().getName());
        this.getConfig().set("npcs." + id.toString() + ".x", (Object)location.getX());
        this.getConfig().set("npcs." + id.toString() + ".y", (Object)location.getY());
        this.getConfig().set("npcs." + id.toString() + ".z", (Object)location.getZ());
        this.getConfig().set("npcs." + id.toString() + ".yaw", (Object)Float.valueOf(location.getYaw()));
        this.getConfig().set("npcs." + id.toString() + ".name", (Object)npcName);
        this.saveConfig();
        player.sendMessage(this.prefix + String.valueOf(ChatColor.GREEN) + "NPC '" + npcName + "' spawned successfully!");
    }

    private void removeNPCCommand(Player player, String[] args) {
        if (args.length > 1) {
            String targetName = String.join((CharSequence)" ", Arrays.copyOfRange(args, 1, args.length));
            this.removeNPCByName(player, targetName);
        } else {
            this.removeNearestNPC(player);
        }
    }

    private void removeNPCByName(Player player, String targetName) {
        UUID targetId = null;
        String actualName = null;
        for (Map.Entry<UUID, String> entry : this.npcNames.entrySet()) {
            if (!entry.getValue().equalsIgnoreCase(targetName)) continue;
            targetId = entry.getKey();
            actualName = entry.getValue();
            break;
        }
        if (targetId != null) {
            ArmorStand npc = this.npcs.get(targetId);
            if (npc != null && !npc.isDead()) {
                npc.remove();
            }
            this.npcs.remove(targetId);
            this.npcLocations.remove(targetId);
            this.npcNames.remove(targetId);
            this.loadingNPCs.remove(targetId);
            this.getConfig().set("npcs." + targetId.toString(), null);
            this.saveConfig();
            player.sendMessage(this.prefix + String.valueOf(ChatColor.GREEN) + "NPC '" + actualName + "' removed successfully!");
            player.playSound(player.getLocation(), Sound.ENTITY_ITEM_BREAK, 1.0f, 1.0f);
        } else {
            player.sendMessage(this.prefix + String.valueOf(ChatColor.RED) + "NPC with name '" + targetName + "' not found!");
            player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
        }
    }

    private void removeNearestNPC(Player player) {
        Location playerLoc = player.getLocation();
        ArmorStand nearestNPC = null;
        double nearestDistance = Double.MAX_VALUE;
        UUID npcId = null;
        for (Map.Entry<UUID, ArmorStand> entry : this.npcs.entrySet()) {
            double distance;
            ArmorStand npc = entry.getValue();
            if (npc == null || npc.isDead() || !npc.isValid() || !npc.getWorld().equals((Object)playerLoc.getWorld()) || !((distance = npc.getLocation().distance(playerLoc)) < nearestDistance) || !(distance <= 5.0)) continue;
            nearestDistance = distance;
            nearestNPC = npc;
            npcId = entry.getKey();
        }
        if (nearestNPC != null) {
            String npcName = this.npcNames.get(npcId);
            nearestNPC.remove();
            this.npcs.remove(npcId);
            this.npcLocations.remove(npcId);
            this.npcNames.remove(npcId);
            this.loadingNPCs.remove(npcId);
            this.getConfig().set("npcs." + npcId.toString(), null);
            this.saveConfig();
            player.sendMessage(this.prefix + String.valueOf(ChatColor.GREEN) + "NPC '" + npcName + "' removed successfully!");
            player.playSound(player.getLocation(), Sound.ENTITY_ITEM_BREAK, 1.0f, 1.0f);
        } else {
            player.sendMessage(this.prefix + String.valueOf(ChatColor.RED) + "No NPC found within 5 blocks!");
            player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
        }
    }

    private void listNPCsCommand(CommandSender sender) {
        if (this.npcs.isEmpty()) {
            sender.sendMessage(this.prefix + String.valueOf(ChatColor.YELLOW) + "No NPCs spawned!");
            return;
        }
        sender.sendMessage(String.valueOf(ChatColor.GOLD) + "=== Active NPCs (" + this.npcs.size() + ") ===");
        int count = 0;
        for (Map.Entry<UUID, String> entry : this.npcNames.entrySet()) {
            Location loc = this.npcLocations.get(entry.getKey());
            ArmorStand npc = this.npcs.get(entry.getKey());
            String status = String.valueOf(ChatColor.GREEN) + "\u2713";
            if (npc == null || npc.isDead() || !npc.isValid()) {
                status = String.valueOf(ChatColor.RED) + "\u2717";
            }
            sender.sendMessage(status + " " + String.valueOf(ChatColor.YELLOW) + entry.getValue() + String.valueOf(ChatColor.WHITE) + " - " + String.valueOf(ChatColor.GRAY) + loc.getWorld().getName() + " " + String.format("(%.0f, %.0f, %.0f)", loc.getX(), loc.getY(), loc.getZ()));
            ++count;
        }
        sender.sendMessage(String.valueOf(ChatColor.GRAY) + "Total: " + count + " NPC(s)");
    }
}

