/*
 * Decompiled with CFR 0.152.
 */
package io.github.smootheez.ghastautopilot.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.github.smootheez.ghastautopilot.util.GhastAutopilotUtil;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_11187;
import net.minecraft.class_124;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_7157;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class GhastAutopilotCommand
implements ClientCommandRegistrationCallback {
    private static final String X_COORDINATE = "x";
    private static final String Z_COORDINATE = "z";
    private static final String COMMANDS_MODID = "commands.ghastautopilot";
    private static final String REMOVE_TRANSLATABLE_MESSAGE = "commands.ghastautopilot.remove_destination";
    private static final String SET_TRANSLATABLE_MESSAGE = "commands.ghastautopilot.set_destination";
    private static final String GET_TRANSLATABLE_MESSAGE = "commands.ghastautopilot.get_destination";
    private static final String SUCCESS = ".success";
    private static final String FAIL = ".fail";

    public void register(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 registryAccess) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)GhastAutopilotCommand.getCommandSourceLiteralArgumentBuilder("ghastautopilot").then(GhastAutopilotCommand.getCommandSourceLiteralArgumentBuilder("setdestination").then(GhastAutopilotCommand.getIntegerRequiredArgumentBuilder(X_COORDINATE).then(GhastAutopilotCommand.getIntegerRequiredArgumentBuilder(Z_COORDINATE).executes(GhastAutopilotCommand::runSetDestination))))).then(GhastAutopilotCommand.getCommandSourceLiteralArgumentBuilder("removedestination").executes(GhastAutopilotCommand::runRemoveDestination))).then(GhastAutopilotCommand.getCommandSourceLiteralArgumentBuilder("getdestination").executes(GhastAutopilotCommand::getDestination)));
    }

    private static int getDestination(CommandContext<FabricClientCommandSource> context) {
        class_746 player = ((FabricClientCommandSource)context.getSource()).getPlayer();
        class_243 vec3 = GhastAutopilotUtil.getVec3();
        if (vec3 == null) {
            player.method_7353((class_2561)class_2561.method_43471((String)"commands.ghastautopilot.get_destination.fail").method_27692(class_124.field_1061), false);
            return 0;
        }
        player.method_7353((class_2561)class_2561.method_43469((String)"commands.ghastautopilot.get_destination.success", (Object[])new Object[]{vec3.field_1352, vec3.field_1351}), false);
        return 1;
    }

    @NotNull
    private static LiteralArgumentBuilder<FabricClientCommandSource> getCommandSourceLiteralArgumentBuilder(String removedestination) {
        return LiteralArgumentBuilder.literal((String)removedestination);
    }

    @NotNull
    private static RequiredArgumentBuilder<FabricClientCommandSource, Integer> getIntegerRequiredArgumentBuilder(String coordinate) {
        return RequiredArgumentBuilder.argument((String)coordinate, (ArgumentType)IntegerArgumentType.integer());
    }

    private static int runRemoveDestination(CommandContext<FabricClientCommandSource> context) {
        class_746 player = ((FabricClientCommandSource)context.getSource()).getPlayer();
        if (GhastAutopilotUtil.getVec3() == null) {
            player.method_7353((class_2561)class_2561.method_43471((String)"commands.ghastautopilot.remove_destination.fail").method_27692(class_124.field_1061), false);
            return 0;
        }
        GhastAutopilotUtil.clearVec3();
        player.method_7353((class_2561)class_2561.method_43471((String)"commands.ghastautopilot.remove_destination.success").method_27692(class_124.field_1060), false);
        return 1;
    }

    private static int runSetDestination(CommandContext<FabricClientCommandSource> context) {
        class_746 player = ((FabricClientCommandSource)context.getSource()).getPlayer();
        if (!(player.method_5854() instanceof class_11187)) {
            player.method_7353((class_2561)class_2561.method_43471((String)"commands.ghastautopilot.set_destination.fail").method_27692(class_124.field_1061), false);
            return 0;
        }
        int x = IntegerArgumentType.getInteger(context, (String)X_COORDINATE);
        int z = IntegerArgumentType.getInteger(context, (String)Z_COORDINATE);
        class_243 vec3 = new class_243((double)x, 0.0, (double)z);
        GhastAutopilotUtil.setVec3(vec3);
        player.method_7353((class_2561)class_2561.method_43469((String)"commands.ghastautopilot.set_destination.success", (Object[])new Object[]{vec3.field_1352, vec3.field_1350}).method_27692(class_124.field_1060), false);
        return 1;
    }
}

