/*
 * Decompiled with CFR 0.152.
 */
package io.github.smootheez.ghastautopilot.handler;

import io.github.smootheez.ghastautopilot.config.GhastAutopilotConfig;
import io.github.smootheez.ghastautopilot.registry.KeyMappingRegistry;
import io.github.smootheez.ghastautopilot.util.DebugMode;
import io.github.smootheez.ghastautopilot.util.GhastAutopilotUtil;
import io.github.smootheez.smoothiezapi.config.ConfigManager;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_11187;
import net.minecraft.class_124;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_746;

@Environment(value=EnvType.CLIENT)
public class HandleEndTick
implements ClientTickEvents.EndTick {
    private static final String MODID_TOGGLE_AUTOPILOT = "ghastautopilot.toggle_autopilot";
    private boolean isForwardKeyForced = false;
    private static final GhastAutopilotConfig CONFIG = (GhastAutopilotConfig)ConfigManager.getConfig(GhastAutopilotConfig.class);

    public void onEndTick(class_310 minecraft) {
        if (Boolean.FALSE.equals(CONFIG.getGhastAutopilot().getValue())) {
            return;
        }
        class_746 player = minecraft.field_1724;
        if (player == null) {
            return;
        }
        boolean isRidingHappyGhast = player.method_5854() instanceof class_11187;
        while (KeyMappingRegistry.TOGGLE_AUTOPILOT.method_1436()) {
            if (isRidingHappyGhast) {
                GhastAutopilotUtil.setAutoPilot(!GhastAutopilotUtil.isAutoPilot());
                this.sendToggleMessage(player);
                continue;
            }
            HandleEndTick.sendFailMessage(player);
        }
        if (!isRidingHappyGhast) {
            HandleEndTick.clearVc3AndDisableAutopilot();
        }
        boolean shouldForceKey = isRidingHappyGhast && GhastAutopilotUtil.isAutoPilot();
        boolean keyPhysicallyDown = minecraft.field_1690.field_1894.method_1434();
        if (shouldForceKey) {
            if (!keyPhysicallyDown) {
                minecraft.field_1690.field_1894.method_23481(true);
                DebugMode.sendLoggerInfo("Forcing forward key (autopilot active)");
            }
            this.isForwardKeyForced = true;
        } else if (this.isForwardKeyForced) {
            minecraft.field_1690.field_1894.method_23481(false);
            DebugMode.sendLoggerInfo("Releasing forward key (autopilot off)");
            this.isForwardKeyForced = false;
        }
        this.handleLookAt(player);
        DebugMode.sendLoggerInfo("Autopilot: " + (GhastAutopilotUtil.isAutoPilot() ? "Enabled" : "Disabled"));
    }

    private void handleLookAt(class_746 player) {
        class_243 destination = GhastAutopilotUtil.getVec3();
        if (Boolean.FALSE.equals(CONFIG.getLookAt().getValue()) || destination == null || !GhastAutopilotUtil.isAutoPilot()) {
            return;
        }
        class_243 eyePos = player.method_5836(1.0f);
        double dx = destination.field_1352 - eyePos.field_1352;
        double dz = destination.field_1350 - eyePos.field_1350;
        double distanceSq = dx * dx + dz * dz;
        if (distanceSq < (Double)CONFIG.getStopThreshold().getValue()) {
            HandleEndTick.clearVc3AndDisableAutopilot();
            HandleEndTick.displayClientMessage(player, "arrived.ghastautopilot.toggle_autopilot", class_124.field_1060);
        }
        float targetYaw = (float)(Math.toDegrees(Math.atan2(dz, dx)) - 90.0);
        float targetPitch = 0.0f;
        float currentYaw = player.method_36454();
        float currentPitch = player.method_36455();
        float SMOOTH_FACTOR = ((Double)CONFIG.getSmoothFactor().getValue()).floatValue();
        float newYaw = HandleEndTick.lerpYaw(currentYaw, targetYaw, SMOOTH_FACTOR);
        float newPitch = HandleEndTick.lerpPitch(currentPitch, targetPitch, SMOOTH_FACTOR);
        player.method_36456(newYaw);
        player.method_36457(newPitch);
    }

    private static void clearVc3AndDisableAutopilot() {
        GhastAutopilotUtil.clearVec3();
        GhastAutopilotUtil.setAutoPilot(false);
    }

    private static float lerpPitch(float from, float to, float amount) {
        return from + (to - from) * amount;
    }

    private static float lerpYaw(float from, float to, float amount) {
        float delta = HandleEndTick.wrapDegrees(to - from);
        return from + delta * amount;
    }

    private static float wrapDegrees(float angle) {
        if ((angle %= 360.0f) >= 180.0f) {
            angle -= 360.0f;
        }
        if (angle < -180.0f) {
            angle += 360.0f;
        }
        return angle;
    }

    private static void sendFailMessage(class_746 player) {
        HandleEndTick.displayClientMessage(player, "fail.ghastautopilot.toggle_autopilot", class_124.field_1061);
    }

    private void sendToggleMessage(class_746 player) {
        String key = GhastAutopilotUtil.isAutoPilot() ? "enabled" : "disabled";
        class_124 formatting = GhastAutopilotUtil.isAutoPilot() ? class_124.field_1060 : class_124.field_1054;
        HandleEndTick.displayClientMessage(player, key + ".ghastautopilot.toggle_autopilot", formatting);
    }

    private static void displayClientMessage(class_746 player, String message, class_124 chatFormatting) {
        if (Boolean.FALSE.equals(CONFIG.getDisplayToggleNotification().getValue())) {
            return;
        }
        player.method_7353((class_2561)class_2561.method_43471((String)message).method_27692(chatFormatting), true);
    }
}

