/*
 * Decompiled with CFR 0.152.
 */
package dev.smootheez.ghastautopilot.handler;

import dev.smootheez.ghastautopilot.config.GhastAutopilotConfig;
import dev.smootheez.ghastautopilot.registry.KeyMappingRegistrar;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11187;
import net.minecraft.class_124;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_746;

@Environment(value=EnvType.CLIENT)
public class MinecraftHandler {
    private final class_310 minecraft;
    private boolean enableAutopilot = false;
    private static class_243 destination = null;

    public static void setDestination(class_243 newDestination) {
        destination = newDestination;
    }

    public static class_243 getDestination() {
        return destination;
    }

    public static void clearDestination() {
        destination = null;
    }

    public MinecraftHandler(class_310 minecraft) {
        this.minecraft = minecraft;
    }

    public void clientTick() {
        class_746 player = this.minecraft.field_1724;
        if (player == null) {
            return;
        }
        boolean isRidingHappyGhast = player.method_5854() instanceof class_11187;
        this.handleAutopilotToggle(player, isRidingHappyGhast);
        this.handleAutopilotInterrupt(isRidingHappyGhast);
        this.handleAutopilotSteering(player);
    }

    private void handleAutopilotToggle(class_746 player, boolean isRidingHappyGhast) {
        boolean autopilotEnabledInConfig = (Boolean)GhastAutopilotConfig.ENABLE_AUTOPILOT.getValue();
        while (KeyMappingRegistrar.START_AUTOPILOT.method_1436() && autopilotEnabledInConfig) {
            if (isRidingHappyGhast) {
                if (player.method_23318() <= (double)((Integer)GhastAutopilotConfig.MINIMUM_HEIGHT.getValue()).intValue()) {
                    player.method_7353((class_2561)class_2561.method_43471((String)"commands.ghastautopilot.error.tooLow").method_27692(class_124.field_1061), true);
                    continue;
                }
                this.toggleAutopilot();
                continue;
            }
            player.method_7353((class_2561)class_2561.method_43471((String)"commands.ghastautopilot.error.notRiding").method_27692(class_124.field_1061), true);
        }
    }

    private void toggleAutopilot() {
        this.enableAutopilot = !this.enableAutopilot;
        this.minecraft.field_1690.field_1894.method_23481(this.enableAutopilot);
        if (this.minecraft.field_1724 != null) {
            this.minecraft.field_1724.method_7353((class_2561)class_2561.method_43471((String)("commands.ghastautopilot." + (this.enableAutopilot ? "enabled" : "disabled"))).method_27692(this.enableAutopilot ? class_124.field_1060 : class_124.field_1054), true);
        }
    }

    private void handleAutopilotInterrupt(boolean isRidingHappyGhast) {
        if (this.enableAutopilot && !isRidingHappyGhast) {
            this.enableAutopilot = false;
            MinecraftHandler.clearDestination();
            this.minecraft.field_1690.field_1894.method_23481(false);
            if (this.minecraft.field_1724 == null) {
                return;
            }
            this.minecraft.field_1724.method_7353((class_2561)class_2561.method_43471((String)"commands.ghastautopilot.error.notRiding").method_27692(class_124.field_1054), true);
        }
    }

    private void handleAutopilotSteering(class_746 player) {
        if (!this.enableAutopilot) {
            return;
        }
        this.minecraft.field_1690.field_1894.method_23481(true);
        if (destination != null) {
            this.lookAt(destination);
        }
        float currentPitch = player.method_36455();
        float targetPitch = 0.0f;
        float lerpSpeed = 0.1f;
        player.method_36457(this.lerp(currentPitch, targetPitch, lerpSpeed));
    }

    private void lookAt(class_243 destination) {
        class_746 player = this.minecraft.field_1724;
        if (player == null) {
            return;
        }
        class_243 eyePos = player.method_5836(1.0f);
        double dx = destination.field_1352 - eyePos.field_1352;
        double dz = destination.field_1350 - eyePos.field_1350;
        double distanceSq = dx * dx + dz * dz;
        double stopThresholdSq = (Double)GhastAutopilotConfig.STOP_THRESHOLD.getValue();
        if (distanceSq < stopThresholdSq) {
            this.enableAutopilot = false;
            this.minecraft.field_1690.field_1894.method_23481(false);
            MinecraftHandler.clearDestination();
            player.method_7353((class_2561)class_2561.method_43471((String)"commands.ghastautopilot.arrived").method_27692(class_124.field_1060), true);
            return;
        }
        float yaw = (float)(class_3532.method_15349((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
        player.method_36456(yaw);
        player.field_5982 = yaw;
    }

    private float lerp(float from, float to, float maxSpeed) {
        float diff = to - from;
        float speed = Math.min(Math.abs(diff) * 0.2f, maxSpeed);
        return from + diff * speed;
    }
}

