/*
 * Decompiled with CFR 0.152.
 */
package dev.smootheez.ghastautopilot.mixin;

import com.mojang.brigadier.CommandDispatcher;
import dev.smootheez.ghastautopilot.Constants;
import dev.smootheez.ghastautopilot.command.AutopilotCommand;
import net.minecraft.class_2641;
import net.minecraft.class_437;
import net.minecraft.class_634;
import net.minecraft.class_637;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_634.class})
public abstract class ClientPacketListenerMixin {
    @Shadow
    public abstract CommandDispatcher<class_637> method_2886();

    @Shadow
    public abstract class_637 method_2875();

    @Inject(method={"handleCommands"}, at={@At(value="RETURN")})
    private void onHandleCommands(class_2641 clientboundCommandsPacket, CallbackInfo ci) {
        CommandDispatcher<class_637> dispatcher = this.method_2886();
        AutopilotCommand.register(dispatcher);
    }

    @Inject(method={"sendUnattendedCommand"}, at={@At(value="HEAD")}, cancellable=true)
    private void sendUnattendedCommand(String string, class_437 screen, CallbackInfo ci) {
        if (this.tryExecuteClientCommand(string)) {
            ci.cancel();
        }
    }

    @Inject(method={"sendCommand"}, at={@At(value="HEAD")}, cancellable=true)
    private void sendCommand(String string, CallbackInfo ci) {
        if (this.tryExecuteClientCommand(string)) {
            ci.cancel();
        }
    }

    @Unique
    private boolean tryExecuteClientCommand(String command) {
        if (!command.startsWith("ghastautopilot")) {
            return false;
        }
        Constants.LOGGER.info("Intercepted client-side command: /{}", (Object)command);
        try {
            CommandDispatcher<class_637> dispatcher = this.method_2886();
            class_637 source = this.method_2875();
            dispatcher.execute(command, (Object)source);
        }
        catch (Exception e) {
            Constants.LOGGER.error("Failed to execute client-side command '/{}'", (Object)command, (Object)e);
        }
        return true;
    }
}

