/*
 * Decompiled with CFR 0.152.
 */
package net.diexv.diexvcreeper.entity;

import java.util.Comparator;
import java.util.List;
import net.diexv.diexvcreeper.entity.DiexvCreeperEntity;
import net.diexv.diexvcreeper.entity.RainbowLightningBoltEntity;
import net.diexv.diexvcreeper.init.DiexvcreeperModEntities;
import net.diexv.diexvcreeper.util.DiexvUtil;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;

@OnlyIn(value=Dist.CLIENT, _interface=ItemSupplier.class)
public class BombEntity
extends AbstractArrow
implements ItemSupplier {
    private static final double TRACKING_RANGE = 1000.0;
    private static final float TRACKING_STRENGTH = 1.0f;
    private LivingEntity target;
    private boolean active = true;
    public static final ItemStack PROJECTILE_ITEM = new ItemStack((ItemLike)Blocks.f_50077_);

    public void m_6686_(double x, double y, double z, float velocity, float inaccuracy) {
        super.m_6686_(x, y, z, velocity * 0.5f, inaccuracy);
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public BombEntity(PlayMessages.SpawnEntity packet, Level world) {
        super((EntityType)DiexvcreeperModEntities.BOMB.get(), world);
    }

    public BombEntity(EntityType<? extends BombEntity> type, Level world) {
        super(type, world);
    }

    public BombEntity(EntityType<? extends BombEntity> type, double x, double y, double z, Level world) {
        super(type, x, y, z, world);
    }

    public BombEntity(EntityType<? extends BombEntity> type, LivingEntity entity, Level world) {
        super(type, entity, world);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack m_7846_() {
        return PROJECTILE_ITEM;
    }

    protected ItemStack m_7941_() {
        return PROJECTILE_ITEM;
    }

    protected void m_7761_(LivingEntity entity) {
        super.m_7761_(entity);
        entity.m_21317_(entity.m_21234_() - 1);
    }

    public void m_5790_(EntityHitResult entityHitResult) {
        super.m_5790_(entityHitResult);
        this.affectEntitiesInRadius(entityHitResult.m_82450_(), 5.0);
    }

    public void m_8060_(BlockHitResult blockHitResult) {
        super.m_8060_(blockHitResult);
        this.affectEntitiesInRadius(blockHitResult.m_82450_(), 5.0);
        this.spawnVisualLightning(blockHitResult.m_82450_());
    }

    private void affectEntitiesInRadius(Vec3 center, double radius) {
        if (this.m_9236_().f_46443_) {
            return;
        }
        AABB area = new AABB(center.f_82479_ - radius, center.f_82480_ - radius, center.f_82481_ - radius, center.f_82479_ + radius, center.f_82480_ + radius, center.f_82481_ + radius);
        List entities = this.m_9236_().m_6443_(LivingEntity.class, area, entity -> !(entity instanceof DiexvCreeperEntity) && !(entity instanceof Player));
        for (LivingEntity entity2 : entities) {
            this.spawnVisualLightning(entity2.m_20182_());
            DiexvUtil.addEntityToModificationList((Entity)entity2);
            DiexvUtil.markEntity(entity2);
            DamageSource damageSource = entity2.m_9236_().m_269111_().m_269341_();
            entity2.m_6469_(damageSource, 1000.0f);
            DiexvUtil.isLifeLocked(entity2);
            DiexvUtil.lockEntityLife(entity2);
        }
    }

    private void spawnVisualLightning(Vec3 position) {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            RainbowLightningBoltEntity lightningBolt = (RainbowLightningBoltEntity)((EntityType)DiexvcreeperModEntities.RAINBOW_LIGHTNING.get()).m_20615_((Level)serverLevel);
            if (lightningBolt != null) {
                lightningBolt.m_20219_(position);
                lightningBolt.m_20874_(true);
                lightningBolt.m_20879_(null);
                serverLevel.m_7967_((Entity)lightningBolt);
            }
        }
    }

    public void m_8119_() {
        List entities;
        super.m_8119_();
        if (this.f_36703_) {
            this.m_146870_();
            return;
        }
        if (!this.m_9236_().f_46443_ && !(entities = this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82400_(0.1), e -> !(e instanceof BombEntity) && !(e instanceof DiexvCreeperEntity))).isEmpty()) {
            this.m_146870_();
        }
        if (this.f_19797_ % 1 == 0) {
            this.findNewTarget();
        }
        if (this.target != null && this.target.m_6084_()) {
            this.trackTarget();
        }
    }

    private void findNewTarget() {
        List entities = this.m_9236_().m_6443_(LivingEntity.class, this.m_20191_().m_82400_(1000.0), e -> !(e instanceof DiexvCreeperEntity) && !(e instanceof Player) && e != this.m_19749_() && !e.equals((Object)this));
        this.target = !entities.isEmpty() ? (LivingEntity)entities.stream().min(Comparator.comparingDouble(e -> e.m_20280_((Entity)this))).orElse(null) : null;
    }

    private void trackTarget() {
        Vec3 targetPos = this.target.m_20182_();
        Vec3 currentPos = this.m_20182_();
        Vec3 direction = targetPos.m_82546_(currentPos).m_82541_();
        Vec3 currentMotion = this.m_20184_();
        Vec3 newMotion = currentMotion.m_82549_(direction.m_82490_(1.0)).m_82541_().m_82490_(currentMotion.m_82553_());
        this.m_20256_(newMotion);
    }

    public static BombEntity shoot(Level world, LivingEntity entity, RandomSource source) {
        return BombEntity.shoot(world, entity, source, 1.25f, 10.0, 0);
    }

    public static BombEntity shoot(Level world, LivingEntity entity, RandomSource source, float pullingPower) {
        return BombEntity.shoot(world, entity, source, pullingPower * 1.25f, 10.0, 0);
    }

    public static BombEntity shoot(Level world, LivingEntity entity, RandomSource random, float power, double damage, int knockback) {
        BombEntity entityarrow = new BombEntity((EntityType<? extends BombEntity>)((EntityType)DiexvcreeperModEntities.BOMB.get()), entity, world);
        entityarrow.m_6686_(entity.m_20252_((float)1.0f).f_82479_, entity.m_20252_((float)1.0f).f_82480_, entity.m_20252_((float)1.0f).f_82481_, power * 2.0f, 0.0f);
        entityarrow.m_20225_(true);
        entityarrow.m_36762_(false);
        entityarrow.m_36781_(damage);
        entityarrow.m_36735_(knockback);
        world.m_7967_((Entity)entityarrow);
        return entityarrow;
    }

    public static BombEntity shoot(LivingEntity entity, LivingEntity target) {
        BombEntity entityarrow = new BombEntity((EntityType<? extends BombEntity>)((EntityType)DiexvcreeperModEntities.BOMB.get()), entity, entity.m_9236_());
        double dx = target.m_20185_() - entity.m_20185_();
        double dy = target.m_20186_() + (double)target.m_20192_() - 1.1;
        double dz = target.m_20189_() - entity.m_20189_();
        entityarrow.m_6686_(dx, dy - entityarrow.m_20186_() + Math.hypot(dx, dz) * (double)0.2f, dz, 2.5f, 12.0f);
        entityarrow.m_20225_(true);
        entityarrow.m_36781_(10.0);
        entityarrow.m_36735_(0);
        entityarrow.m_36762_(false);
        entity.m_9236_().m_7967_((Entity)entityarrow);
        return entityarrow;
    }
}

