/*
 * Decompiled with CFR 0.152.
 */
package net.diexv.diexvcreeper.entity;

import net.diexv.diexvcreeper.DiexvcreeperMod;
import net.diexv.diexvcreeper.entity.BombEntity;
import net.diexv.diexvcreeper.init.DiexvcreeperModEntities;
import net.diexv.diexvcreeper.network.DiexvHealthSyncPacket;
import net.diexv.diexvcreeper.util.DiexvUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.PowerableMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;

public class DiexvCreeperEntity
extends PathfinderMob
implements RangedAttackMob,
PowerableMob {
    private float diexv = 1000.0f;
    private final float bigDiexv = 1000.0f;
    public static final String CUSTOM_DAMAGE_SOURCE = "diexv_custom_damage";
    private boolean isReviving = false;
    private float swelling;
    private int oldSwelling;
    private boolean powered = true;

    public DiexvCreeperEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<DiexvCreeperEntity>)((EntityType)DiexvcreeperModEntities.DIEXV_CREEPER.get()), world);
    }

    public DiexvCreeperEntity(EntityType<DiexvCreeperEntity> type, Level world) {
        super(type, world);
        this.m_274367_(0.6f);
        this.f_21364_ = 0;
        this.m_21557_(false);
        this.m_6593_((Component)Component.m_237113_((String)"Creeper\uff1f"));
        this.m_20340_(true);
        this.m_21530_();
        this.m_21153_(1000.0f);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, true, true));
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal(this, 1.2, true){

            protected double m_6639_(LivingEntity entity) {
                return this.f_25540_.m_20205_() * this.f_25540_.m_20205_() + entity.m_20205_();
            }
        });
        this.f_21345_.m_25352_(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(4, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(6, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new RangedAttackGoal(this, 1.25, 10, 20.0f){

            public boolean m_8045_() {
                return this.m_8036_();
            }
        });
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.creeper.hurt"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.creeper.death"));
    }

    public void m_6504_(LivingEntity target, float flval) {
        BombEntity.shoot((LivingEntity)this, target);
    }

    public static void init() {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.3);
        builder = builder.m_22268_(Attributes.f_22276_, 1000.0);
        builder = builder.m_22268_(Attributes.f_22284_, 0.0);
        builder = builder.m_22268_(Attributes.f_22281_, 3.0);
        builder = builder.m_22268_(Attributes.f_22277_, 64.0);
        builder = builder.m_22268_(Attributes.f_22278_, 1.0);
        return builder;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.haveDiexv() > 0.0f) {
            this.giveDiexv(this.haveDiexv() + 1.0f);
        }
        this.checkCustomLifeDeath();
    }

    public float haveDiexv() {
        if (DiexvUtil.GetHealth) {
            return 1000.0f;
        }
        if (this.m_9236_().f_46443_) {
            return this.diexv;
        }
        return this.diexv;
    }

    public float haveBigDiexv() {
        if (DiexvUtil.GetHealth) {
            return 1000.0f;
        }
        return 1000.0f;
    }

    public void giveDiexv(float health) {
        float oldHealth = this.diexv;
        this.diexv = Mth.m_14036_((float)health, (float)0.0f, (float)1000.0f);
        if (!this.m_9236_().f_46443_ && oldHealth != this.diexv) {
            this.syncHealthToClients();
        }
        this.checkCustomLifeDeath();
    }

    public void receiveHealthUpdate(float newHealth) {
        if (this.m_9236_().f_46443_) {
            this.diexv = newHealth;
        }
    }

    public boolean damageDiexv(float amount) {
        SoundEvent hurtSound;
        if (amount <= 0.0f || this.diexv <= 0.0f) {
            return false;
        }
        float newHealth = this.diexv - amount;
        this.giveDiexv(newHealth);
        if (!this.m_9236_().f_46443_ && this.diexv > 0.0f && (hurtSound = this.m_7975_(this.m_269291_().m_269264_())) != null) {
            this.m_5496_(hurtSound, 1.0f, 1.0f);
        }
        return true;
    }

    public void healCustomLife(float amount) {
        if (amount <= 0.0f) {
            return;
        }
        this.giveDiexv(this.diexv + amount);
    }

    private void checkCustomLifeDeath() {
        SoundEvent deathSound;
        if (this.diexv <= 0.0f && !this.isCustomLifeAlive() && (deathSound = this.m_5592_()) != null) {
            this.m_5496_(deathSound, 1.0f, 1.0f);
        }
    }

    public float getCustomLifePercent() {
        return this.diexv / 1000.0f;
    }

    public boolean isCustomLifeAlive() {
        return this.diexv > 0.0f;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        SoundEvent hurtSound;
        if (this.isCustomDamageSource(source)) {
            boolean result = this.damageDiexv(amount);
            if (result && !this.m_9236_().f_46443_) {
                this.m_9236_().m_7605_((Entity)this, (byte)2);
                SoundEvent hurtSound2 = this.m_7975_(source);
                if (hurtSound2 != null) {
                    this.m_5496_(hurtSound2, 1.0f, 1.0f);
                }
            }
            return result;
        }
        if (!this.m_9236_().f_46443_ && (hurtSound = this.m_7975_(source)) != null) {
            this.m_5496_(hurtSound, 1.0f, 1.0f);
        }
        return super.m_6469_(source, amount);
    }

    private boolean isCustomDamageSource(DamageSource source) {
        return source.m_19385_().equals(CUSTOM_DAMAGE_SOURCE);
    }

    public boolean m_21224_() {
        return this.diexv <= 0.0f;
    }

    public void m_6667_(DamageSource damageSource) {
        if (this.diexv <= 0.0f) {
            super.m_6667_(damageSource);
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128350_("DiexvCustomHealth", this.diexv);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("DiexvCustomHealth")) {
            this.diexv = compound.m_128457_("DiexvCustomHealth");
        }
    }

    public float getSwelling(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.oldSwelling, (float)this.swelling);
    }

    public boolean m_7090_() {
        return DiexvUtil.creeper_armor;
    }

    public void m_6021_(double x, double y, double z) {
        System.out.println("DiexvCreeper \u7981\u6b62\u4f20\u9001");
    }

    public void m_6034_(double x, double y, double z) {
        if (y >= -64.0 && y <= 320.0 && Math.abs(x) < 3.0E7 && Math.abs(z) < 3.0E7) {
            super.m_6034_(x, y, z);
        } else {
            System.out.println("\u963b\u6b62DiexvCreeper\u8fdc\u8ddd\u79bb\u4f20\u9001: (" + x + ", " + y + ", " + z + ")");
        }
    }

    public Entity m_5489_(ServerLevel destination) {
        System.out.println("\u963b\u6b62DiexvCreeper\u7ef4\u5ea6\u8f6c\u6362\u81f3: " + String.valueOf(destination.m_46472_().m_135782_()));
        return this;
    }

    public boolean m_142389_() {
        return true;
    }

    public boolean m_142391_() {
        return true;
    }

    public boolean m_21532_() {
        return true;
    }

    public void m_6043_() {
    }

    public void m_6074_() {
        if (this.diexv <= 0.0f) {
            super.m_6074_();
        }
    }

    public boolean m_6084_() {
        return this.diexv > 0.0f && super.m_6084_();
    }

    public void syncHealthToClients() {
        if (!this.m_9236_().f_46443_ && this.m_9236_() instanceof ServerLevel) {
            DiexvHealthSyncPacket packet = new DiexvHealthSyncPacket(this.m_19879_(), this.diexv);
            DiexvcreeperMod.PACKET_HANDLER_I.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> this), (Object)packet);
        }
    }
}

