/*
 * Decompiled with CFR 0.152.
 */
package net.diexv.diexvcreeper.mixin;

import net.diexv.diexvcreeper.util.EntityStateManager;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public abstract class DeathTimeLockMixin {
    @Shadow
    public int f_20919_;
    private int originalDeathTime = 0;
    private boolean deathTimeLocked = false;

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void onTick(CallbackInfo ci) {
        LivingEntity entity = (LivingEntity)this;
        if (EntityStateManager.isEntityFalling(entity)) {
            if (!this.deathTimeLocked) {
                this.originalDeathTime = this.f_20919_;
                this.deathTimeLocked = true;
            }
            this.f_20919_ = this.f_20919_ < 20 ? ++this.f_20919_ : 20;
        } else if (this.deathTimeLocked) {
            this.f_20919_ = this.originalDeathTime;
            this.deathTimeLocked = false;
        }
    }

    @Inject(method={"actuallyHurt"}, at={@At(value="HEAD")}, cancellable=true)
    private void onActuallyHurt(CallbackInfo ci) {
        LivingEntity entity = (LivingEntity)this;
        if (EntityStateManager.isEntityFalling(entity)) {
            ci.cancel();
        }
    }
}

