/*
 * Decompiled with CFR 0.152.
 */
package net.diexv.diexvcreeper.mixin;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.diexv.diexvcreeper.entity.DiexvCreeperEntity;
import net.diexv.diexvcreeper.init.DiexvcreeperModEntities;
import net.diexv.diexvcreeper.util.DiexvUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.phys.AABB;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerLevel.class})
public abstract class DiexvCreeperReviveMixin {
    private static final Map<ResourceKey<Level>, Boolean> hasSpawnedOnceMap = new HashMap<ResourceKey<Level>, Boolean>();
    private static final Map<ResourceKey<Level>, BlockPos> lastKnownPosMap = new HashMap<ResourceKey<Level>, BlockPos>();
    private static final int CHECK_INTERVAL = 1;
    private int tickCounter = 0;

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void onServerTick(CallbackInfo ci) {
        DiexvCreeperEntity firstCreeper;
        BlockPos newPos;
        AABB searchBounds;
        ServerLevel level = (ServerLevel)this;
        ResourceKey dimension = level.m_46472_();
        if (!DiexvUtil.revive || ++this.tickCounter % 1 != 0) {
            return;
        }
        hasSpawnedOnceMap.putIfAbsent((ResourceKey<Level>)dimension, false);
        lastKnownPosMap.putIfAbsent((ResourceKey<Level>)dimension, null);
        boolean hasSpawnedOnce = hasSpawnedOnceMap.get(dimension);
        BlockPos lastKnownPos = lastKnownPosMap.get(dimension);
        if (lastKnownPos != null) {
            searchBounds = new AABB((double)(lastKnownPos.m_123341_() - 16), (double)level.m_141937_(), (double)(lastKnownPos.m_123343_() - 16), (double)(lastKnownPos.m_123341_() + 16), (double)level.m_151558_(), (double)(lastKnownPos.m_123343_() + 16));
        } else {
            WorldBorder worldBorder = level.m_6857_();
            searchBounds = new AABB(worldBorder.m_61955_(), (double)level.m_141937_(), worldBorder.m_61956_(), worldBorder.m_61957_(), (double)level.m_151558_(), worldBorder.m_61958_());
        }
        List creepers = level.m_45976_(DiexvCreeperEntity.class, searchBounds);
        if (!hasSpawnedOnce && !creepers.isEmpty()) {
            hasSpawnedOnceMap.put((ResourceKey<Level>)dimension, true);
            hasSpawnedOnce = true;
        }
        if (hasSpawnedOnce && !creepers.isEmpty() && !(newPos = new BlockPos((int)(firstCreeper = (DiexvCreeperEntity)((Object)creepers.get(0))).m_20185_(), (int)firstCreeper.m_20186_(), (int)firstCreeper.m_20189_())).equals((Object)lastKnownPos)) {
            lastKnownPosMap.put((ResourceKey<Level>)dimension, newPos);
        }
        if (hasSpawnedOnce && creepers.isEmpty() && lastKnownPos != null) {
            DiexvCreeperEntity newCreeper = new DiexvCreeperEntity((EntityType<DiexvCreeperEntity>)((EntityType)DiexvcreeperModEntities.DIEXV_CREEPER.get()), (Level)level);
            newCreeper.m_6034_(lastKnownPos.m_123341_(), lastKnownPos.m_123342_(), lastKnownPos.m_123343_());
            level.m_7967_((Entity)newCreeper);
        }
    }
}

