/*
 * Decompiled with CFR 0.152.
 */
package net.diexv.diexvcreeper.mixin;

import net.diexv.diexvcreeper.init.DiexvcreeperModItems;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.event.RenderTooltipEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={RenderTooltipEvent.Color.class})
public abstract class TooltipColorMixin {
    @Unique
    private static final int BLUE_COLOR = -11549705;
    @Unique
    private static final int WHITE_COLOR = -1;
    @Unique
    private static final long COLOR_CYCLE_TIME = 3000L;

    @Unique
    private int getCurrentGradientColor() {
        float progress = (float)(System.currentTimeMillis() % 3000L) / 3000.0f;
        float lerpFactor = (float)Math.sin((double)progress * Math.PI * 2.0) * 0.5f + 0.5f;
        return this.lerpColor(-11549705, -1, lerpFactor);
    }

    @Unique
    private int lerpColor(int startColor, int endColor, float factor) {
        int r = (int)((float)(startColor >> 16 & 0xFF) * (1.0f - factor) + (float)(endColor >> 16 & 0xFF) * factor);
        int g = (int)((float)(startColor >> 8 & 0xFF) * (1.0f - factor) + (float)(endColor >> 8 & 0xFF) * factor);
        int b = (int)((float)(startColor & 0xFF) * (1.0f - factor) + (float)(endColor & 0xFF) * factor);
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    @Inject(method={"getBorderStart"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void overrideBorderStart(CallbackInfoReturnable<Integer> cir) {
        if (this.isTargetItem()) {
            cir.setReturnValue((Object)this.getCurrentGradientColor());
        }
    }

    @Inject(method={"getBorderEnd"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void overrideBorderEnd(CallbackInfoReturnable<Integer> cir) {
        if (this.isTargetItem()) {
            long offsetTime = (System.currentTimeMillis() + 750L) % 3000L;
            float progress = (float)offsetTime / 3000.0f;
            float lerpFactor = (float)Math.sin((double)progress * Math.PI * 2.0) * 0.5f + 0.5f;
            cir.setReturnValue((Object)this.lerpColor(-11549705, -1, lerpFactor));
        }
    }

    @Inject(method={"getBackgroundStart"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void overrideBackgroundStart(CallbackInfoReturnable<Integer> cir) {
        if (this.isTargetItem()) {
            cir.setReturnValue((Object)(this.getCurrentGradientColor() & 0x77FFFFFF));
        }
    }

    @Inject(method={"getBackgroundEnd"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void overrideBackgroundEnd(CallbackInfoReturnable<Integer> cir) {
        if (this.isTargetItem()) {
            cir.setReturnValue((Object)(this.getCurrentGradientColor() & 0x55FFFFFF));
        }
    }

    @Unique
    private boolean isTargetItem() {
        RenderTooltipEvent.Color event = (RenderTooltipEvent.Color)this;
        ItemStack stack = event.getItemStack();
        return stack != null && (stack.m_41720_() == DiexvcreeperModItems.DIEXV_SWORD.get() || stack.m_41720_() == DiexvcreeperModItems.DIEXV_CREEPER_SPAWN_EGG.get());
    }
}

