/*
 * Decompiled with CFR 0.152.
 */
package net.diexv.diexvcreeper.network;

import java.util.function.Supplier;
import net.diexv.diexvcreeper.entity.DiexvCreeperEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class DiexvHealthSyncPacket {
    private final int entityId;
    private final float health;

    public DiexvHealthSyncPacket(int entityId, float health) {
        this.entityId = entityId;
        this.health = health;
    }

    public DiexvHealthSyncPacket(FriendlyByteBuf buffer) {
        this.entityId = buffer.readInt();
        this.health = buffer.readFloat();
    }

    public void toBytes(FriendlyByteBuf buffer) {
        buffer.writeInt(this.entityId);
        buffer.writeFloat(this.health);
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isClient()) {
            context.enqueueWork(() -> this.handleClient());
        }
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void handleClient() {
        Entity entity;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null && (entity = level.m_6815_(this.entityId)) instanceof DiexvCreeperEntity) {
            DiexvCreeperEntity diexvCreeper = (DiexvCreeperEntity)entity;
            diexvCreeper.receiveHealthUpdate(this.health);
        }
    }
}

