/*
 * Decompiled with CFR 0.152.
 */
package net.diexv.diexvcreeper.util;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;

public class EntityStateManager {
    private static final Map<LivingEntity, Long> fallingEntities = new ConcurrentHashMap<LivingEntity, Long>();
    private static final Map<LivingEntity, Long> entitiesToRemove = new ConcurrentHashMap<LivingEntity, Long>();

    public static void markEntityFalling(LivingEntity entity) {
        fallingEntities.put(entity, System.currentTimeMillis());
        entity.m_20331_(true);
        entity.m_20242_(true);
        entity.m_21153_(0.0f);
        entity.f_20919_ = 1;
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            mob.m_21557_(true);
        }
    }

    public static boolean isEntityFalling(LivingEntity entity) {
        return fallingEntities.containsKey(entity);
    }

    public static boolean isEntityMarkedForRemoval(LivingEntity entity) {
        return entitiesToRemove.containsKey(entity);
    }

    public static void markEntityForRemoval(LivingEntity entity) {
        entitiesToRemove.put(entity, System.currentTimeMillis());
    }

    public static void removeEntityState(LivingEntity entity) {
        fallingEntities.remove(entity);
        entitiesToRemove.remove(entity);
        entity.m_20242_(false);
        entity.m_20331_(false);
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            mob.m_21557_(false);
        }
    }

    public static long getFallStartTime(LivingEntity entity) {
        return fallingEntities.getOrDefault(entity, 0L);
    }

    public static void updateAllEntities() {
        long currentTime = System.currentTimeMillis();
        Iterator<Map.Entry<LivingEntity, Long>> iterator = entitiesToRemove.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<LivingEntity, Long> entry = iterator.next();
            LivingEntity entity2 = entry.getKey();
            long startTime = entry.getValue();
            if (!entity2.m_6084_() || entity2.m_213877_()) {
                iterator.remove();
                fallingEntities.remove(entity2);
                continue;
            }
            if (currentTime - startTime < 1000L) continue;
            entity2.m_20242_(false);
            entity2.m_20331_(false);
            if (entity2 instanceof Mob) {
                Mob mob = (Mob)entity2;
                mob.m_21557_(false);
            }
            entity2.m_142687_(Entity.RemovalReason.DISCARDED);
            iterator.remove();
            fallingEntities.remove(entity2);
        }
        fallingEntities.keySet().removeIf(entity -> !entity.m_6084_() || entity.m_213877_());
    }
}

