/*
 * Decompiled with CFR 0.152.
 */
package net.diexv.diexvcreeper.mixin;

import net.diexv.diexvcreeper.entity.DiexvCreeperEntity;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public abstract class DiexvCreeperHealthMixin {
    @Unique
    private int diexv$deathEffectTimer = -1;
    @Unique
    private boolean diexv$hasTriggered = false;

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void onTick(CallbackInfo ci) {
        LivingEntity entity = (LivingEntity)this;
        if (!(entity instanceof DiexvCreeperEntity)) {
            return;
        }
        DiexvCreeperEntity creeper = (DiexvCreeperEntity)entity;
        if (creeper.m_21223_() <= 0.0f) {
            if (!this.diexv$hasTriggered) {
                this.diexv$hasTriggered = true;
                this.diexv$deathEffectTimer = 0;
                this.playDeathSound(creeper);
            }
            if (this.diexv$deathEffectTimer >= 0 && this.diexv$deathEffectTimer < 200) {
                this.playContinuousDeathEffects(creeper, this.diexv$deathEffectTimer);
                ++this.diexv$deathEffectTimer;
            }
        } else {
            this.resetDeathEffects();
        }
    }

    @Unique
    private void resetDeathEffects() {
        this.diexv$hasTriggered = false;
        this.diexv$deathEffectTimer = -1;
    }

    @Unique
    private void playDeathSound(DiexvCreeperEntity creeper) {
        Level level = creeper.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        serverLevel.m_6263_(null, creeper.m_20185_(), creeper.m_20186_(), creeper.m_20189_(), SoundEvents.f_11891_, SoundSource.HOSTILE, 4.0f, 0.8f + creeper.m_217043_().m_188501_() * 0.2f);
    }

    @Unique
    private void playContinuousDeathEffects(DiexvCreeperEntity creeper, int timer) {
        Level level = creeper.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        float progress = (float)timer / 200.0f;
        if (timer % 5 == 0) {
            int count = 12 - (int)(progress * 8.0f);
            for (int i = 0; i < count; ++i) {
                double angle = (double)i * Math.PI * 2.0 / (double)count;
                double radius = 5.0f * (1.0f - progress * 0.5f);
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123796_, creeper.m_20185_() + Math.cos(angle) * radius, creeper.m_20186_() + 1.0, creeper.m_20189_() + Math.sin(angle) * radius, 2, 0.0, 0.3, 0.0, 0.05);
            }
        }
        if (timer % 5 == 0) {
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_175830_, creeper.m_20185_(), creeper.m_20186_() + 2.0, creeper.m_20189_(), (int)(5.0f + progress * 10.0f), 0.3, 0.3, 0.3, 0.1);
        }
        if (timer % 3 == 0) {
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123747_, creeper.m_20185_(), creeper.m_20186_() + 1.5, creeper.m_20189_(), 3, 0.0, 0.0, 0.0, 0.0);
        }
    }
}

