/*
 * Decompiled with CFR 0.152.
 */
package net.diexv.diexvcreeper.mixin;

import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityHealthLockMixin {
    @Unique
    private boolean diexvHealthLocked = false;

    @Inject(method={"hurt"}, at={@At(value="HEAD")})
    private void onDiexvDamage(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        if (source.m_276093_(LivingEntityHealthLockMixin.diexvKillKey())) {
            this.diexvHealthLocked = true;
            ((LivingEntity)this).m_21153_(0.0f);
        }
    }

    @ModifyVariable(method={"setHealth"}, at=@At(value="HEAD"), ordinal=0, argsOnly=true)
    private float modifyHealthValue(float original) {
        return this.diexvHealthLocked && original > 0.0f ? 0.0f : original;
    }

    @Inject(method={"heal"}, at={@At(value="HEAD")}, cancellable=true)
    private void onHeal(float amount, CallbackInfo ci) {
        if (this.diexvHealthLocked) {
            ci.cancel();
        }
    }

    @Inject(method={"onSyncedDataUpdated"}, at={@At(value="HEAD")})
    private void onDataUpdate(CallbackInfo ci) {
        LivingEntity self;
        if (this.diexvHealthLocked && (self = (LivingEntity)this).m_21223_() > 0.0f) {
            self.m_21153_(0.0f);
        }
    }

    @Inject(method={"die"}, at={@At(value="HEAD")})
    private void onDeath(DamageSource damageSource, CallbackInfo ci) {
        this.diexvHealthLocked = false;
    }

    private static ResourceKey<DamageType> diexvKillKey() {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)new ResourceLocation("diexvcreeper", "diexv_kill"));
    }
}

