/*
 * Decompiled with CFR 0.152.
 */
package net.diexv.diexvcreeper.SkyRender.client.model;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.mojang.math.Transformation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.diexv.diexvcreeper.DiexvcreeperMod;
import net.diexv.diexvcreeper.SkyRender.api.client.model.PerspectiveModelState;
import net.diexv.diexvcreeper.SkyRender.client.shader.AvaritiaShaders;
import net.diexv.diexvcreeper.SkyRender.util.client.TransformUtils;
import net.diexv.diexvcreeper.init.DiexvcreeperModItems;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.ItemModelGenerator;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public final class CosmicBakeModel
implements BakedModel {
    private static final ItemModelGenerator ITEM_MODEL_GENERATOR = new ItemModelGenerator();
    private static final FaceBakery FACE_BAKERY = new FaceBakery();
    private final List<ResourceLocation> maskSprite;
    private final BakedModel wrapped;
    private final ItemOverrides overrideList = new ItemOverrides(){

        public BakedModel m_173464_(@NotNull BakedModel originalModel, @NotNull ItemStack stack, ClientLevel world, LivingEntity entity, int seed) {
            CosmicBakeModel.this.entity = entity;
            CosmicBakeModel.this.world = world == null ? (entity == null ? null : (ClientLevel)entity.m_9236_()) : null;
            return CosmicBakeModel.this.wrapped.m_7343_().m_173464_(originalModel, stack, world, entity, seed);
        }
    };
    private ModelState parentState;
    private LivingEntity entity;
    private ClientLevel world;

    public CosmicBakeModel(BakedModel wrapped, List<ResourceLocation> maskSprite) {
        this.wrapped = wrapped;
        this.parentState = TransformUtils.stateFromItemTransforms(wrapped.m_7442_());
        this.maskSprite = maskSprite;
    }

    public void renderItem(ItemStack stack, ItemDisplayContext transformType, PoseStack pStack, MultiBufferSource buffers, int packedLight, int packedOverlay) {
        if (stack.m_41720_() == DiexvcreeperModItems.DIEXV_SWORD.get()) {
            this.parentState = TransformUtils.DEFAULT_TOOL;
        }
        BakedModel model = this.wrapped.m_7343_().m_173464_(this.wrapped, stack, this.world, this.entity, 0);
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        assert (model != null);
        for (BakedModel bakedModel : model.getRenderPasses(stack, true)) {
            for (RenderType rendertype : bakedModel.getRenderTypes(stack, true)) {
                itemRenderer.m_115189_(bakedModel, stack, packedLight, packedOverlay, pStack, buffers.m_6299_(rendertype));
            }
        }
        if (buffers instanceof MultiBufferSource.BufferSource) {
            MultiBufferSource.BufferSource bs = (MultiBufferSource.BufferSource)buffers;
            bs.m_109911_();
        }
        Minecraft mc = Minecraft.m_91087_();
        float yaw = 0.0f;
        float pitch = 0.0f;
        float scale = 1.0f;
        if (AvaritiaShaders.inventoryRender || transformType == ItemDisplayContext.GUI) {
            scale = 100.0f;
        } else {
            assert (mc.f_91074_ != null);
            yaw = (float)((double)(mc.f_91074_.m_146908_() * 2.0f) * Math.PI / 360.0);
            pitch = -((float)((double)(mc.f_91074_.m_146909_() * 2.0f) * Math.PI / 360.0));
        }
        AvaritiaShaders.cosmicTime.m_5985_((float)(System.currentTimeMillis() - (long)AvaritiaShaders.renderTime) / 2000.0f);
        AvaritiaShaders.cosmicYaw.m_5985_(yaw);
        AvaritiaShaders.cosmicPitch.m_5985_(pitch);
        AvaritiaShaders.cosmicExternalScale.m_5985_(scale);
        AvaritiaShaders.cosmicOpacity.m_5985_(1.0f);
        for (int i = 0; i < 10; ++i) {
            TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(DiexvcreeperMod.rl("item/misc/cosmic_" + i));
            AvaritiaShaders.COSMIC_UVS[i * 4] = sprite.m_118409_();
            AvaritiaShaders.COSMIC_UVS[i * 4 + 1] = sprite.m_118411_();
            AvaritiaShaders.COSMIC_UVS[i * 4 + 2] = sprite.m_118410_();
            AvaritiaShaders.COSMIC_UVS[i * 4 + 3] = sprite.m_118412_();
        }
        AvaritiaShaders.cosmicUVs.m_5941_(AvaritiaShaders.COSMIC_UVS);
        VertexConsumer cons = buffers.m_6299_(AvaritiaShaders.COSMIC_RENDER_TYPE);
        ArrayList<TextureAtlasSprite> atlasSprite = new ArrayList<TextureAtlasSprite>();
        for (ResourceLocation res : this.maskSprite) {
            atlasSprite.add((TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(res));
        }
        LinkedList<BakedQuad> quads = new LinkedList<BakedQuad>();
        for (TextureAtlasSprite sprite : atlasSprite) {
            List unbaked = ITEM_MODEL_GENERATOR.m_111638_(atlasSprite.indexOf(sprite), "layer" + atlasSprite.indexOf(sprite), sprite.m_245424_());
            for (BlockElement element : unbaked) {
                for (Map.Entry entry : element.f_111310_.entrySet()) {
                    quads.add(FACE_BAKERY.m_111600_(element.f_111308_, element.f_111309_, (BlockElementFace)entry.getValue(), sprite, (Direction)entry.getKey(), (ModelState)new PerspectiveModelState((Map<ItemDisplayContext, Transformation>)ImmutableMap.of()), element.f_111311_, element.f_111312_, DiexvcreeperMod.rl("dynamic")));
                }
            }
        }
        mc.m_91291_().m_115162_(pStack, cons, quads, stack, packedLight, packedOverlay);
    }

    public boolean m_7521_() {
        return true;
    }

    @NotNull
    public BakedModel applyTransform(@NotNull ItemDisplayContext context, @NotNull PoseStack pStack, boolean leftFlip) {
        PerspectiveModelState modelState = (PerspectiveModelState)this.parentState;
        if (modelState != null) {
            Transformation transform = ((PerspectiveModelState)this.parentState).getTransform(context);
            Vector3f trans = transform.m_252829_();
            Vector3f scale = transform.m_252900_();
            pStack.m_252880_(trans.x(), trans.y(), trans.z());
            pStack.m_252781_(transform.m_253244_());
            pStack.m_85841_(scale.x(), scale.y(), scale.z());
            pStack.m_252781_(transform.m_252848_());
            if (leftFlip) {
                pStack.m_252781_(Axis.f_252392_.m_252977_(180.0f));
            }
            return this;
        }
        return super.applyTransform(context, pStack, leftFlip);
    }

    @NotNull
    public List<BakedQuad> m_213637_(BlockState state, Direction side, @NotNull RandomSource rand) {
        return Collections.emptyList();
    }

    @NotNull
    public TextureAtlasSprite m_6160_() {
        return this.wrapped.m_6160_();
    }

    @NotNull
    public TextureAtlasSprite getParticleIcon(@NotNull ModelData data) {
        return this.wrapped.getParticleIcon(data);
    }

    @NotNull
    public ItemOverrides m_7343_() {
        return this.overrideList;
    }

    public boolean m_7541_() {
        return this.wrapped.m_7541_();
    }

    public boolean m_7539_() {
        return this.wrapped.m_7539_();
    }

    public boolean m_7547_() {
        return this.wrapped.m_7547_();
    }
}

