/*
 * Decompiled with CFR 0.152.
 */
package net.diexv.diexvcreeper.SkyRender.util.client;

import com.google.common.collect.ImmutableMap;
import com.mojang.math.Transformation;
import java.util.HashMap;
import java.util.Map;
import net.diexv.diexvcreeper.SkyRender.api.client.model.PerspectiveModelState;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.world.item.ItemDisplayContext;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public final class TransformUtils {
    public static final PerspectiveModelState IDENTITY = PerspectiveModelState.IDENTITY;
    public static final PerspectiveModelState DEFAULT_TOOL;
    public static final double torad = 0.017453292519943;

    public static Transformation create(float tx, float ty, float tz, float rx, float ry, float rz, float s) {
        return TransformUtils.create(new Vector3f(tx / 16.0f, ty / 16.0f, tz / 16.0f), new Vector3f(rx, ry, rz), new Vector3f(s, s, s));
    }

    public static Transformation create(Vector3f transform, Vector3f rotation, Vector3f scale) {
        return new Transformation(transform, new Quaternionf().rotationXYZ((float)((double)rotation.x() * 0.017453292519943), (float)((double)rotation.y() * 0.017453292519943), (float)((double)rotation.z() * 0.017453292519943)), scale, null);
    }

    public static Transformation create(ItemTransform transform) {
        if (ItemTransform.f_111754_.equals((Object)transform)) {
            return Transformation.m_121093_();
        }
        return TransformUtils.create(transform.f_111756_, transform.f_111755_, transform.f_111757_);
    }

    public static ModelState stateFromItemTransforms(ItemTransforms itemTransforms) {
        if (itemTransforms == ItemTransforms.f_111786_) {
            return IDENTITY;
        }
        ImmutableMap.Builder map = ImmutableMap.builder();
        for (ItemDisplayContext value : ItemDisplayContext.values()) {
            map.put((Object)value, (Object)TransformUtils.create(itemTransforms.m_269404_(value)));
        }
        return new PerspectiveModelState((Map<ItemDisplayContext, Transformation>)map.build());
    }

    static {
        HashMap<ItemDisplayContext, Transformation> map = new HashMap<ItemDisplayContext, Transformation>();
        map.put(ItemDisplayContext.GROUND, TransformUtils.create(0.0f, 2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f));
        map.put(ItemDisplayContext.FIXED, TransformUtils.create(0.0f, 0.0f, 0.0f, 0.0f, 180.0f, 0.0f, 1.0f));
        map.put(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, TransformUtils.create(0.0f, 4.0f, 0.5f, 0.0f, -90.0f, 55.0f, 0.85f));
        map.put(ItemDisplayContext.THIRD_PERSON_LEFT_HAND, TransformUtils.create(0.0f, 4.0f, 0.5f, 0.0f, 90.0f, -55.0f, 0.85f));
        map.put(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND, TransformUtils.create(1.13f, 3.2f, 1.13f, 0.0f, -90.0f, 25.0f, 0.68f));
        map.put(ItemDisplayContext.FIRST_PERSON_LEFT_HAND, TransformUtils.create(1.13f, 3.2f, 1.13f, 0.0f, 90.0f, -25.0f, 0.68f));
        DEFAULT_TOOL = new PerspectiveModelState((Map<ItemDisplayContext, Transformation>)ImmutableMap.copyOf(map));
    }
}

