/*
 * Decompiled with CFR 0.152.
 */
package net.diexv.diexvcreeper.client;

import net.diexv.diexvcreeper.entity.DiexvCreeperEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;

public class BossBarHUD
implements IGuiOverlay {
    private static final ResourceLocation CREEPER_HEAD_TEXTURE = new ResourceLocation("diexvcreeper", "textures/entities/diexv_creeper_face.png");

    public void render(ForgeGui gui, GuiGraphics guiGraphics, float partialTicks, int width, int height) {
        Minecraft mc = Minecraft.m_91087_();
        mc.f_91073_.m_6443_(DiexvCreeperEntity.class, mc.f_91074_.m_20191_().m_82400_(100.0), entity -> !entity.m_213877_()).forEach(creeper -> this.renderBossBarWithHead(guiGraphics, width, (DiexvCreeperEntity)((Object)creeper)));
    }

    private void renderBossBarWithHead(GuiGraphics guiGraphics, int screenWidth, DiexvCreeperEntity creeper) {
        int barWidth = 200;
        int barHeight = 10;
        int headSize = 20;
        int barX = (screenWidth - barWidth) / 2;
        int barY = 30;
        int headX = (screenWidth - headSize) / 2;
        int headY = barY - headSize - 1;
        guiGraphics.m_280411_(CREEPER_HEAD_TEXTURE, headX, headY, headSize, headSize, 0.0f, 0.0f, 64, 64, 64, 64);
        guiGraphics.m_280509_(barX, barY, barX + barWidth, barY + barHeight, -2130706433);
        float healthRatio = creeper.m_21223_() / creeper.m_21233_();
        int healthWidth = (int)((float)barWidth * healthRatio);
        guiGraphics.m_280509_(barX, barY, barX + healthWidth, barY + barHeight, -1);
        String text = String.format("%.1f / %.1f", Float.valueOf(creeper.m_21223_()), Float.valueOf(creeper.m_21233_()));
        int textX = (screenWidth - Minecraft.m_91087_().f_91062_.m_92895_(text)) / 2;
        int textY = barY + barHeight + 2;
        guiGraphics.m_280056_(Minecraft.m_91087_().f_91062_, text, textX, textY, -1, true);
    }
}

