/*
 * Decompiled with CFR 0.152.
 */
package net.diexv.diexvcreeper.mixin;

import java.util.UUID;
import net.diexv.diexvcreeper.entity.DiexvCreeperEntity;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin {
    @Shadow
    public int f_20919_;
    @Unique
    private static final UUID GLOBAL_MAX_HEALTH_UUID = UUID.fromString("a5f2b0a1-0b0a-4b0a-9b0a-0b0a0b0a0b0a");

    @Shadow
    public abstract void m_21153_(float var1);

    @Inject(method={"getHealth()F"}, at={@At(value="HEAD")}, cancellable=true)
    private void onGetHealth(CallbackInfoReturnable<Float> cir) {
        LivingEntity entity = (LivingEntity)this;
        if (entity.getClass() == DiexvCreeperEntity.class) {
            cir.setReturnValue((Object)Float.valueOf(1000.0f));
        }
    }

    @Inject(method={"setHealth(F)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onSetHealth(float amount, CallbackInfo ci) {
        LivingEntity entity = (LivingEntity)this;
        if (entity.getClass() == DiexvCreeperEntity.class) {
            ci.cancel();
        }
    }

    @Inject(method={"hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void onHurt(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        LivingEntity self;
        if (this instanceof DiexvCreeperEntity && (self = (LivingEntity)this).m_21223_() - amount <= 0.0f) {
            self.m_21153_(1.0f);
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"remove"}, at={@At(value="HEAD")}, cancellable=true)
    private void onRemove(Entity.RemovalReason reason, CallbackInfo ci) {
        if (this instanceof DiexvCreeperEntity) {
            ci.cancel();
        }
    }

    private boolean isTargetEntity() {
        return this instanceof DiexvCreeperEntity;
    }

    @Inject(method={"die"}, at={@At(value="HEAD")}, cancellable=true)
    private void onDeath(DamageSource source, CallbackInfo ci) {
        if (this.isTargetEntity()) {
            LivingEntity self = (LivingEntity)this;
            self.m_21153_(self.m_21233_());
            ci.cancel();
        }
    }

    @Inject(method={"handleEntityEvent"}, at={@At(value="HEAD")}, cancellable=true)
    private void onHandleEntityEvent(byte id, CallbackInfo ci) {
        if (this instanceof DiexvCreeperEntity && id == 3) {
            ci.cancel();
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void onTick(CallbackInfo ci) {
        if (this instanceof DiexvCreeperEntity) {
            Mob self = (Mob)this;
            self.m_21557_(false);
            if (self.f_21346_ != null) {
                self.f_21346_.m_25373_();
            }
            if (self.f_21345_ != null) {
                self.f_21345_.m_25373_();
            }
        }
    }

    @Inject(method={"tickDeath"}, at={@At(value="HEAD")}, cancellable=true)
    private void onTickDeath(CallbackInfo ci) {
        if (this instanceof DiexvCreeperEntity) {
            ci.cancel();
        }
    }

    @Inject(method={"isDeadOrDying"}, at={@At(value="HEAD")}, cancellable=true)
    private void onIsDeadOrDying(CallbackInfoReturnable<Boolean> cir) {
        if (this instanceof DiexvCreeperEntity) {
            cir.setReturnValue((Object)false);
        }
    }
}

