/*
 * Decompiled with CFR 0.152.
 */
package net.diexv.diexvcreeper.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Color;
import net.diexv.diexvcreeper.entity.DiexvCreeperEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntityRenderer.class})
public abstract class LivingEntityRendererMixin<T extends LivingEntity> {
    @Inject(method={"render"}, at={@At(value="TAIL")})
    private void onRender(T entity, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight, CallbackInfo ci) {
        if (entity instanceof DiexvCreeperEntity) {
            DiexvCreeperEntity creeper = (DiexvCreeperEntity)((Object)entity);
            this.renderCustomBossBar(creeper, poseStack, buffer, partialTicks);
        }
    }

    private void renderCustomBossBar(DiexvCreeperEntity creeper, PoseStack poseStack, MultiBufferSource buffer, float partialTicks) {
        if (!(Minecraft.m_91087_().m_91288_() instanceof Player)) {
            return;
        }
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, (double)creeper.m_20206_() + 0.62, 0.0);
        poseStack.m_252781_(Minecraft.m_91087_().m_91290_().m_253208_());
        poseStack.m_85841_(-0.025f, -0.025f, 0.025f);
        float healthRatio = creeper.m_21223_() / creeper.m_21233_();
        float phase = (float)(System.currentTimeMillis() % 10000L) / 10000.0f;
        int bgWidth = 80;
        int bgHeight = 8;
        int bgColor1 = this.getRainbowColor(phase, 0.3f);
        int bgColor2 = this.getRainbowColor(phase + 0.2f, 0.3f);
        this.drawGradientRect(poseStack, -bgWidth / 2, -bgHeight / 2, bgWidth / 2, bgHeight / 2, bgColor1, bgColor2, buffer);
        int fgWidth = (int)((float)bgWidth * healthRatio);
        int fgColor1 = this.getRainbowColor(phase, 1.0f);
        int fgColor2 = this.getRainbowColor(phase + 0.1f, 1.0f);
        this.drawGradientRect(poseStack, -bgWidth / 2, -bgHeight / 2, -bgWidth / 2 + fgWidth, bgHeight / 2, fgColor1, fgColor2, buffer);
        this.drawBorder(poseStack, -bgWidth / 2, -bgHeight / 2, bgWidth / 2, bgHeight / 2, buffer);
        poseStack.m_85849_();
    }

    private int getRainbowColor(float phase, float brightness) {
        return Color.HSBtoRGB(phase, 0.9f, brightness);
    }

    private void drawGradientRect(PoseStack poseStack, int x1, int y1, int x2, int y2, int color1, int color2, MultiBufferSource buffer) {
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        VertexConsumer builder = buffer.m_6299_(RenderType.m_285907_());
        float a1 = (float)(color1 >> 24 & 0xFF) / 255.0f;
        float r1 = (float)(color1 >> 16 & 0xFF) / 255.0f;
        float g1 = (float)(color1 >> 8 & 0xFF) / 255.0f;
        float b1 = (float)(color1 & 0xFF) / 255.0f;
        float a2 = (float)(color2 >> 24 & 0xFF) / 255.0f;
        float r2 = (float)(color2 >> 16 & 0xFF) / 255.0f;
        float g2 = (float)(color2 >> 8 & 0xFF) / 255.0f;
        float b2 = (float)(color2 & 0xFF) / 255.0f;
        builder.m_252986_(matrix, (float)x2, (float)y1, 0.0f).m_85950_(r2, g2, b2, a2).m_5752_();
        builder.m_252986_(matrix, (float)x1, (float)y1, 0.0f).m_85950_(r1, g1, b1, a1).m_5752_();
        builder.m_252986_(matrix, (float)x1, (float)y2, 0.0f).m_85950_(r1, g1, b1, a1).m_5752_();
        builder.m_252986_(matrix, (float)x2, (float)y2, 0.0f).m_85950_(r2, g2, b2, a2).m_5752_();
    }

    private void drawBorder(PoseStack poseStack, int x1, int y1, int x2, int y2, MultiBufferSource buffer) {
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        VertexConsumer builder = buffer.m_6299_(RenderType.m_286086_());
        int borderColor = -1;
        float a = (float)(borderColor >> 24 & 0xFF) / 255.0f;
        float r = (float)(borderColor >> 16 & 0xFF) / 255.0f;
        float g = (float)(borderColor >> 8 & 0xFF) / 255.0f;
        float b = (float)(borderColor & 0xFF) / 255.0f;
        builder.m_252986_(matrix, (float)x1, (float)y1, 0.0f).m_85950_(r, g, b, a).m_5752_();
        builder.m_252986_(matrix, (float)x2, (float)y1, 0.0f).m_85950_(r, g, b, a).m_5752_();
        builder.m_252986_(matrix, (float)x2, (float)y1, 0.0f).m_85950_(r, g, b, a).m_5752_();
        builder.m_252986_(matrix, (float)x2, (float)y2, 0.0f).m_85950_(r, g, b, a).m_5752_();
        builder.m_252986_(matrix, (float)x2, (float)y2, 0.0f).m_85950_(r, g, b, a).m_5752_();
        builder.m_252986_(matrix, (float)x1, (float)y2, 0.0f).m_85950_(r, g, b, a).m_5752_();
        builder.m_252986_(matrix, (float)x1, (float)y2, 0.0f).m_85950_(r, g, b, a).m_5752_();
        builder.m_252986_(matrix, (float)x1, (float)y1, 0.0f).m_85950_(r, g, b, a).m_5752_();
    }
}

