/*
 * Decompiled with CFR 0.152.
 */
package dev.thomas.diggerhelmet.client;

import dev.thomas.diggerhelmet.DiggerHelmet;
import dev.thomas.diggerhelmet.client.SDLLightsAdapter;
import dev.thomas.diggerhelmet.common.item.DiggerHelmetItem;
import dev.thomas.diggerhelmet.integration.CuriosLightingIntegration;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="diggerhelmet", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class DynamicLightingManager {
    private static final Map<Entity, LightSourceData> LIGHT_SOURCES = new ConcurrentHashMap<Entity, LightSourceData>();
    private static final double ARMOR_STAND_LIGHT_HEIGHT = 1.2;
    private static final int LIGHT_LEVEL = 12;
    private static final double RANGE = 24.0;
    private static final int UPDATE_INTERVAL = 5;
    private static final int VISIBILITY_CACHE_DURATION = 60;
    private static final int MAX_LIGHT_SOURCES = 64;
    private static int updateCounter = 0;
    private static final Map<Entity, VisibilityCache> VISIBILITY_CACHE = new ConcurrentHashMap<Entity, VisibilityCache>();
    private static final Set<EntityType<?>> SUPPORTED_ENTITIES = Set.of(EntityType.f_20532_, EntityType.f_20501_, EntityType.f_20458_, EntityType.f_20529_);

    private static Minecraft getMinecraft() {
        return Minecraft.m_91087_();
    }

    public static void setup() {
        if (DiggerHelmet.isSDLLoaded()) {
            SDLLightsAdapter.init();
            DiggerHelmet.LOGGER.info("Using SDL for dynamic lighting");
        } else {
            DiggerHelmet.LOGGER.info("Using optimized fallback dynamic lighting system");
        }
    }

    public static boolean isActive() {
        if (DiggerHelmet.isSDLLoaded()) {
            return SDLLightsAdapter.isInitialized();
        }
        return true;
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && !DiggerHelmet.isSDLLoaded() && ++updateCounter >= 5) {
            updateCounter = 0;
            DynamicLightingManager.updateLightSources();
            DynamicLightingManager.cleanupExpiredCaches();
        }
    }

    @SubscribeEvent
    public static void onRenderLevelStage(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_SOLID_BLOCKS && !DiggerHelmet.isSDLLoaded() && updateCounter == 0) {
            DynamicLightingManager.updateLightSources();
        }
    }

    private static void updateLightSources() {
        ClientLevel level = DynamicLightingManager.getMinecraft().f_91073_;
        LocalPlayer player = DynamicLightingManager.getMinecraft().f_91074_;
        if (level == null || player == null) {
            return;
        }
        if (LIGHT_SOURCES.size() > 64) {
            DynamicLightingManager.removeOldestLightSources();
        }
        Iterator<Map.Entry<Entity, LightSourceData>> iterator = LIGHT_SOURCES.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Entity, LightSourceData> entry = iterator.next();
            Entity entity = entry.getKey();
            LightSourceData data = entry.getValue();
            if (!DynamicLightingManager.isValidLightSource(entity)) {
                iterator.remove();
                DynamicLightingManager.updateLightBlock(data.position, false);
                continue;
            }
            BlockPos newPos = DynamicLightingManager.calculateLightPosition(entity);
            if (newPos.equals((Object)data.position)) continue;
            DynamicLightingManager.updateLightBlock(data.position, false);
            DynamicLightingManager.updateLightBlock(newPos, true);
            LIGHT_SOURCES.put(entity, new LightSourceData(newPos, data.lightLevel));
        }
        AABB searchArea = new AABB(player.m_20183_()).m_82400_(24.0);
        List nearbyEntities = level.m_6249_((Entity)null, searchArea, DynamicLightingManager::isEntityTypeSupported);
        for (Entity entity : nearbyEntities) {
            if (LIGHT_SOURCES.containsKey(entity) || !DynamicLightingManager.isValidLightSource(entity)) continue;
            BlockPos pos = DynamicLightingManager.calculateLightPosition(entity);
            LIGHT_SOURCES.put(entity, new LightSourceData(pos, 12));
            DynamicLightingManager.updateLightBlock(pos, true);
        }
    }

    private static boolean isEntityTypeSupported(Entity entity) {
        return SUPPORTED_ENTITIES.contains(entity.m_6095_());
    }

    private static void removeOldestLightSources() {
        ArrayList<Map.Entry<Entity, LightSourceData>> sortedEntries = new ArrayList<Map.Entry<Entity, LightSourceData>>(LIGHT_SOURCES.entrySet());
        sortedEntries.sort(Comparator.comparingLong(e -> ((LightSourceData)e.getValue()).lastUpdate));
        int toRemove = LIGHT_SOURCES.size() - 64 + 10;
        for (int i = 0; i < toRemove && i < sortedEntries.size(); ++i) {
            Map.Entry entry = (Map.Entry)sortedEntries.get(i);
            LIGHT_SOURCES.remove(entry.getKey());
            DynamicLightingManager.updateLightBlock(((LightSourceData)entry.getValue()).position, false);
        }
    }

    private static void cleanupExpiredCaches() {
        VISIBILITY_CACHE.entrySet().removeIf(entry -> ((VisibilityCache)entry.getValue()).isExpired());
    }

    private static void updateLightBlock(BlockPos pos, boolean addLight) {
        ClientLevel level = DynamicLightingManager.getMinecraft().f_91073_;
        if (level != null) {
            level.m_7726_().m_7827_().m_7174_(pos);
        }
    }

    private static boolean isValidLightSource(Entity entity) {
        return entity != null && entity.m_6084_() && SUPPORTED_ENTITIES.contains(entity.m_6095_()) && DynamicLightingManager.isWearingDiggerHelmet(entity) && DynamicLightingManager.isEntityVisible(entity);
    }

    private static boolean isWearingDiggerHelmet(Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (living.m_6844_(EquipmentSlot.HEAD).m_41720_() instanceof DiggerHelmetItem) {
                return true;
            }
            return DiggerHelmet.isCuriosLoaded() && CuriosLightingIntegration.isWearingDiggerHelmet((Entity)living);
        }
        if (entity instanceof ArmorStand) {
            ArmorStand armorStand = (ArmorStand)entity;
            return armorStand.m_6844_(EquipmentSlot.HEAD).m_41720_() instanceof DiggerHelmetItem;
        }
        return false;
    }

    private static boolean isEntityVisible(Entity entity) {
        double checkRange;
        VisibilityCache cached = VISIBILITY_CACHE.get(entity);
        if (cached != null && !cached.isExpired()) {
            return cached.isVisible;
        }
        LocalPlayer player = DynamicLightingManager.getMinecraft().f_91074_;
        if (player == null || entity == null) {
            return false;
        }
        double distanceSquared = player.m_20280_(entity);
        double d = checkRange = entity.m_6095_() == EntityType.f_20529_ ? 36.0 : 24.0;
        if (distanceSquared > checkRange * checkRange) {
            VISIBILITY_CACHE.put(entity, new VisibilityCache(false));
            return false;
        }
        Vec3 targetPos = entity.m_6095_() == EntityType.f_20529_ ? new Vec3(entity.m_20185_(), entity.m_20186_() + 1.2, entity.m_20189_()) : entity.m_146892_();
        BlockHitResult result = player.m_9236_().m_45547_(new ClipContext(player.m_146892_(), targetPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
        boolean isVisible = result.m_6662_() == HitResult.Type.MISS;
        VISIBILITY_CACHE.put(entity, new VisibilityCache(isVisible));
        return isVisible;
    }

    private static BlockPos calculateLightPosition(Entity entity) {
        if (entity.m_6095_() == EntityType.f_20529_) {
            return BlockPos.m_274561_((double)entity.m_20185_(), (double)(entity.m_20186_() + 1.2), (double)entity.m_20189_());
        }
        return BlockPos.m_274561_((double)entity.m_20185_(), (double)entity.m_20188_(), (double)entity.m_20189_());
    }

    public static int getLightLevel(BlockPos pos) {
        if (DiggerHelmet.isSDLLoaded() || DynamicLightingManager.getMinecraft().f_91073_ == null) {
            return 0;
        }
        for (LightSourceData data : LIGHT_SOURCES.values()) {
            if (!data.position.equals((Object)pos)) continue;
            return data.lightLevel;
        }
        int maxLight = 0;
        for (LightSourceData data : LIGHT_SOURCES.values()) {
            double distance = Math.sqrt(data.position.m_123331_((Vec3i)pos));
            if (!(distance < 1.5)) continue;
            int lightLevel = (int)((double)data.lightLevel * (1.5 - distance));
            maxLight = Math.max(maxLight, lightLevel);
        }
        return maxLight;
    }

    public static void clearAllLights() {
        if (!DiggerHelmet.isSDLLoaded()) {
            LIGHT_SOURCES.values().forEach(data -> DynamicLightingManager.updateLightBlock(data.position, false));
            LIGHT_SOURCES.clear();
        }
        VISIBILITY_CACHE.clear();
    }

    public static int getLightSourceCount() {
        if (DiggerHelmet.isSDLLoaded()) {
            try {
                Class<?> sdlClass = Class.forName("toni.sodiumdynamiclights.SodiumDynamicLights");
                Object sdlInstance = sdlClass.getMethod("get", new Class[0]).invoke(null, new Object[0]);
                return (Integer)sdlClass.getMethod("getLightSourcesCount", new Class[0]).invoke(sdlInstance, new Object[0]);
            }
            catch (Exception e) {
                return 0;
            }
        }
        return LIGHT_SOURCES.size();
    }

    public static String getPerformanceStats() {
        return String.format("Lights: %d, Cached visibility: %d, Update interval: %d ticks", LIGHT_SOURCES.size(), VISIBILITY_CACHE.size(), 5);
    }

    public static void forceUpdate() {
        if (!DiggerHelmet.isSDLLoaded()) {
            DynamicLightingManager.updateLightSources();
        }
    }

    private static class LightSourceData {
        final BlockPos position;
        final long lastUpdate;
        final int lightLevel;

        LightSourceData(BlockPos position, int lightLevel) {
            this.position = position;
            this.lightLevel = lightLevel;
            this.lastUpdate = System.currentTimeMillis();
        }
    }

    private static class VisibilityCache {
        final boolean isVisible;
        final long timestamp;

        VisibilityCache(boolean isVisible) {
            this.isVisible = isVisible;
            this.timestamp = System.currentTimeMillis();
        }

        boolean isExpired() {
            return System.currentTimeMillis() - this.timestamp > 3000L;
        }
    }
}

