/*
 * Decompiled with CFR 0.152.
 */
package dev.thomas.diggerhelmet.common.item;

import dev.thomas.diggerhelmet.DiggerHelmet;
import dev.thomas.diggerhelmet.common.item.DiggerHelmetItem;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public enum DiggerHelmetArmor implements ArmorMaterial
{
    DIGGER_HELMET("digger_helmet", 6, new int[]{2, 0, 0, 0}, 10, SoundEvents.f_11677_, 0.0f, 0.0f);

    private final String name;
    private final int maxDamageFactor;
    private final int[] protectionAmounts;
    private final int enchantment;
    private final SoundEvent soundEvent;
    private final float toughness;
    private final float knockbackResistance;
    private static final int[] BASE_DURABILITY;

    private DiggerHelmetArmor(String name, int maxDamageFactor, int[] protectionAmounts, int enchantment, SoundEvent soundEvent, float toughness, float knockbackResistance) {
        this.name = name;
        this.maxDamageFactor = maxDamageFactor;
        this.protectionAmounts = protectionAmounts;
        this.enchantment = enchantment;
        this.soundEvent = soundEvent;
        this.toughness = toughness;
        this.knockbackResistance = knockbackResistance;
    }

    public int m_266425_(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull ArmorItem.Type pType) {
        return BASE_DURABILITY[pType.ordinal()] * this.maxDamageFactor;
    }

    public int m_7366_(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull ArmorItem.Type pType) {
        return this.protectionAmounts[pType.ordinal()];
    }

    public int m_6646_() {
        return this.enchantment;
    }

    @NotNull
    public SoundEvent m_7344_() {
        return this.soundEvent;
    }

    @NotNull
    public Ingredient m_6230_() {
        return Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.f_42416_)});
    }

    @NotNull
    public String m_6082_() {
        return this.name;
    }

    public float m_6651_() {
        return this.toughness;
    }

    public float m_6649_() {
        return this.knockbackResistance;
    }

    public Object getTempModifier(ItemStack stack) {
        if (!DiggerHelmet.isTFCAmbientalLoaded()) {
            return this.createEmptyTempModifier();
        }
        try {
            if (!(stack.m_41720_() instanceof DiggerHelmetItem)) {
                return this.createEmptyTempModifier();
            }
            String liningType = DiggerHelmetItem.getLiningType(stack);
            if (liningType == null) {
                return this.createEmptyTempModifier();
            }
            if ("wool".equals(liningType)) {
                return this.createWoolTempModifier(stack);
            }
            if ("silk".equals(liningType)) {
                return this.createSilkTempModifier(stack);
            }
            return this.createEmptyTempModifier();
        }
        catch (Exception e) {
            return this.createEmptyTempModifier();
        }
    }

    private Object createWoolTempModifier(ItemStack stack) {
        try {
            Class<?> tempModifierClass = Class.forName("com.lumintorious.tfcambiental.modifier.TempModifier");
            return tempModifierClass.getConstructor(String.class, Float.TYPE, Float.TYPE).newInstance(ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).toString(), Float.valueOf(4.0f), Float.valueOf(1.5f));
        }
        catch (Exception e) {
            return this.createEmptyTempModifier();
        }
    }

    private Object createSilkTempModifier(ItemStack stack) {
        try {
            Class<?> tempModifierClass = Class.forName("com.lumintorious.tfcambiental.modifier.TempModifier");
            return tempModifierClass.getConstructor(String.class, Float.TYPE, Float.TYPE).newInstance(ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).toString(), Float.valueOf(-1.0f), Float.valueOf(1.0f));
        }
        catch (Exception e) {
            return this.createEmptyTempModifier();
        }
    }

    private Object createEmptyTempModifier() {
        try {
            Class<?> tempModifierClass = Class.forName("com.lumintorious.tfcambiental.modifier.TempModifier");
            return tempModifierClass.getConstructor(String.class, Float.TYPE, Float.TYPE).newInstance("diggerhelmet:empty", Float.valueOf(0.0f), Float.valueOf(0.0f));
        }
        catch (Exception e) {
            DiggerHelmet.LOGGER.warn("Could not create empty temperature modifier in DiggerHelmetArmor", (Throwable)e);
            return null;
        }
    }

    static {
        BASE_DURABILITY = new int[]{13, 15, 16, 11};
    }
}

