/*
 * Decompiled with CFR 0.152.
 */
package dev.thomas.diggerhelmet.common.item;

import dev.thomas.diggerhelmet.DiggerHelmet;
import dev.thomas.diggerhelmet.client.model.DiggerHelmetModel;
import dev.thomas.diggerhelmet.client.model.DiggerHelmetRenderer;
import dev.thomas.diggerhelmet.common.init.registries.ModItems;
import dev.thomas.diggerhelmet.common.item.AutoDrinkerItem;
import dev.thomas.diggerhelmet.common.item.DiggerHelmetArmor;
import dev.thomas.diggerhelmet.common.item.DiggerHelmetContainer;
import dev.thomas.diggerhelmet.integration.CuriosIntegration;
import dev.thomas.diggerhelmet.integration.DiggerHelmetThermalMaterial;
import java.util.List;
import java.util.function.Consumer;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.common.capabilities.food.TFCFoodData;
import net.dries007.tfc.common.capabilities.player.PlayerData;
import net.dries007.tfc.util.Drinkable;
import net.dries007.tfc.util.calendar.Calendars;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.renderer.GeoArmorRenderer;
import top.theillusivec4.curios.api.CuriosApi;

public class DiggerHelmetItem
extends ArmorItem
implements GeoItem {
    private static final ResourceLocation ARMOR_TEXTURE = new ResourceLocation("diggerhelmet", "textures/models/armor/digger_helmet_layer_1.png");
    private static final String ARMOR_TEXTURE_STR = ARMOR_TEXTURE.toString();
    private static final String HELMET_INVENTORY_TAG = "HelmetInventory";
    private static final double PARTICLE_CHANCE = 0.15;
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);

    public DiggerHelmetItem() {
        super(DiggerHelmetItem.getHelmetMaterial(), ArmorItem.Type.HELMET, new Item.Properties().m_41487_(1).m_41497_(Rarity.COMMON));
    }

    private static ArmorMaterial getHelmetMaterial() {
        if (DiggerHelmet.isTFCAmbientalLoaded()) {
            try {
                Object proxy;
                DiggerHelmetThermalMaterial thermalMaterial = DiggerHelmetThermalMaterial.INSTANCE;
                if (thermalMaterial.hasTemperatureSupport() && (proxy = thermalMaterial.getTemperatureAlteringProxy()) instanceof ArmorMaterial) {
                    return (ArmorMaterial)proxy;
                }
                return thermalMaterial;
            }
            catch (Exception e) {
                DiggerHelmet.LOGGER.warn("Error creating thermal material, falling back to default", (Throwable)e);
            }
        }
        return DiggerHelmetArmor.DIGGER_HELMET;
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        return ARMOR_TEXTURE_STR;
    }

    public static boolean hasSpeedModifier(ItemStack helmetStack) {
        if (helmetStack == null || helmetStack.m_41619_()) {
            return false;
        }
        if (!(helmetStack.m_41720_() instanceof DiggerHelmetItem)) {
            return false;
        }
        try {
            CompoundTag tag = helmetStack.m_41783_();
            if (tag == null || !tag.m_128441_(HELMET_INVENTORY_TAG)) {
                return false;
            }
            CompoundTag invTag = tag.m_128469_(HELMET_INVENTORY_TAG);
            if (invTag == null) {
                return false;
            }
            ListTag items = invTag.m_128437_("Items", 10);
            if (items == null || items.isEmpty()) {
                return false;
            }
            CompoundTag itemTag = items.m_128728_(1);
            if (itemTag != null) {
                ItemStack stack = ItemStack.m_41712_((CompoundTag)itemTag);
                return !stack.m_41619_() && stack.m_41720_() == ModItems.MINING_SPEED_MODIFIER.get();
            }
        }
        catch (Exception e) {
            DiggerHelmet.LOGGER.warn("Error checking speed modifier in helmet", (Throwable)e);
        }
        return false;
    }

    public static boolean hasWoolLining(ItemStack helmetStack) {
        if (helmetStack == null || helmetStack.m_41619_()) {
            return false;
        }
        if (!(helmetStack.m_41720_() instanceof DiggerHelmetItem)) {
            return false;
        }
        try {
            CompoundTag tag = helmetStack.m_41783_();
            if (tag == null || !tag.m_128441_(HELMET_INVENTORY_TAG)) {
                return false;
            }
            CompoundTag invTag = tag.m_128469_(HELMET_INVENTORY_TAG);
            if (invTag == null) {
                return false;
            }
            ListTag items = invTag.m_128437_("Items", 10);
            if (items == null) {
                return false;
            }
            for (int i = 0; i < items.size(); ++i) {
                CompoundTag itemTag = items.m_128728_(i);
                if (itemTag == null || itemTag.m_128445_("Slot") != 2) continue;
                ItemStack stack = ItemStack.m_41712_((CompoundTag)itemTag);
                return !stack.m_41619_() && stack.m_41720_() == ModItems.WOOL_LINING.get();
            }
        }
        catch (Exception e) {
            DiggerHelmet.LOGGER.warn("Error checking wool lining in helmet", (Throwable)e);
        }
        return false;
    }

    public static boolean hasSilkLining(ItemStack helmetStack) {
        if (helmetStack == null || helmetStack.m_41619_()) {
            return false;
        }
        if (!(helmetStack.m_41720_() instanceof DiggerHelmetItem)) {
            return false;
        }
        try {
            CompoundTag tag = helmetStack.m_41783_();
            if (tag == null || !tag.m_128441_(HELMET_INVENTORY_TAG)) {
                return false;
            }
            CompoundTag invTag = tag.m_128469_(HELMET_INVENTORY_TAG);
            if (invTag == null) {
                return false;
            }
            ListTag items = invTag.m_128437_("Items", 10);
            if (items == null) {
                return false;
            }
            for (int i = 0; i < items.size(); ++i) {
                CompoundTag itemTag = items.m_128728_(i);
                if (itemTag == null || itemTag.m_128445_("Slot") != 2) continue;
                ItemStack stack = ItemStack.m_41712_((CompoundTag)itemTag);
                return !stack.m_41619_() && stack.m_41720_() == ModItems.SILK_LINING.get();
            }
        }
        catch (Exception e) {
            DiggerHelmet.LOGGER.warn("Error checking silk lining in helmet", (Throwable)e);
        }
        return false;
    }

    public static String getLiningType(ItemStack helmetStack) {
        if (DiggerHelmetItem.hasWoolLining(helmetStack)) {
            return "wool";
        }
        if (DiggerHelmetItem.hasSilkLining(helmetStack)) {
            return "silk";
        }
        return null;
    }

    public boolean canWalkOnPowderedSnow(ItemStack stack, LivingEntity wearer) {
        return DiggerHelmetItem.hasSpeedModifier(stack);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private static GeoArmorRenderer<?> renderer;

            @NotNull
            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity entity, ItemStack stack, EquipmentSlot slot, HumanoidModel<?> original) {
                if (renderer == null) {
                    renderer = new DiggerHelmetRenderer(new DiggerHelmetModel());
                }
                renderer.prepForRender((Entity)entity, stack, slot, original);
                return renderer;
            }
        });
    }

    public boolean canEquip(ItemStack stack, EquipmentSlot slot, Entity entity) {
        if (slot != EquipmentSlot.HEAD) {
            return false;
        }
        boolean hasInCurios = CuriosApi.getCuriosInventory((LivingEntity)((LivingEntity)entity)).map(inv -> !inv.findCurios((Item)this).isEmpty()).orElse(false);
        return !hasInCurios;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return DiggerHelmet.isCuriosLoaded() ? CuriosIntegration.createCurioProvider(stack) : super.initCapabilities(stack, nbt);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (player.m_6144_()) {
            if (!level.m_5776_()) {
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new SimpleMenuProvider((windowId, playerInv, playerEntity) -> new DiggerHelmetContainer(windowId, playerInv, itemstack), (Component)Component.m_237113_((String)"Digger Helmet").m_130940_(ChatFormatting.GOLD)), buf -> buf.m_130055_(itemstack));
            }
            return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)level.m_5776_());
        }
        boolean hasInCurios = CuriosApi.getCuriosInventory((LivingEntity)player).map(inv -> !inv.findCurios((Item)this).isEmpty()).orElse(false);
        if (hasInCurios || !player.m_6844_(EquipmentSlot.HEAD).m_41619_()) {
            return InteractionResultHolder.m_19100_((Object)itemstack);
        }
        EquipmentSlot slot = EquipmentSlot.HEAD;
        player.m_8061_(slot, itemstack.m_41620_(1));
        if (!level.m_5776_()) {
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        }
        return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)level.m_5776_());
    }

    public void onArmorTick(ItemStack helmetStack, Level level, Player player) {
        super.onArmorTick(helmetStack, level, player);
        if (level.f_46443_) {
            this.spawnCandleParticles(level, player, level.f_46441_);
        } else {
            if (this.hasAutoDrinker(helmetStack)) {
                return;
            }
            CompoundTag tag = helmetStack.m_41784_();
            int cooldown = tag.m_128451_("cooldown");
            if (cooldown > 0) {
                tag.m_128405_("cooldown", cooldown - 1);
                return;
            }
            if (this.shouldDrink(player) && this.tryDrink(player, level)) {
                tag.m_128405_("cooldown", AutoDrinkerItem.getDefaultCooldown());
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnCandleParticles(Level level, Player player, RandomSource random) {
        if (player.f_19797_ % 3 != 0) {
            return;
        }
        if (random.m_188500_() < 0.15) {
            List<Vec3> offsets = List.of(new Vec3(0.0, 0.9, 0.25));
            float yaw = player.f_20885_ * ((float)Math.PI / 180);
            double sin = Math.sin(yaw);
            double cos = Math.cos(yaw);
            for (Vec3 offset : offsets) {
                double rotatedX = offset.f_82479_ * cos - offset.f_82481_ * sin;
                double rotatedZ = offset.f_82479_ * sin + offset.f_82481_ * cos;
                double x = player.m_20185_() + rotatedX;
                double y = player.m_20186_() + (double)player.m_20192_() - 0.4 + offset.f_82480_;
                double z = player.m_20189_() + rotatedZ;
                double dx = random.m_188500_() * 0.2 - 0.1;
                double dy = random.m_188500_() * 0.1;
                double dz = random.m_188500_() * 0.2 - 0.1;
                double motionX = random.m_188500_() * 0.005 - 0.0025;
                double motionY = random.m_188500_() * 0.02;
                double motionZ = random.m_188500_() * 0.005 - 0.0025;
                level.m_7106_((ParticleOptions)ParticleTypes.f_175834_, x + dx, y + dy, z + dz, motionX, motionY, motionZ);
            }
        }
    }

    private boolean hasAutoDrinker(ItemStack helmetStack) {
        CompoundTag tag = helmetStack.m_41783_();
        if (tag == null || !tag.m_128441_(HELMET_INVENTORY_TAG)) {
            return true;
        }
        ListTag items = tag.m_128469_(HELMET_INVENTORY_TAG).m_128437_("Items", 10);
        for (Tag itemTag : items) {
            ItemStack stack = ItemStack.m_41712_((CompoundTag)((CompoundTag)itemTag));
            if (!(stack.m_41720_() instanceof AutoDrinkerItem)) continue;
            return false;
        }
        return true;
    }

    private boolean shouldDrink(Player player) {
        if (player.m_7500_()) {
            return false;
        }
        PlayerData data = PlayerData.get((Player)player);
        return data.getLastDrinkTick() + 10L < Calendars.get((LevelReader)player.m_9236_()).getTicks();
    }

    private boolean isValidDrink(Player player, ItemStack stack) {
        IFluidHandlerItem handler = (IFluidHandlerItem)stack.getCapability(Capabilities.FLUID_ITEM).orElse(null);
        if (handler == null) {
            return false;
        }
        FluidStack fluid = handler.getFluidInTank(0);
        if (fluid.isEmpty() || !fluid.getFluid().m_205067_(AutoDrinkerItem.ALLOWED_FLUIDS)) {
            return false;
        }
        Drinkable drinkable = Drinkable.get((Fluid)fluid.getFluid());
        if (drinkable == null) {
            return false;
        }
        TFCFoodData foodData = (TFCFoodData)player.m_36324_();
        return foodData.getThirst() < 100.0f || drinkable.mayDrinkWhenFull();
    }

    private boolean tryDrink(Player player, Level level) {
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            FluidStack fluid;
            Drinkable drinkable;
            IFluidHandlerItem handler;
            ItemStack stack = player.m_150109_().m_8020_(i);
            if (!this.isValidDrink(player, stack) || stack.m_41720_() instanceof BucketItem || (handler = (IFluidHandlerItem)stack.getCapability(Capabilities.FLUID_ITEM).orElse(null)) == null || (drinkable = Drinkable.get((Fluid)(fluid = handler.getFluidInTank(0)).getFluid())) == null) continue;
            this.handleDrinking(player, handler, stack, i, drinkable, level);
            return true;
        }
        return false;
    }

    private void handleDrinking(Player player, IFluidHandlerItem handler, ItemStack stack, int slot, Drinkable drinkable, Level level) {
        FluidStack drained = handler.drain(AutoDrinkerItem.getDrinkAmount(), IFluidHandler.FluidAction.EXECUTE);
        if (drained.isEmpty()) {
            return;
        }
        drinkable.onDrink(player, AutoDrinkerItem.getDrinkAmount());
        this.updateContainer(player, handler, stack, slot);
        float pitch = level.f_46441_.m_188501_() * 0.1f + 0.9f;
        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11911_, SoundSource.PLAYERS, 0.5f, pitch);
        PlayerData.get((Player)player).setLastDrinkTick(Calendars.get((LevelReader)level).getTicks());
    }

    private void updateContainer(Player player, IFluidHandlerItem handler, ItemStack stack, int slot) {
        ItemStack newStack = handler.getContainer();
        if (stack.m_41613_() == 1) {
            player.m_150109_().m_6836_(slot, newStack);
        } else {
            stack.m_41774_(1);
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)newStack);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> components, @NotNull TooltipFlag flag) {
        components.add((Component)Component.m_237115_((String)"item.diggerhelmet.digger_helmet.main").m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.ITALIC}));
        if (level != null && level.m_5776_() && Screen.m_96638_()) {
            components.add((Component)Component.m_237115_((String)"tooltip.diggerhelmet.digger_helmet.shift_info").m_130940_(ChatFormatting.GRAY));
            components.add((Component)Component.m_237115_((String)"tooltip.diggerhelmet.digger_helmet.tooltip3").m_130940_(ChatFormatting.BLUE));
            if (DiggerHelmet.isTFCAmbientalLoaded()) {
                String liningType = DiggerHelmetItem.getLiningType(stack);
                if (liningType != null) {
                    if ("wool".equals(liningType)) {
                        components.add((Component)Component.m_237115_((String)"tooltip.diggerhelmet.digger_helmet.wool_lining_active").m_130940_(ChatFormatting.GREEN));
                    } else if ("silk".equals(liningType)) {
                        components.add((Component)Component.m_237115_((String)"tooltip.diggerhelmet.digger_helmet.silk_lining_active").m_130940_(ChatFormatting.AQUA));
                    }
                } else {
                    components.add((Component)Component.m_237115_((String)"tooltip.diggerhelmet.digger_helmet.lining_needed").m_130940_(ChatFormatting.YELLOW));
                }
            }
        } else {
            components.add((Component)Component.m_237115_((String)"tooltip.diggerhelmet.digger_helmet.hold_shift").m_130940_(ChatFormatting.DARK_GRAY));
        }
        this.addUnifiedArmorAttributes(components, stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void addUnifiedArmorAttributes(List<Component> components, ItemStack stack) {
        String liningType;
        components.add((Component)Component.m_237119_());
        components.add((Component)Component.m_237115_((String)"item.modifiers.head").m_130940_(ChatFormatting.GRAY));
        int armorValue = this.m_40401_().m_7366_(ArmorItem.Type.HELMET);
        if (armorValue > 0) {
            components.add((Component)Component.m_237113_((String)(" +" + armorValue + " ")).m_7220_((Component)Component.m_237115_((String)"attribute.name.generic.armor")).m_130940_(ChatFormatting.BLUE));
        }
        if (DiggerHelmet.isTFCAmbientalLoaded() && (liningType = DiggerHelmetItem.getLiningType(stack)) != null) {
            float change = 0.0f;
            float insulation = 0.0f;
            if ("wool".equals(liningType)) {
                change = 4.0f;
                insulation = 1.5f;
            } else if ("silk".equals(liningType)) {
                change = -1.0f;
                insulation = 1.0f;
            }
            if (change > 0.0f) {
                components.add((Component)Component.m_237113_((String)(" +" + String.format("%.1f", Float.valueOf(change)) + " ")).m_7220_((Component)Component.m_237115_((String)"tfcambiental.tooltip.thermoregulation")).m_130940_(ChatFormatting.BLUE));
            } else if (change < 0.0f) {
                components.add((Component)Component.m_237113_((String)(" " + String.format("%.1f", Float.valueOf(change)) + " ")).m_7220_((Component)Component.m_237115_((String)"tfcambiental.tooltip.thermoregulation")).m_130940_(ChatFormatting.AQUA));
            }
            if (insulation > 0.0f) {
                components.add((Component)Component.m_237113_((String)(" +" + String.format("%.1f", Float.valueOf(insulation)) + " ")).m_7220_((Component)Component.m_237115_((String)"tfcambiental.tooltip.thermal_insulation")).m_130940_(ChatFormatting.BLUE));
            }
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar registrar) {
        registrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    private PlayState predicate(AnimationState<DiggerHelmetItem> state) {
        state.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public boolean m_6832_(@NotNull ItemStack toRepair, @NotNull ItemStack repair) {
        return this.f_40379_.m_6230_().test(repair) || super.m_6832_(toRepair, repair);
    }

    @Nullable
    public EquipmentSlot getEquipmentSlot(ItemStack stack) {
        return EquipmentSlot.HEAD;
    }
}

